/*
 * Decompiled with CFR 0.152.
 */
package com.playtime;

import com.playtime.PlayTimeRecord;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.client.RuneLite;
import net.runelite.http.api.RuneLiteAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TimeRecordWriter {
    private static final Logger log = LoggerFactory.getLogger(TimeRecordWriter.class);
    private static final String FILE_EXTENSION = ".log";
    private static final File PLAY_TIME_DIR = new File(RuneLite.RUNELITE_DIR, "playTime");
    private String playerName;

    @Inject
    public TimeRecordWriter() {
        PLAY_TIME_DIR.mkdir();
    }

    public void setPlayerUsername(String username) {
        this.playerName = username;
    }

    public synchronized ArrayList<PlayTimeRecord> loadPlayTimeRecords() {
        if (this.playerName == null) {
            return new ArrayList<PlayTimeRecord>();
        }
        String fileName = this.playerName.trim() + FILE_EXTENSION;
        File file = new File(PLAY_TIME_DIR, fileName);
        ArrayList<PlayTimeRecord> data = new ArrayList<PlayTimeRecord>();
        if (!file.exists()) {
            return new ArrayList<PlayTimeRecord>();
        }
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.length() <= 0) continue;
                PlayTimeRecord r = (PlayTimeRecord)RuneLiteAPI.GSON.fromJson(line, PlayTimeRecord.class);
                data.add(r);
            }
        }
        catch (FileNotFoundException e) {
            log.debug("File not found: {}", (Object)fileName);
        }
        catch (IOException e) {
            log.warn("IOException for file {}: {}", (Object)fileName, (Object)e.getMessage());
        }
        return data;
    }

    public synchronized boolean writePlayTimeFile(ArrayList<PlayTimeRecord> times) {
        File timeFile = new File(PLAY_TIME_DIR, this.playerName.trim() + FILE_EXTENSION);
        try {
            BufferedWriter file = new BufferedWriter(new FileWriter(String.valueOf(timeFile), false));
            for (PlayTimeRecord rec : times) {
                String dataAsString = RuneLiteAPI.GSON.toJson((Object)rec);
                file.append(dataAsString);
                file.newLine();
            }
            file.close();
            return true;
        }
        catch (IOException ioe) {
            log.warn("Error rewriting loot data to file {}: {}", (Object)(this.playerName.trim() + FILE_EXTENSION), (Object)ioe.getMessage());
            return false;
        }
    }
}

