/*
 * Decompiled with CFR 0.152.
 */
package com.playtime;

import com.google.inject.Provides;
import com.playtime.PlayTimeConfig;
import com.playtime.PlayTimePanel;
import com.playtime.PlayTimeRecord;
import com.playtime.TimeRecordWriter;
import java.awt.image.BufferedImage;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Play Time")
public class PlayTimePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(PlayTimePlugin.class);
    private static final ZoneId UTC = ZoneId.of("UTC");
    private static final ZoneId JAGEX = ZoneId.of("Europe/London");
    public static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("dd.MM.yy");
    public static final String HANS_TIME_KEY = "OLD";
    private boolean ready = false;
    private boolean loadedData = false;
    private boolean loadedHans = false;
    private long sessionTicks = 0L;
    private long totalTicks = 0L;
    private PlayTimePanel panel;
    private NavigationButton navButton;
    @Inject
    private TimeRecordWriter writer;
    @Inject
    private Client client;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private PlayTimeConfig config;
    private PlayTimeRecord record;
    public HashMap<String, PlayTimeRecord> records = new HashMap();

    public long getSessionTicks() {
        return this.sessionTicks;
    }

    public long getTotalTicks() {
        return this.totalTicks;
    }

    protected void startUp() throws Exception {
        this.panel = new PlayTimePanel(this);
        BufferedImage icon = ImageUtil.getResourceStreamFromClass(((Object)((Object)this)).getClass(), (String)"pluginicon.png");
        this.navButton = NavigationButton.builder().tooltip("Play Time").priority(6).icon(icon).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.navButton);
        if (this.client.getGameState().equals((Object)GameState.LOGGED_IN) || this.client.getGameState().equals((Object)GameState.LOADING)) {
            this.loadData();
        }
        this.panel.showView();
    }

    public PlayTimeConfig getConfig() {
        return this.config;
    }

    protected void shutDown() throws Exception {
        this.clientToolbar.removeNavigation(this.navButton);
        this.saveData();
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            this.panel.showView();
            return;
        }
        Widget npcHead = this.client.getWidget(WidgetInfo.DIALOG_NPC_HEAD_MODEL);
        if (npcHead != null && npcHead.getModelId() == 3105 && !this.loadedHans) {
            Widget textw = this.client.getWidget(WidgetInfo.DIALOG_NPC_TEXT);
            String text = textw.getText();
            text = text.replaceAll("<br>", "");
            Matcher m = Pattern.compile("([0-9]+)[^0-9]*([0-9]+)[^0-9]*([0-9]+)").matcher(text);
            if (m.find() && m.groupCount() == 3 && text.startsWith("You've spent")) {
                PlayTimeRecord rec;
                long days = Long.parseLong(m.group(1));
                long hours = Long.parseLong(m.group(2));
                long mins = Long.parseLong(m.group(3));
                long total = days * 100L * 60L * 24L + hours * 100L * 60L + mins * 100L;
                if (this.records != null) {
                    long trackedTime = 0L;
                    for (int i = 0; i < this.records.size(); ++i) {
                        PlayTimeRecord rec2 = this.records.get(i);
                        if (rec2 == null || rec2.getDate() == HANS_TIME_KEY) continue;
                        trackedTime += rec2.getTime();
                    }
                    this.totalTicks = (total -= trackedTime) + trackedTime;
                }
                if ((rec = this.records.get(HANS_TIME_KEY)) == null) {
                    rec = new PlayTimeRecord(HANS_TIME_KEY, total);
                    this.records.put(HANS_TIME_KEY, rec);
                } else {
                    rec.setTime(total);
                }
                if (this.records == null) {
                    this.totalTicks = total;
                }
                this.saveData();
                this.loadedHans = true;
            }
        } else if (npcHead == null || npcHead.getModelId() != 3105) {
            this.loadedHans = false;
        }
        ++this.sessionTicks;
        ++this.totalTicks;
        PlayTimeRecord rec = this.getCurrentRecord();
        rec.setTime(rec.getTime() + 1L);
        if (this.sessionTicks % 10L == 0L) {
            this.saveData();
        }
        this.loadData();
        this.panel.showView();
    }

    public PlayTimeRecord getCurrentRecord() {
        if (!this.loadedData) {
            return null;
        }
        if (this.record != null && this.record.getDate() == LocalDate.now().format(DATE_FORMAT)) {
            return this.record;
        }
        PlayTimeRecord rec = this.records.get(LocalDate.now().format(DATE_FORMAT));
        if (rec == null) {
            rec = new PlayTimeRecord(LocalDate.now().format(DATE_FORMAT), 0L);
            this.records.put(rec.getDate(), rec);
        }
        this.record = rec;
        return rec;
    }

    public void resetCounter() {
        this.sessionTicks = 0L;
    }

    public void loadData() {
        if (this.loadedData) {
            return;
        }
        this.writer.setPlayerUsername(this.client.getUsername());
        ArrayList<PlayTimeRecord> recs = this.writer.loadPlayTimeRecords();
        this.totalTicks = 0L;
        recs.forEach(rec -> {
            this.totalTicks += rec.getTime();
            this.records.put(rec.getDate(), (PlayTimeRecord)rec);
        });
        this.loadedData = true;
    }

    public void saveData() {
        if (!this.loadedData) {
            return;
        }
        ArrayList<PlayTimeRecord> recs = new ArrayList<PlayTimeRecord>();
        this.records.forEach((k, v) -> recs.add((PlayTimeRecord)v));
        this.writer.writePlayTimeFile(recs);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        GameState state = event.getGameState();
        if (this.panel != null) {
            this.panel.showView();
        }
        switch (state) {
            case LOGGING_IN: 
            case HOPPING: 
            case CONNECTION_LOST: {
                this.ready = true;
                this.panel.showView();
                break;
            }
            case LOGGED_IN: {
                if (this.ready) {
                    this.loadData();
                    this.ready = false;
                }
                this.panel.showView();
                break;
            }
            case LOGIN_SCREEN: {
                this.sessionTicks = 0L;
                this.panel.showView();
            }
        }
    }

    @Provides
    PlayTimeConfig provideConfig(ConfigManager configManager) {
        return (PlayTimeConfig)configManager.getConfig(PlayTimeConfig.class);
    }
}

