/*
 * Decompiled with CFR 0.152.
 */
package com.playtime;

import com.playtime.PlayTimePlugin;
import com.playtime.PlayTimeRecord;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.PluginErrorPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayTimePanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(PlayTimePanel.class);
    private static final Color BACKGROUND_COLOR = ColorScheme.DARK_GRAY_COLOR;
    private static final Color BUTTON_HOVER_COLOR = ColorScheme.DARKER_GRAY_HOVER_COLOR;
    private final PlayTimePlugin plugin;
    private JLabel totalTime = new JLabel();
    private JLabel sessionTime = new JLabel();
    private JLabel dayTime = new JLabel();
    private JLabel weekTime = new JLabel();
    private JLabel weekAverage = new JLabel();
    private JLabel monthTime = new JLabel();
    private JLabel monthAverage = new JLabel();
    private boolean shown = false;

    public PlayTimePanel(PlayTimePlugin plugin) {
        super(false);
        this.plugin = plugin;
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setLayout(new BorderLayout());
    }

    public void showView() {
        this.updateTimes();
        if (this.shown) {
            return;
        }
        this.shown = true;
        PluginErrorPanel errorPanel = new PluginErrorPanel();
        errorPanel.setBorder((Border)new EmptyBorder(10, 25, 10, 25));
        errorPanel.setContent("Play Time", "Time played");
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(this.sessionTime);
        panel.add(this.dayTime);
        panel.add(this.weekTime);
        panel.add(this.weekAverage);
        panel.add(this.monthTime);
        panel.add(this.monthAverage);
        panel.add(this.totalTime);
        JPanel panel2 = new JPanel();
        JButton button = new JButton("Reset session counter");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlayTimePanel.this.plugin.resetCounter();
            }
        });
        panel2.add(button);
        this.add((Component)errorPanel, "North");
        this.add(this.wrapContainer(panel), "Center");
        this.add(panel2, "South");
        this.revalidate();
        this.repaint();
    }

    public void updateTimes() {
        if (this.plugin.getSessionTicks() == 0L) {
            this.sessionTime.setText("Login for times to be displayed");
            this.dayTime.setText("");
            this.weekTime.setText("");
            this.weekAverage.setText("");
            this.monthTime.setText("");
            this.monthAverage.setText("");
            this.totalTime.setText("");
            return;
        }
        if (this.plugin.getConfig().showSeconds() || this.plugin.getSessionTicks() % 100L == 0L) {
            PlayTimeRecord rec = this.plugin.getCurrentRecord();
            this.sessionTime.setText("Session: " + (rec != null ? this.getTimeStampFromTicks(this.plugin.getSessionTicks()) : "?"));
            this.dayTime.setText("Today: " + (rec != null ? this.getTimeStampFromTicks(rec.getTime()) : "?"));
            if (rec == null) {
                this.weekTime.setText("This week: ?");
                this.monthTime.setText("This month: ?");
                this.totalTime.setText("Total: ?");
                if (this.plugin.getConfig().showAverages()) {
                    this.weekAverage.setText("This week average: ?");
                    this.monthAverage.setText("This month average: ?");
                }
            } else {
                DayOfWeek firstDayOfWeek = WeekFields.of(Locale.getDefault()).getFirstDayOfWeek();
                LocalDate startDate = LocalDate.now().with(TemporalAdjusters.previousOrSame(firstDayOfWeek));
                LocalDate endDate = LocalDate.now();
                long weekTicks = this.ticksBetweenDates(startDate, endDate);
                startDate = LocalDate.now().withDayOfMonth(1);
                long monthTicks = this.ticksBetweenDates(startDate, endDate);
                this.weekTime.setText("This week: " + this.getTimeStampFromTicks(weekTicks));
                this.monthTime.setText("This month: " + this.getTimeStampFromTicks(monthTicks));
                this.totalTime.setText("Total: " + this.getTimeStampFromTicks(this.plugin.getTotalTicks()));
                if (this.plugin.getConfig().showAverages()) {
                    startDate = LocalDate.now().with(TemporalAdjusters.previousOrSame(firstDayOfWeek));
                    this.weekAverage.setText("This week average: " + this.getTimeStampFromTicks(weekTicks / ChronoUnit.DAYS.between(startDate, endDate)));
                    startDate = LocalDate.now().withDayOfMonth(1);
                    this.monthAverage.setText("This month average: " + this.getTimeStampFromTicks(monthTicks / ChronoUnit.DAYS.between(startDate, endDate)));
                }
            }
        }
    }

    private long ticksBetweenDates(LocalDate startDate, LocalDate endDate) {
        long days = ChronoUnit.DAYS.between(startDate, endDate);
        ArrayList<LocalDate> dates = new ArrayList<LocalDate>();
        int i = 0;
        while ((long)i <= days) {
            LocalDate d = startDate.plusDays(i);
            dates.add(d);
            ++i;
        }
        long ticks = 0L;
        int i2 = 0;
        while ((long)i2 <= days) {
            PlayTimeRecord r = this.plugin.records.get(((LocalDate)dates.get(i2)).format(PlayTimePlugin.DATE_FORMAT));
            if (r != null) {
                ticks += r.getTime();
            }
            ++i2;
        }
        return ticks;
    }

    private String getTimeStampFromTicks(long time) {
        long days = (long)Math.floor((double)time / 144000.0);
        long hours = (long)Math.floor((double)(time -= days * 144000L) / 6000.0);
        long min = (long)Math.floor((double)(time -= hours * 100L * 60L) / 100.0);
        time -= min * 100L;
        if (this.plugin.getConfig().showSeconds()) {
            return String.format("%dd, %dh, %dm, %ds", days, hours, min, (long)((double)time * 0.6));
        }
        return String.format("%dd, %dh, %dm", days, hours, min);
    }

    private JScrollPane wrapContainer(JPanel container) {
        JPanel wrapped = new JPanel(new BorderLayout());
        wrapped.add((Component)container, "North");
        wrapped.setBackground(BACKGROUND_COLOR);
        JScrollPane scroller = new JScrollPane(wrapped);
        scroller.setHorizontalScrollBarPolicy(31);
        scroller.getVerticalScrollBar().setPreferredSize(new Dimension(8, 0));
        scroller.setBackground(BACKGROUND_COLOR);
        return scroller;
    }
}

