/*
 * Decompiled with CFR 0.152.
 */
package com.regionlocker;

import com.google.inject.Provides;
import com.regionlocker.RegionBorderOverlay;
import com.regionlocker.RegionLocker;
import com.regionlocker.RegionLockerConfig;
import com.regionlocker.RegionLockerInput;
import com.regionlocker.RegionLockerOverlay;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.FocusChanged;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.widgets.Widget;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;

@PluginDescriptor(name="Region Locker", description="Settings for the Region Locker plugin.", tags={"region", "locker", "chunk", "map", "square"})
public class RegionLockerPlugin
extends Plugin {
    static final String PLUGIN_NAME = "Region Locker";
    static final String CONFIG_KEY = "regionlocker";
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private RegionLockerConfig config;
    @Inject
    private RegionLockerOverlay regionLockerOverlay;
    @Inject
    private RegionBorderOverlay regionBorderOverlay;
    @Inject
    private RegionLockerInput inputListener;
    @Inject
    private KeyManager keyManager;
    @Inject
    private ConfigManager configManager;
    private boolean unlockKeyPressed = false;
    private boolean blockKeyPressed = false;
    private int hoveredRegion = -1;
    private RegionLocker regionLocker;

    @Provides
    RegionLockerConfig provideConfig(ConfigManager configManager) {
        return (RegionLockerConfig)configManager.getConfig(RegionLockerConfig.class);
    }

    protected void startUp() throws Exception {
        this.regionLocker = new RegionLocker(this.config, this.configManager);
        this.overlayManager.add((Overlay)this.regionLockerOverlay);
        this.overlayManager.add((Overlay)this.regionBorderOverlay);
        this.keyManager.registerKeyListener((KeyListener)this.inputListener);
        this.setKeys();
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.regionLockerOverlay);
        this.overlayManager.remove((Overlay)this.regionBorderOverlay);
        this.keyManager.unregisterKeyListener((KeyListener)this.inputListener);
        RegionLocker.renderLockedRegions = false;
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals(CONFIG_KEY)) {
            return;
        }
        this.setKeys();
        this.regionLocker.readConfig();
    }

    @Subscribe
    public void onFocusChanged(FocusChanged focusChanged) {
        if (!focusChanged.isFocused()) {
            this.unlockKeyPressed = false;
            this.blockKeyPressed = false;
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        Widget map = this.client.getWidget(38993927);
        if (!this.unlockKeyPressed && !this.blockKeyPressed || this.hoveredRegion == -1 || map == null) {
            return;
        }
        if (this.unlockKeyPressed) {
            this.regionLocker.addRegion(this.hoveredRegion);
        }
        if (this.blockKeyPressed) {
            this.regionLocker.blockRegion(this.hoveredRegion);
        }
    }

    private void setKeys() {
        RegionLockerInput.UNLOCK_KEY = this.config.unlockKey();
        RegionLockerInput.BLOCK_KEY = this.config.blacklistKey();
    }

    void setUnlockKeyPressed(boolean unlockKeyPressed) {
        this.unlockKeyPressed = unlockKeyPressed;
    }

    void setBlockKeyPressed(boolean blockKeyPressed) {
        this.blockKeyPressed = blockKeyPressed;
    }

    void setHoveredRegion(int hoveredRegion) {
        this.hoveredRegion = hoveredRegion;
    }

    public int getHoveredRegion() {
        return this.hoveredRegion;
    }
}

