/*
 * Decompiled with CFR 0.152.
 */
package com.regionlocker;

import com.google.inject.Inject;
import com.regionlocker.RegionLocker;
import com.regionlocker.RegionLockerConfig;
import com.regionlocker.RegionLockerPlugin;
import com.regionlocker.RegionTypes;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.api.widgets.Widget;
import net.runelite.api.worldmap.WorldMap;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;

class RegionLockerOverlay
extends Overlay {
    private static final Color WHITE_TRANSLUCENT = new Color(255, 255, 255, 127);
    private static final int LABEL_PADDING = 4;
    private static final int REGION_SIZE = 64;
    private static final int REGION_TRUNCATE = -64;
    private final Client client;
    private final RegionLockerPlugin regionLockerPlugin;
    private final RegionLockerConfig config;

    @Inject
    private RegionLockerOverlay(Client client, RegionLockerPlugin regionLockerPlugin, RegionLockerConfig config) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.HIGHEST);
        this.setLayer(OverlayLayer.ALWAYS_ON_TOP);
        this.client = client;
        this.regionLockerPlugin = regionLockerPlugin;
        this.config = config;
    }

    public Dimension render(Graphics2D graphics) {
        if (this.config.drawMapOverlay()) {
            this.drawRegionOverlay(graphics);
        }
        return null;
    }

    private void drawRegionOverlay(Graphics2D graphics) {
        Widget map = this.client.getWidget(38993927);
        if (map == null) {
            return;
        }
        WorldMap worldMap = this.client.getWorldMap();
        float pixelsPerTile = worldMap.getWorldMapZoom();
        Rectangle worldMapRect = map.getBounds();
        graphics.setClip(worldMapRect);
        int widthInTiles = (int)Math.ceil(worldMapRect.getWidth() / (double)pixelsPerTile);
        int heightInTiles = (int)Math.ceil(worldMapRect.getHeight() / (double)pixelsPerTile);
        Point worldMapPosition = worldMap.getWorldMapPosition();
        int yTileMin = worldMapPosition.getY() - heightInTiles / 2;
        int xRegionMin = worldMapPosition.getX() - widthInTiles / 2 & 0xFFFFFFC0;
        int xRegionMax = (worldMapPosition.getX() + widthInTiles / 2 & 0xFFFFFFC0) + 64;
        int yRegionMin = yTileMin & 0xFFFFFFC0;
        int yRegionMax = (worldMapPosition.getY() + heightInTiles / 2 & 0xFFFFFFC0) + 64;
        int regionPixelSize = (int)Math.ceil(64.0f * pixelsPerTile);
        Point mousePos = this.client.getMouseCanvasPosition();
        this.regionLockerPlugin.setHoveredRegion(-1);
        graphics.setColor(WHITE_TRANSLUCENT);
        for (int x = xRegionMin; x < xRegionMax; x += 64) {
            for (int y = yRegionMin; y < yRegionMax; y += 64) {
                boolean blacklisted;
                int yTileOffset = -(yTileMin - y);
                int xTileOffset = x + widthInTiles / 2 - worldMapPosition.getX();
                int xPos = (int)((float)xTileOffset * pixelsPerTile) + (int)worldMapRect.getX();
                int yPos = worldMapRect.height - (int)((float)yTileOffset * pixelsPerTile) + (int)worldMapRect.getY();
                int regionId = x >> 6 << 8 | y >> 6;
                String regionText = String.valueOf(regionId);
                FontMetrics fm = graphics.getFontMetrics();
                Rectangle2D textBounds = fm.getStringBounds(regionText, graphics);
                Rectangle regionRect = new Rectangle(xPos, yPos -= regionPixelSize, regionPixelSize, regionPixelSize);
                RegionTypes regionType = RegionLocker.getType(regionId);
                boolean containsRegion = regionType != null ^ this.config.invertMapOverlay();
                boolean unlockable = regionType == RegionTypes.UNLOCKABLE;
                boolean bl = blacklisted = regionType == RegionTypes.BLACKLISTED;
                if (containsRegion || unlockable || blacklisted) {
                    Color color = blacklisted ? this.config.blacklistedOverlayColor() : (unlockable ? this.config.unlockableOverlayColor() : this.config.mapOverlayColor());
                    if (regionRect.contains(mousePos.getX(), mousePos.getY())) {
                        color = color.brighter();
                    }
                    graphics.setColor(color);
                    graphics.fillRect(xPos, yPos, regionPixelSize, regionPixelSize);
                }
                if (regionRect.contains(mousePos.getX(), mousePos.getY())) {
                    this.regionLockerPlugin.setHoveredRegion(regionId);
                }
                graphics.setColor(new Color(0, 19, 36, 127));
                if (this.config.drawMapGrid()) {
                    graphics.drawRect(xPos, yPos, regionPixelSize, regionPixelSize);
                }
                graphics.setColor(WHITE_TRANSLUCENT);
                if (!this.config.drawRegionId()) continue;
                graphics.drawString(regionText, xPos + 4, yPos + (int)textBounds.getHeight() + 4);
            }
        }
        int currentId = this.client.getLocalPlayer().getWorldLocation().getRegionID();
        String regionText = String.valueOf(currentId);
        FontMetrics fm = graphics.getFontMetrics();
        Rectangle2D textBounds = fm.getStringBounds(regionText, graphics);
        if (this.config.drawRegionId()) {
            if (this.regionLockerPlugin.getHoveredRegion() >= 0) {
                graphics.drawString("Hovered chunk: " + this.regionLockerPlugin.getHoveredRegion(), (int)worldMapRect.getX() + 4, (int)(worldMapRect.getY() + worldMapRect.getHeight()) - 4 - (int)textBounds.getHeight());
            }
            graphics.drawString("Player chunk: " + regionText, (int)worldMapRect.getX() + 4, (int)(worldMapRect.getY() + worldMapRect.getHeight()) - 4);
        }
    }
}

