/*
 * Decompiled with CFR 0.152.
 */
package com.regionlocker;

import com.regionlocker.TrailblazerRegion;
import java.awt.Color;
import net.runelite.client.config.Alpha;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.Keybind;

@ConfigGroup(value="regionlocker")
public interface RegionLockerConfig
extends Config {
    @ConfigSection(name="Regions", description="Settings relating to chunks that you can unlock", position=0)
    public static final String regionSettings = "regionSettings";
    @ConfigSection(name="Environment Looks", description="Settings relating to locked regions look", position=1)
    public static final String environmentSettings = "environmentSettings";
    @ConfigSection(name="Map Settings", description="Settings relating to the map overlay", position=2)
    public static final String mapSettings = "mapSettings";

    @ConfigItem(keyName="trailblazerRegion", name="Unlock area", description="Unlock a complete area on the surface based on Trailblazer Leagues", position=15, section="regionSettings")
    default public TrailblazerRegion trailblazerRegion() {
        return TrailblazerRegion.NONE;
    }

    @ConfigItem(keyName="unlockUnderground", name="Unlock underground", description="Unlock all underground chunks (and any non-mainland chunks)", position=16, section="regionSettings")
    default public boolean unlockNonMainlandChunks() {
        return true;
    }

    @ConfigItem(keyName="unlockedRegions", name="Unlocked chunks", description="List of unlocked regions seperated by a ',' symbol", position=18, section="regionSettings")
    default public String unlockedRegions() {
        return "";
    }

    @ConfigItem(keyName="unlockableRegions", name="Unlockable chunks", description="List of unlockable regions seperated by a ',' symbol", position=19, section="regionSettings")
    default public String unlockableRegions() {
        return "";
    }

    @ConfigItem(keyName="blacklistedRegions", name="Blacklisted chunks", description="List of blacklisted regions seperated by a ',' symbol", position=20, section="regionSettings")
    default public String blacklistedRegions() {
        return "";
    }

    @ConfigItem(keyName="renderLockedRegions", name="Locked chunk shader", description="Adds graphical change to all chunk that are locked", position=21, section="environmentSettings")
    default public boolean renderLockedRegions() {
        return true;
    }

    @Alpha
    @ConfigItem(keyName="shaderGrayColor", name="Chunk shader color", description="The color of the locked chunks in the shader", position=22, section="environmentSettings")
    default public Color shaderGrayColor() {
        return new Color(0, 31, 77, 204);
    }

    @Alpha
    @ConfigItem(keyName="shaderGrayAmount", name="Chunk shader opacity", description="The amount of gray scale that is applied to a locked chunk in the shader (alpha only)", position=23, section="environmentSettings")
    default public Color shaderGrayAmount() {
        return new Color(0, 0, 0, 204);
    }

    @ConfigItem(keyName="hardBorder", name="Hard chunk border", description="True = hard border cutoff, False = chunk border gradient", position=24, section="environmentSettings")
    default public boolean hardBorder() {
        return true;
    }

    @ConfigItem(keyName="renderRegionBorders", name="Draw chunk border lines", description="Draw the chunk borders in the environment marked by lines", position=25, section="environmentSettings")
    default public boolean renderRegionBorders() {
        return false;
    }

    @ConfigItem(keyName="regionBorderWidth", name="Chunk border width", description="How wide the region border will be", position=26, section="environmentSettings")
    default public int regionBorderWidth() {
        return 1;
    }

    @Alpha
    @ConfigItem(keyName="regionBorderColor", name="Chunk border color", description="The color of the chunk borders", position=27, section="environmentSettings")
    default public Color regionBorderColor() {
        return new Color(0, 200, 83, 200);
    }

    @ConfigItem(keyName="drawMapOverlay", name="Draw chunks on map", description="Draw a color overlay for each locked/unlocked chunk", position=28, section="mapSettings")
    default public boolean drawMapOverlay() {
        return true;
    }

    @ConfigItem(keyName="invertMapOverlay", name="Invert map overlay", description="Switches which chunks the map will draw the color overlay for (true = locked, false = unlocked)", position=29, section="mapSettings")
    default public boolean invertMapOverlay() {
        return true;
    }

    @Alpha
    @ConfigItem(keyName="mapOverlayColor", name="Map overlay color", description="The color the map overlay will draw the chunks in", position=30, section="mapSettings")
    default public Color mapOverlayColor() {
        return new Color(200, 16, 0, 100);
    }

    @Alpha
    @ConfigItem(keyName="unlockableOverlayColor", name="Unlockable overlay color", description="The color the map overlay will draw the unlockable chunks in", position=31, section="mapSettings")
    default public Color unlockableOverlayColor() {
        return new Color(60, 200, 160, 100);
    }

    @Alpha
    @ConfigItem(keyName="blacklistedOverlayColor", name="Blacklisted overlay color", description="The color the map overlay will draw the blacklisted chunks in", position=32, section="mapSettings")
    default public Color blacklistedOverlayColor() {
        return new Color(0, 0, 0, 200);
    }

    @ConfigItem(keyName="drawMapGrid", name="Draw map grid", description="Draw the grid of chunks on the map", position=33, section="mapSettings")
    default public boolean drawMapGrid() {
        return true;
    }

    @ConfigItem(keyName="drawRegionId", name="Draw region IDs", description="Draw the chunk ID for each chunk on the map", position=34, section="mapSettings")
    default public boolean drawRegionId() {
        return true;
    }

    @ConfigItem(keyName="unlockKey", name="Unlock hotkey", description="When you hold this key you can click on the map to unlock a chunk", position=35, section="mapSettings")
    default public Keybind unlockKey() {
        return Keybind.SHIFT;
    }

    @ConfigItem(keyName="blacklistKey", name="Blacklist hotkey", description="When you hold this key you can click on the map to blacklist a chunk", position=36, section="mapSettings")
    default public Keybind blacklistKey() {
        return Keybind.CTRL;
    }

    @ConfigItem(keyName="invertShader", name="Invert chunk shader", description="True = unlocked chunks are shaded", position=37, section="environmentSettings")
    default public boolean invertShader() {
        return false;
    }
}

