/*
 * Decompiled with CFR 0.152.
 */
package com.regionlocker;

import com.regionlocker.RegionLockerConfig;
import com.regionlocker.RegionTypes;
import com.regionlocker.TrailblazerRegion;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.util.Text;

public class RegionLocker {
    private final RegionLockerConfig config;
    private final ConfigManager configManager;
    private static final Map<String, RegionTypes> regions = new HashMap<String, RegionTypes>();
    public static boolean renderLockedRegions;
    public static Color grayColor;
    public static int grayAmount;
    public static boolean hardBorder;
    public static boolean invertShader;
    private static boolean unlockNonMainlandChunks;
    private static TrailblazerRegion trailblazerRegion;

    RegionLocker(RegionLockerConfig config, ConfigManager configManager) {
        this.config = config;
        this.configManager = configManager;
        this.readConfig();
    }

    private List<String> StringToList(String s) {
        ArrayList<String> regs = s.isEmpty() ? new ArrayList<String>() : new ArrayList(Text.fromCSV((String)s));
        return regs;
    }

    public void readConfig() {
        renderLockedRegions = this.config.renderLockedRegions();
        unlockNonMainlandChunks = this.config.unlockNonMainlandChunks();
        grayColor = this.config.shaderGrayColor();
        grayAmount = this.config.shaderGrayAmount().getAlpha();
        hardBorder = this.config.hardBorder();
        invertShader = this.config.invertShader();
        trailblazerRegion = this.config.trailblazerRegion();
        regions.clear();
        String unlockedString = this.config.unlockedRegions();
        List<String> unlockedRegions = this.StringToList(unlockedString);
        this.setRegions(unlockedRegions, RegionTypes.UNLOCKED);
        String unlockableString = this.config.unlockableRegions();
        List<String> unlockableRegions = this.StringToList(unlockableString);
        this.setRegions(unlockableRegions, RegionTypes.UNLOCKABLE);
        String blacklistedString = this.config.blacklistedRegions();
        List<String> blacklistedRegions = this.StringToList(blacklistedString);
        this.setRegions(blacklistedRegions, RegionTypes.BLACKLISTED);
    }

    private void setRegions(List<String> regs, RegionTypes type) {
        for (String id : regs) {
            regions.put(id, type);
        }
    }

    private void setConfig() {
        ArrayList unlockedRegions = new ArrayList();
        ArrayList unlockableRegions = new ArrayList();
        ArrayList blacklistedRegions = new ArrayList();
        regions.forEach((key, value) -> {
            if (value == RegionTypes.UNLOCKED) {
                unlockedRegions.add(key);
            }
            if (value == RegionTypes.UNLOCKABLE) {
                unlockableRegions.add(key);
            }
            if (value == RegionTypes.BLACKLISTED) {
                blacklistedRegions.add(key);
            }
        });
        String csv = Text.toCSV(unlockedRegions);
        this.configManager.setConfiguration("regionlocker", "unlockedRegions", csv);
        csv = Text.toCSV(unlockableRegions);
        this.configManager.setConfiguration("regionlocker", "unlockableRegions", csv);
        csv = Text.toCSV(blacklistedRegions);
        this.configManager.setConfiguration("regionlocker", "blacklistedRegions", csv);
    }

    public void addRegion(int regionId) {
        String id = Integer.toString(regionId);
        RegionTypes type = regions.get(id);
        if (type == null) {
            regions.put(id, RegionTypes.UNLOCKABLE);
        } else if (type == RegionTypes.UNLOCKABLE) {
            regions.put(id, RegionTypes.UNLOCKED);
        } else {
            regions.remove(id);
        }
        this.setConfig();
    }

    public void blockRegion(int regionId) {
        String id = Integer.toString(regionId);
        RegionTypes type = regions.get(id);
        if (type != RegionTypes.BLACKLISTED) {
            if (type == null) {
                regions.put(id, RegionTypes.BLACKLISTED);
            } else {
                regions.replace(id, RegionTypes.BLACKLISTED);
            }
        } else {
            regions.remove(id);
        }
        this.setConfig();
    }

    public static RegionTypes getType(int regionId) {
        String id = Integer.toString(regionId);
        if (!id.equals("") && trailblazerRegion != null && trailblazerRegion != TrailblazerRegion.NONE && RegionLocker.trailblazerRegion.regions != null && Arrays.asList(RegionLocker.trailblazerRegion.regions).contains(id)) {
            return RegionTypes.UNLOCKED;
        }
        int y = RegionLocker.getY(regionId);
        if (unlockNonMainlandChunks && (y < 2496 || y >= 4160)) {
            return RegionTypes.UNLOCKED;
        }
        return regions.get(id);
    }

    public static boolean hasRegion(int regionId) {
        RegionTypes type = RegionLocker.getType(regionId);
        if (type == null) {
            return false;
        }
        return type == RegionTypes.UNLOCKED;
    }

    public static boolean isUnlockable(int regionId) {
        RegionTypes type = RegionLocker.getType(regionId);
        if (type == null) {
            return false;
        }
        return type == RegionTypes.UNLOCKABLE;
    }

    public static boolean isBlacklisted(int regionId) {
        RegionTypes type = RegionLocker.getType(regionId);
        if (type == null) {
            return false;
        }
        return type == RegionTypes.BLACKLISTED;
    }

    public static int getX(int id) {
        return id >> 8 << 6;
    }

    public static int getY(int id) {
        return (id & 0xFF) << 6;
    }

    public static Map<String, RegionTypes> getRegions() {
        return regions;
    }

    static {
        grayColor = new Color(0, 31, 77, 204);
        trailblazerRegion = TrailblazerRegion.NONE;
    }
}

