/*
 * Decompiled with CFR 0.152.
 */
package com.goaltracker.ui;

import com.goaltracker.Goal;
import com.goaltracker.GoalTrackerPlugin;
import com.goaltracker.ui.GoalTrackerPanel;
import com.goaltracker.ui.RequirementsPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.components.FlatTextField;
import net.runelite.client.ui.components.MouseDragEventForwarder;

public class GoalPanel
extends JPanel {
    private static final Border NAME_BOTTOM_BORDER = new CompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, ColorScheme.DARK_GRAY_COLOR), BorderFactory.createMatteBorder(3, 0, 3, 0, ColorScheme.DARKER_GRAY_COLOR));
    private final GoalTrackerPlugin plugin;
    public final Goal goal;
    private final JLabel completionCheckbox = new JLabel();
    private final JLabel deleteButton = new JLabel();
    private final FlatTextField nameInput = new FlatTextField();
    private final JLabel saveRenameButton = new JLabel("Save");
    private final JLabel cancelRenameButton = new JLabel("Cancel");
    private final JLabel renameButton = new JLabel();
    private final JTextField chunkInput = new JTextField("", 20);
    private final MouseAdapter nameInputMouseAdapter;

    GoalPanel(final GoalTrackerPlugin plugin, JComponent parentPanel, final Goal goal) {
        this.plugin = plugin;
        this.goal = goal;
        this.nameInputMouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                goal.cycleState();
                if (e.isShiftDown()) {
                    goal.cycleState();
                }
                GoalPanel.this.updateCompletion();
            }
        };
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(5, 0, 0, 0));
        JPanel nameWrapper = new JPanel(new BorderLayout());
        nameWrapper.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        nameWrapper.setBorder(NAME_BOTTOM_BORDER);
        JPanel nameActions = new JPanel();
        nameActions.setLayout(new BoxLayout(nameActions, 0));
        nameActions.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.saveRenameButton.setCursor(Cursor.getPredefinedCursor(12));
        this.saveRenameButton.setVisible(false);
        this.saveRenameButton.setFont(FontManager.getRunescapeSmallFont());
        this.saveRenameButton.setForeground(ColorScheme.PROGRESS_COMPLETE_COLOR);
        this.saveRenameButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                GoalPanel.this.saveGoalRename();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                GoalPanel.this.saveRenameButton.setForeground(ColorScheme.PROGRESS_COMPLETE_COLOR.darker());
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                GoalPanel.this.saveRenameButton.setForeground(ColorScheme.PROGRESS_COMPLETE_COLOR);
            }
        });
        this.cancelRenameButton.setCursor(Cursor.getPredefinedCursor(12));
        this.cancelRenameButton.setVisible(false);
        this.cancelRenameButton.setFont(FontManager.getRunescapeSmallFont());
        this.cancelRenameButton.setForeground(ColorScheme.PROGRESS_ERROR_COLOR);
        this.cancelRenameButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                GoalPanel.this.cancelGoalRename();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                GoalPanel.this.cancelRenameButton.setForeground(ColorScheme.PROGRESS_ERROR_COLOR.darker());
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                GoalPanel.this.cancelRenameButton.setForeground(ColorScheme.PROGRESS_ERROR_COLOR);
            }
        });
        this.renameButton.setCursor(Cursor.getPredefinedCursor(12));
        this.renameButton.setIcon(GoalTrackerPanel.EDIT_ICON);
        this.renameButton.setToolTipText("Rename goal");
        this.renameButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                GoalPanel.this.nameInput.setEditable(true);
                GoalPanel.this.updateNameActions(true);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                GoalPanel.this.renameButton.setIcon(GoalTrackerPanel.EDIT_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                GoalPanel.this.renameButton.setIcon(GoalTrackerPanel.EDIT_ICON);
            }
        });
        this.completionCheckbox.setCursor(Cursor.getPredefinedCursor(12));
        this.completionCheckbox.setToolTipText(goal.isCompleted() ? "Mark as incomplete" : "Mark as completed");
        this.completionCheckbox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                goal.cycleState();
                if (e.isShiftDown()) {
                    goal.cycleState();
                }
                GoalPanel.this.updateCompletion();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (goal.isBlocked()) {
                    GoalPanel.this.completionCheckbox.setIcon(GoalTrackerPanel.BLOCKED_HOVER_ICON);
                    GoalPanel.this.completionCheckbox.setToolTipText("Unblock");
                } else {
                    GoalPanel.this.completionCheckbox.setIcon(goal.isCompleted() ? GoalTrackerPanel.CHECKED_HOVER_ICON : GoalTrackerPanel.CHECKBOX_HOVER_ICON);
                    GoalPanel.this.completionCheckbox.setToolTipText(goal.isCompleted() ? "Mark as incomplete" : "Mark as completed");
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                GoalPanel.this.updateCompletion();
            }
        });
        this.completionCheckbox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 16) {
                    GoalPanel.this.completionCheckbox.setToolTipText(goal.isBlocked() ? "Mark as blocked" : "Unblock");
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 16) {
                    GoalPanel.this.completionCheckbox.setToolTipText(goal.isCompleted() ? "Mark as incomplete" : "Mark as completed");
                }
            }
        });
        this.deleteButton.setCursor(Cursor.getPredefinedCursor(12));
        this.deleteButton.setIcon(GoalTrackerPanel.DELETE_ICON);
        this.deleteButton.setToolTipText("Delete goal");
        this.deleteButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                boolean quickDelete;
                int confirm = 0;
                boolean bl = quickDelete = mouseEvent.isShiftDown() && plugin.config.enableQuickDelete();
                if (!quickDelete) {
                    confirm = JOptionPane.showConfirmDialog(GoalPanel.this, "Are you sure you want to permanently delete this goal?", "Warning", 2);
                }
                if (confirm == 0) {
                    plugin.deleteGoal(goal);
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                GoalPanel.this.deleteButton.setIcon(GoalTrackerPanel.DELETE_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                GoalPanel.this.deleteButton.setIcon(GoalTrackerPanel.DELETE_ICON);
            }
        });
        this.cancelRenameButton.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        this.saveRenameButton.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        this.renameButton.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        this.deleteButton.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 6));
        nameActions.add(this.cancelRenameButton);
        nameActions.add(this.saveRenameButton);
        nameActions.add(this.renameButton);
        nameActions.add(this.deleteButton);
        this.completionCheckbox.setBorder(BorderFactory.createEmptyBorder(0, 7, 0, 4));
        this.nameInput.setText(goal.getName());
        this.nameInput.setBorder(null);
        this.nameInput.setEditable(false);
        this.nameInput.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.nameInput.setPreferredSize(new Dimension(0, 24));
        this.nameInput.getTextField().setForeground(Color.WHITE);
        this.nameInput.getTextField().setBorder(new EmptyBorder(2, 0, 0, 0));
        this.nameInput.getTextField().setCursor(Cursor.getPredefinedCursor(12));
        this.nameInput.getTextField().addMouseListener(this.nameInputMouseAdapter);
        this.nameInput.getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 10: {
                        GoalPanel.this.saveGoalRename();
                        break;
                    }
                    case 27: {
                        GoalPanel.this.cancelGoalRename();
                    }
                }
            }
        });
        nameWrapper.add((Component)this.completionCheckbox, "West");
        nameWrapper.add((Component)this.nameInput, "Center");
        nameWrapper.add((Component)nameActions, "East");
        JPanel bottomContainer = new JPanel(new GridBagLayout());
        bottomContainer.setBorder(new EmptyBorder(8, 0, 8, 0));
        bottomContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        JPanel leftActions = new JPanel(new BorderLayout());
        leftActions.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JPanel rightActions = new JPanel(new FlowLayout(2, 8, 0));
        rightActions.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JPanel chunkWrapper = new JPanel(new BorderLayout(8, 0));
        chunkWrapper.setPreferredSize(new Dimension(0, 24));
        chunkWrapper.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        chunkWrapper.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
        this.chunkInput.setText(Integer.toString(goal.getChunk()));
        this.chunkInput.setPreferredSize(new Dimension(0, 24));
        this.chunkInput.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 27: {
                        GoalPanel.this.chunkInput.setText(Integer.toString(goal.getChunk()));
                    }
                    case 10: {
                        GoalPanel.this.chunkInput.transferFocus();
                    }
                }
            }
        });
        this.chunkInput.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                int chunk = goal.getChunk();
                try {
                    chunk = Integer.parseInt(GoalPanel.this.chunkInput.getText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                goal.setChunk(chunk);
                GoalPanel.this.chunkInput.setText(Integer.toString(goal.getChunk()));
            }
        });
        JLabel chunkLabel = new JLabel("Chunk ID:");
        chunkWrapper.add((Component)chunkLabel, "West");
        chunkWrapper.add((Component)this.chunkInput, "Center");
        bottomContainer.add((Component)chunkWrapper, gbc);
        ++gbc.gridy;
        bottomContainer.add(Box.createRigidArea(new Dimension(0, 8)), gbc);
        ++gbc.gridy;
        RequirementsPanel requirementsPanel = new RequirementsPanel(plugin, parentPanel, goal);
        bottomContainer.add((Component)requirementsPanel, gbc);
        ++gbc.gridy;
        this.add((Component)nameWrapper, "North");
        this.add((Component)bottomContainer, "Center");
        this.updateCompletion();
        MouseDragEventForwarder mouseDragEventForwarder = new MouseDragEventForwarder((Component)parentPanel);
        this.addMouseListener((MouseListener)mouseDragEventForwarder);
        this.addMouseMotionListener((MouseMotionListener)mouseDragEventForwarder);
        nameWrapper.addMouseListener((MouseListener)mouseDragEventForwarder);
        nameWrapper.addMouseMotionListener((MouseMotionListener)mouseDragEventForwarder);
        nameActions.addMouseListener((MouseListener)mouseDragEventForwarder);
        nameActions.addMouseMotionListener((MouseMotionListener)mouseDragEventForwarder);
        this.nameInput.getTextField().addMouseListener((MouseListener)mouseDragEventForwarder);
        this.nameInput.getTextField().addMouseMotionListener((MouseMotionListener)mouseDragEventForwarder);
        bottomContainer.addMouseListener((MouseListener)mouseDragEventForwarder);
        bottomContainer.addMouseMotionListener((MouseMotionListener)mouseDragEventForwarder);
        leftActions.addMouseListener((MouseListener)mouseDragEventForwarder);
        leftActions.addMouseMotionListener((MouseMotionListener)mouseDragEventForwarder);
        rightActions.addMouseListener((MouseListener)mouseDragEventForwarder);
        rightActions.addMouseMotionListener((MouseMotionListener)mouseDragEventForwarder);
        this.renameButton.addMouseListener((MouseListener)mouseDragEventForwarder);
        this.renameButton.addMouseMotionListener((MouseMotionListener)mouseDragEventForwarder);
        this.completionCheckbox.addMouseListener((MouseListener)mouseDragEventForwarder);
        this.completionCheckbox.addMouseMotionListener((MouseMotionListener)mouseDragEventForwarder);
        this.deleteButton.addMouseListener((MouseListener)mouseDragEventForwarder);
        this.deleteButton.addMouseMotionListener((MouseMotionListener)mouseDragEventForwarder);
        chunkWrapper.addMouseListener((MouseListener)mouseDragEventForwarder);
        chunkWrapper.addMouseMotionListener((MouseMotionListener)mouseDragEventForwarder);
        this.chunkInput.addMouseListener((MouseListener)mouseDragEventForwarder);
        this.chunkInput.addMouseMotionListener((MouseMotionListener)mouseDragEventForwarder);
        chunkLabel.addMouseListener((MouseListener)mouseDragEventForwarder);
        chunkLabel.addMouseMotionListener((MouseMotionListener)mouseDragEventForwarder);
        requirementsPanel.addMouseListener((MouseListener)mouseDragEventForwarder);
        requirementsPanel.addMouseMotionListener((MouseMotionListener)mouseDragEventForwarder);
    }

    private void updateNameActions(boolean saveAndCancel) {
        this.saveRenameButton.setVisible(saveAndCancel);
        this.cancelRenameButton.setVisible(saveAndCancel);
        this.renameButton.setVisible(!saveAndCancel);
        if (saveAndCancel) {
            this.nameInput.getTextField().requestFocusInWindow();
            this.nameInput.getTextField().selectAll();
            this.nameInput.getTextField().removeMouseListener(this.nameInputMouseAdapter);
            this.nameInput.getTextField().setCursor(Cursor.getPredefinedCursor(2));
        } else {
            this.nameInput.getTextField().addMouseListener(this.nameInputMouseAdapter);
            this.nameInput.getTextField().setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    private void updateCompletion() {
        this.nameInput.getTextField().setForeground(this.goal.isCompleted() ? this.plugin.config.completedColor() : (this.goal.isBlocked() ? this.plugin.config.blockedColor() : this.plugin.config.inProgressColor()));
        this.completionCheckbox.setToolTipText(this.goal.isBlocked() ? "Unblock" : (this.goal.isCompleted() ? "Mark as blocked" : "Mark as completed"));
        this.completionCheckbox.setIcon(this.goal.isBlocked() ? GoalTrackerPanel.BLOCKED_ICON : (this.goal.isCompleted() ? GoalTrackerPanel.CHECKED_ICON : GoalTrackerPanel.CHECKBOX_ICON));
        this.plugin.updateConfig();
    }

    private void saveGoalRename() {
        this.goal.setName(this.nameInput.getText());
        this.plugin.updateConfig();
        this.nameInput.setEditable(false);
        this.updateNameActions(false);
        this.requestFocusInWindow();
    }

    private void cancelGoalRename() {
        this.nameInput.setEditable(false);
        this.nameInput.setText(this.goal.getName());
        this.updateNameActions(false);
        this.requestFocusInWindow();
    }
}

