/*
 * Decompiled with CFR 0.152.
 */
package com.goaltracker;

import java.awt.Color;
import net.runelite.client.config.Alpha;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.Keybind;

@ConfigGroup(value="RegionLockerGoalTracker")
public interface GoalTrackerConfig
extends Config {
    public static final String OLD_CONFIG_GROUP = "goaltracker";
    public static final String CONFIG_GROUP = "RegionLockerGoalTracker";
    public static final String HIDE_COMPLETED_GOALS_KEY = "hideCompletedGoals";
    public static final String COLLAPSE_REQUIREMENTS_KEY = "collapseRequirements";
    public static final String BLOCKED_COLOR_KEY = "noProgressColor";
    public static final String IN_PROGRESS_COLOR_KEY = "inProgressColor";
    public static final String COMPLETED_COLOR_KEY = "completedColor";
    public static final String REQUIRED_CHUNK_COLOR_KEY = "requiredChunkColor";

    @ConfigItem(keyName="drawMapOverlay", name="Draw goal chunks on map", description="Draw a colored border for each chunk with goals", position=1)
    default public boolean drawMapOverlay() {
        return true;
    }

    @ConfigItem(keyName="enableTooltip", name="Enable tooltip", description="Show tooltip with goals of the chunk you hover over while holding the hotkey below", position=2)
    default public boolean enableTooltip() {
        return true;
    }

    @ConfigItem(keyName="hotKey", name="Tooltip hotkey", description="Which key to hold to view the goals tooltip on the map", position=3)
    default public Keybind hotKey() {
        return Keybind.SHIFT;
    }

    @ConfigItem(keyName="enableQuickDelete", name="Enable shift quick-delete", description="Allows deleting goals more quickly by holding down shift while clicking the delete button", position=4)
    default public boolean enableQuickDelete() {
        return false;
    }

    @ConfigItem(keyName="hideCompletedGoals", name="Hide goals when completed", description="Hides all completed goals from the goal tracker panel", position=5)
    default public boolean hideCompletedGoals() {
        return false;
    }

    @ConfigItem(keyName="collapseRequirements", name="Collapse requirements", description="Hides all goal requirements by default", position=6)
    default public boolean collapseRequirements() {
        return false;
    }

    @Alpha
    @ConfigItem(keyName="noProgressColor", name="Blocked color", description="Color of goals with no progress", position=7)
    default public Color blockedColor() {
        return Color.RED;
    }

    @Alpha
    @ConfigItem(keyName="inProgressColor", name="In-progress color", description="Color of goals that are in progress", position=8)
    default public Color inProgressColor() {
        return Color.YELLOW;
    }

    @Alpha
    @ConfigItem(keyName="completedColor", name="Completed color", description="Color of completed goals", position=9)
    default public Color completedColor() {
        return Color.decode("#0dc10d");
    }

    @Alpha
    @ConfigItem(keyName="requiredChunkColor", name="Required chunk color", description="Color of chunks that are a requirement for goals", position=10)
    default public Color requiredChunkColor() {
        return Color.MAGENTA;
    }
}

