/*
 * Decompiled with CFR 0.152.
 */
package trevor.skullnotifier;

import com.google.inject.Provides;
import java.util.EnumSet;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.SkullIcon;
import net.runelite.api.WorldType;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.client.Notifier;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import trevor.skullnotifier.SkullNotifierConfig;

@PluginDescriptor(name="Skull Notifier")
public class SkullNotifierPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(SkullNotifierPlugin.class);
    @Inject
    private Client client;
    @Inject
    private SkullNotifierConfig config;
    @Inject
    private Notifier notifier;
    private SkullIcon lastTickSkull;
    private boolean isFirstTick;

    protected void startUp() throws Exception {
        this.isFirstTick = true;
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        GameState state = gameStateChanged.getGameState();
        switch (state) {
            case HOPPING: 
            case LOGIN_SCREEN: {
                this.isFirstTick = true;
            }
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        Player local = this.client.getLocalPlayer();
        SkullIcon currentTickSkull = local.getSkullIcon();
        EnumSet worldTypes = this.client.getWorldType();
        if (!worldTypes.contains(WorldType.DEADMAN)) {
            if (!this.isFirstTick) {
                if (this.config.showSkullNotification() && this.lastTickSkull == null && currentTickSkull == SkullIcon.SKULL) {
                    this.notifier.notify("[" + local.getName() + "] is now skulled!");
                } else if (this.config.showUnskullNotification() && this.lastTickSkull == SkullIcon.SKULL && currentTickSkull == null) {
                    this.notifier.notify("[" + local.getName() + "] is now unskulled!");
                }
            } else {
                this.isFirstTick = false;
            }
            this.lastTickSkull = currentTickSkull;
        }
    }

    @Provides
    SkullNotifierConfig provideConfig(ConfigManager configManager) {
        return (SkullNotifierConfig)configManager.getConfig(SkullNotifierConfig.class);
    }
}

