/*
 * Decompiled with CFR 0.152.
 */
package com.soundswapper;

import com.google.inject.Provides;
import com.soundswapper.Sound;
import com.soundswapper.SoundEffectOverlay;
import com.soundswapper.SoundSwapperConfig;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.AreaSoundEffectPlayed;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.SoundEffectPlayed;
import net.runelite.client.RuneLite;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Sound Swapper", description="Allows the user to replace any sound effect.<br><br>To replace a sound, add its ID to the list in the plugin menu, then place a .wav file with the same name in your root<br>RuneLite folder. The plugin will grab the sound and use it instead!")
public class SoundSwapperPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(SoundSwapperPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private EventBus eventBus;
    @Inject
    private SoundSwapperConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private SoundEffectOverlay soundEffectOverlay;
    public HashMap<Integer, Sound> customSounds = new HashMap();
    public HashMap<Integer, Sound> customAreaSounds = new HashMap();
    public List<Integer> whitelistedSounds = new ArrayList<Integer>();
    public List<Integer> whitelistedAreaSounds = new ArrayList<Integer>();
    public List<Integer> blacklistedSounds = new ArrayList<Integer>();
    public List<Integer> blacklistedAreaSounds = new ArrayList<Integer>();
    private static final File SOUND_DIR = new File(RuneLite.RUNELITE_DIR, "SoundSwapper");
    private static final String CONFIG_GROUP = "soundswapper";

    @Provides
    SoundSwapperConfig provideConfig(ConfigManager configManager) {
        return (SoundSwapperConfig)configManager.getConfig(SoundSwapperConfig.class);
    }

    protected void startUp() throws Exception {
        try {
            if (!SOUND_DIR.exists()) {
                SOUND_DIR.mkdir();
            }
        }
        catch (SecurityException securityException) {
            log.error("Attempted to create SoundSwapper directory and a security exception prompted a fault");
        }
        this.updateLists();
        this.overlayManager.add((Overlay)this.soundEffectOverlay);
        this.eventBus.register((Object)this.soundEffectOverlay);
    }

    protected void shutDown() throws Exception {
        this.eventBus.unregister((Object)this.soundEffectOverlay);
        this.overlayManager.remove((Overlay)this.soundEffectOverlay);
        this.reset();
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!CONFIG_GROUP.equals(event.getGroup())) {
            return;
        }
        switch (event.getKey()) {
            case "customSounds": {
                this.updateSoundList(this.customSounds, event.getNewValue());
                break;
            }
            case "customAreaSounds": {
                this.updateSoundList(this.customAreaSounds, event.getNewValue());
                break;
            }
            case "whitelistSounds": {
                this.whitelistedSounds = this.getIds(event.getNewValue());
                break;
            }
            case "whitelistAreaSounds": {
                this.whitelistedAreaSounds = this.getIds(event.getNewValue());
                break;
            }
            case "blacklistedSounds": {
                this.blacklistedSounds = this.getIds(event.getNewValue());
                break;
            }
            case "blacklistedAreaSounds": {
                this.blacklistedAreaSounds = this.getIds(event.getNewValue());
                break;
            }
            case "consumeAmbientSounds": {
                this.clientThread.invokeLater(() -> {
                    if (this.client.getGameState() == GameState.LOGGED_IN) {
                        this.client.setGameState(GameState.LOADING);
                    }
                });
            }
        }
        this.soundEffectOverlay.resetLines();
    }

    void updateLists() {
        if (!this.config.customSounds().isEmpty()) {
            this.updateSoundList(this.customSounds, this.config.customSounds());
        }
        if (!this.config.customAreaSounds().isEmpty()) {
            this.updateSoundList(this.customAreaSounds, this.config.customAreaSounds());
        }
        if (!this.config.whitelistSounds().isEmpty()) {
            this.whitelistedSounds = this.getIds(this.config.whitelistSounds());
        }
        if (!this.config.whitelistAreaSounds().isEmpty()) {
            this.whitelistedAreaSounds = this.getIds(this.config.whitelistAreaSounds());
        }
        if (!this.config.blacklistedSounds().isEmpty()) {
            this.blacklistedSounds = this.getIds(this.config.blacklistedSounds());
        }
        if (!this.config.blacklistedAreaSounds().isEmpty()) {
            this.blacklistedAreaSounds = this.getIds(this.config.blacklistedAreaSounds());
        }
    }

    @Subscribe
    public void onSoundEffectPlayed(SoundEffectPlayed event) {
        int soundId = event.getSoundId();
        if (this.config.soundEffects() && this.customSounds.containsKey(soundId)) {
            event.consume();
            this.playCustomSound(this.customSounds.get(soundId), this.config.enableCustomSoundsVolume() ? this.config.customSoundsVolume() : -1);
            return;
        }
        if (this.config.consumeSoundEffects() || this.blacklistedSounds.contains(soundId)) {
            if (!this.whitelistedSounds.isEmpty() && this.whitelistedSounds.contains(soundId)) {
                log.debug("whitelisted other sound effect passed: {}", (Object)soundId);
                return;
            }
            log.debug("consumed other sound effect: {}", (Object)soundId);
            event.consume();
        }
    }

    @Subscribe
    public void onAreaSoundEffectPlayed(AreaSoundEffectPlayed event) {
        int soundId = event.getSoundId();
        if (this.config.areaSoundEffects() && this.customAreaSounds.containsKey(soundId)) {
            event.consume();
            this.playCustomSound(this.customAreaSounds.get(soundId), this.config.enableCustomAreaSoundsVolume() ? this.config.customAreaSoundsVolume() : -1);
            return;
        }
        if (this.config.consumeAreaSounds() || this.blacklistedSounds.contains(soundId)) {
            if (!this.whitelistedAreaSounds.isEmpty() && this.whitelistedAreaSounds.contains(soundId)) {
                log.debug("whitelisted area sound effect passed: {}", (Object)soundId);
                return;
            }
            log.debug("consumed area sound effect: {}", (Object)soundId);
            event.consume();
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        GameState gameState = gameStateChanged.getGameState();
        if (gameState == GameState.LOGGED_IN && this.config.consumeAmbientSounds()) {
            this.client.getAmbientSoundEffects().clear();
        }
    }

    private boolean tryLoadSound(HashMap<Integer, Sound> sounds, String sound_name, Integer sound_id) {
        File sound_file = new File(SOUND_DIR, sound_name + ".wav");
        if (sound_file.exists()) {
            try {
                BufferedInputStream fileStream = new BufferedInputStream(new FileInputStream(sound_file));
                AudioInputStream stream = AudioSystem.getAudioInputStream(fileStream);
                int streamLen = (int)stream.getFrameLength() * stream.getFormat().getFrameSize();
                byte[] bytes = new byte[streamLen];
                stream.read(bytes);
                Sound sound = new Sound(bytes, stream.getFormat(), streamLen);
                sounds.put(sound_id, sound);
                return true;
            }
            catch (IOException | UnsupportedAudioFileException e) {
                log.warn("Unable to load custom sound " + sound_name, (Throwable)e);
            }
        }
        return false;
    }

    private void updateSoundList(HashMap<Integer, Sound> sounds, String configText) {
        sounds.clear();
        for (String s : Text.fromCSV((String)configText)) {
            try {
                int id = Integer.parseInt(s);
                this.tryLoadSound(sounds, s, id);
            }
            catch (NumberFormatException e) {
                log.warn("Invalid sound ID: {}", (Object)s);
            }
        }
    }

    private List<Integer> getIds(String configText) {
        if (configText == null || configText.isEmpty()) {
            return List.of();
        }
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (String s : Text.fromCSV((String)configText)) {
            try {
                int id = Integer.parseInt(s);
                ids.add(id);
            }
            catch (NumberFormatException e) {
                log.warn("Invalid id when parsing {}: {}", (Object)configText, (Object)s);
            }
        }
        return ids;
    }

    private void playCustomSound(Sound sound, int volume) {
        try {
            FloatControl control;
            Clip clip = AudioSystem.getClip();
            clip.open(sound.getFormat(), sound.getBytes(), 0, sound.getNumBytes());
            if (volume != -1 && (control = (FloatControl)clip.getControl(FloatControl.Type.MASTER_GAIN)) != null) {
                control.setValue(volume / 2 - 45);
            }
            clip.setFramePosition(0);
            clip.start();
        }
        catch (LineUnavailableException e) {
            log.warn("Failed to play custom sound");
        }
    }

    private void reset() {
        this.customSounds = new HashMap();
        this.customAreaSounds = new HashMap();
        this.whitelistedSounds = new ArrayList<Integer>();
        this.whitelistedAreaSounds = new ArrayList<Integer>();
        this.blacklistedSounds = new ArrayList<Integer>();
        this.blacklistedAreaSounds = new ArrayList<Integer>();
        this.soundEffectOverlay.resetLines();
    }
}

