/*
 * Decompiled with CFR 0.152.
 */
package com.soundswapper;

import com.soundswapper.SoundSwapperConfig;
import com.soundswapper.SoundSwapperPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.events.AreaSoundEffectPlayed;
import net.runelite.api.events.SoundEffectPlayed;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SoundEffectOverlay
extends OverlayPanel {
    private static final Logger log = LoggerFactory.getLogger(SoundEffectOverlay.class);
    private static final int MAX_LINES = 10;
    private static final Color COLOR_SOUND_EFFECT = Color.WHITE;
    private static final Color COLOR_AREA_SOUND_EFFECT = Color.YELLOW;
    private static final Color COLOR_SILENT_SOUND_EFFECT = Color.GRAY;
    private static final Color COLOR_ALLOWED = Color.GREEN;
    private static final Color COLOR_CONSUMED = Color.RED;
    private static final Color COLOR_CUSTOM = Color.PINK;
    private static final Color COLOR_BLACKLISTED = Color.ORANGE;
    private static final Color COLOR_WHITELISTED = Color.WHITE;
    public static final String ALLOWED = "Allowed";
    public static final String BLACKLISTED = "Blacklisted";
    public static final String CONSUMED = "Consumed";
    public static final String CUSTOM = "Custom";
    public static final String WHITELISTED = "Whitelisted";
    private final Client client;
    private SoundSwapperPlugin plugin;
    private SoundSwapperConfig config;

    @Inject
    SoundEffectOverlay(Client client, SoundSwapperPlugin plugin, SoundSwapperConfig config) {
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.panelComponent.getChildren().add(LineComponent.builder().left("Sound Effects").leftColor(Color.CYAN).build());
        this.setClearChildren(false);
        this.setPosition(OverlayPosition.TOP_LEFT);
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.config.debugSoundEffects()) {
            return null;
        }
        return super.render(graphics);
    }

    @Subscribe
    public void onSoundEffectPlayed(SoundEffectPlayed event) {
        if (!this.config.debugSoundEffects()) {
            return;
        }
        int soundId = event.getSoundId();
        String text = "G: " + soundId;
        String action = ALLOWED;
        Color actionColor = COLOR_ALLOWED;
        if (this.config.consumeSoundEffects()) {
            action = CONSUMED;
            actionColor = COLOR_CONSUMED;
        }
        if (this.plugin.blacklistedSounds.contains(soundId)) {
            action = BLACKLISTED;
            actionColor = COLOR_BLACKLISTED;
        }
        if (this.plugin.whitelistedSounds.contains(soundId)) {
            action = WHITELISTED;
            actionColor = COLOR_WHITELISTED;
        }
        if (this.plugin.customSounds.containsKey(soundId)) {
            action = CUSTOM;
            actionColor = COLOR_CUSTOM;
        }
        this.panelComponent.getChildren().add(LineComponent.builder().left(text).leftColor(COLOR_SOUND_EFFECT).right(action).rightColor(actionColor).build());
        this.checkMaxLines();
    }

    @Subscribe
    public void onAreaSoundEffectPlayed(AreaSoundEffectPlayed event) {
        LocalPoint lp;
        if (!this.config.debugSoundEffects()) {
            return;
        }
        Color textColor = COLOR_AREA_SOUND_EFFECT;
        Color actionColor = COLOR_ALLOWED;
        int soundId = event.getSoundId();
        String text = "A: " + soundId;
        String action = ALLOWED;
        Player localPlayer = this.client.getLocalPlayer();
        if (localPlayer != null && (lp = localPlayer.getLocalLocation()) != null) {
            int sceneX = lp.getSceneX();
            int sceneY = lp.getSceneY();
            int distance = Math.abs(sceneX - event.getSceneX()) + Math.abs(sceneY - event.getSceneY());
            if (distance > event.getRange()) {
                textColor = COLOR_SILENT_SOUND_EFFECT;
                text = "SA: " + soundId;
            }
        }
        if (this.config.consumeAreaSounds()) {
            action = CONSUMED;
            actionColor = COLOR_CONSUMED;
        }
        if (this.plugin.blacklistedAreaSounds.contains(soundId)) {
            action = BLACKLISTED;
            actionColor = COLOR_BLACKLISTED;
        }
        if (this.plugin.whitelistedAreaSounds.contains(soundId)) {
            action = WHITELISTED;
            actionColor = COLOR_WHITELISTED;
        }
        if (this.plugin.customAreaSounds.containsKey(soundId)) {
            action = CUSTOM;
            actionColor = COLOR_CUSTOM;
        }
        this.panelComponent.getChildren().add(LineComponent.builder().left(text).leftColor(textColor).right(action).rightColor(actionColor).build());
        this.checkMaxLines();
    }

    private void checkMaxLines() {
        while (this.panelComponent.getChildren().size() > 10) {
            this.panelComponent.getChildren().remove(1);
        }
    }

    public void resetLines() {
        this.panelComponent.getChildren().clear();
        this.panelComponent.getChildren().add(LineComponent.builder().left("Sound Effects").leftColor(Color.CYAN).build());
    }
}

