/*
 * Decompiled with CFR 0.152.
 */
package com.zom.leftclickdrop;

import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.google.inject.Provides;
import com.zom.leftclickdrop.ZomLeftClickDropperConfig;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.events.ClientTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Custom Left Click Drop")
public class ZomLeftClickDropper
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ZomLeftClickDropper.class);
    @Inject
    private Client client;
    @Inject
    private ZomLeftClickDropperConfig config;
    private final ArrayListMultimap<String, Integer> optionIndexes = ArrayListMultimap.create();
    private List<String> itemList;
    private HashSet<String> releaseItems;
    private Splitter CONFIG_SPLITTER = Splitter.onPattern((String)"([,\n])").omitEmptyStrings().trimResults();

    @Subscribe
    public void onClientTick(ClientTick clientTick) {
        if (this.client.getGameState() != GameState.LOGGED_IN || this.client.isMenuOpen()) {
            return;
        }
        MenuEntry[] menuEntries = this.client.getMenuEntries();
        int idx = 0;
        this.optionIndexes.clear();
        for (MenuEntry entry : menuEntries) {
            String option = Text.removeTags((String)entry.getOption()).toLowerCase();
            this.optionIndexes.put((Object)option, (Object)idx++);
        }
        this.swapMenuEntry(menuEntries);
    }

    private void swapMenuEntry(MenuEntry[] menuEntry) {
        try {
            if (this.itemList == null || menuEntry == null || this.itemList.size() == 0) {
                return;
            }
            String option = Text.removeTags((String)menuEntry[menuEntry.length - 1].getOption()).toLowerCase();
            String target = Text.removeTags((String)menuEntry[menuEntry.length - 1].getTarget()).toLowerCase();
            for (String item : this.itemList) {
                if (!item.equals(target)) continue;
                if (option.equals("wield") && this.releaseItems.contains(target)) {
                    this.swap("release", option, target, true);
                    continue;
                }
                this.swap("drop", option, target, true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void swap(String optionA, String optionB, String target, boolean strict) {
        int idxB;
        MenuEntry[] entries = this.client.getMenuEntries();
        int idxA = this.searchIndex(entries, optionA, target, strict);
        if (idxA != (idxB = this.searchIndex(entries, optionB, target, strict))) {
            MenuEntry entry1 = entries[idxB];
            MenuEntry entry2 = entries[idxA];
            entries[idxA] = entry1;
            entries[idxB] = entry2;
            if (entry1.isItemOp() && entry1.getType() == MenuAction.CC_OP_LOW_PRIORITY) {
                entry1.setType(MenuAction.CC_OP);
            }
            if (entry2.isItemOp() && entry2.getType() == MenuAction.CC_OP_LOW_PRIORITY) {
                entry2.setType(MenuAction.CC_OP);
            }
            this.client.setMenuEntries(entries);
        }
    }

    private int searchIndex(MenuEntry[] entries, String option, String target, boolean strict) {
        for (int i = entries.length - 1; i >= 0; --i) {
            MenuEntry entry = entries[i];
            String entryOption = Text.removeTags((String)entry.getOption()).toLowerCase();
            String entryTarget = Text.removeTags((String)entry.getTarget()).toLowerCase();
            if (!(strict ? entryOption.equals(option) && entryTarget.equals(target) : entryOption.contains(option.toLowerCase()) && entryTarget.equals(target))) continue;
            return i;
        }
        return -1;
    }

    @Provides
    ZomLeftClickDropperConfig provideConfig(ConfigManager configManager) {
        return (ZomLeftClickDropperConfig)configManager.getConfig(ZomLeftClickDropperConfig.class);
    }

    protected void startUp() {
        this.itemList = this.CONFIG_SPLITTER.splitToList((CharSequence)this.config.itemList().toLowerCase());
        this.releaseItems = new HashSet();
        this.releaseItems.add("black salamander");
        this.releaseItems.add("orange salamander");
        this.releaseItems.add("red salamander");
        this.releaseItems.add("swamp lizard");
    }

    protected void shutDown() {
        this.releaseItems = null;
        this.itemList = null;
    }

    @Subscribe
    private void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("leftclickdrop")) {
            this.itemList = this.CONFIG_SPLITTER.splitToList((CharSequence)this.config.itemList().toLowerCase());
        }
    }
}

