/*
 * Decompiled with CFR 0.152.
 */
package com.starcallingassist.sidepanel;

import com.starcallingassist.StarCallingAssistPlugin;
import com.starcallingassist.sidepanel.StarData;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.DynamicGridLayout;
import net.runelite.client.ui.FontManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableRow
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(TableRow.class);
    private StarData data;
    private boolean rowVisible;
    private Color lastBackground;
    private StarCallingAssistPlugin plugin;
    private final MouseAdapter labelMouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            TableRow.this.dispatchEvent(mouseEvent);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            TableRow.this.dispatchEvent(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            TableRow.this.dispatchEvent(mouseEvent);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            TableRow.this.dispatchEvent(mouseEvent);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            TableRow.this.dispatchEvent(mouseEvent);
        }
    };

    TableRow(final StarData data, final StarCallingAssistPlugin plugin) {
        this.data = data;
        this.plugin = plugin;
        this.setRowVisible(true);
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(2, 0, 2, 0));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                    plugin.queueWorldHop(data.getWorldId());
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    TableRow.this.setBackground(TableRow.this.getBackground().brighter());
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    TableRow.this.setBackground(TableRow.this.getBackground().darker());
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                TableRow.this.lastBackground = TableRow.this.getBackground();
                TableRow.this.setBackground(ColorScheme.DARKER_GRAY_HOVER_COLOR);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                TableRow.this.setBackground(TableRow.this.lastBackground);
            }
        });
        JPanel row = new JPanel(new BorderLayout());
        JPanel leftSide = new JPanel(new BorderLayout());
        JPanel center = new JPanel(new BorderLayout());
        JPanel rightSide = new JPanel(new BorderLayout());
        row.setOpaque(false);
        leftSide.setOpaque(false);
        center.setOpaque(false);
        rightSide.setOpaque(false);
        leftSide.add((Component)this.buildWorldField(), "West");
        leftSide.add((Component)this.buildTierField(), "Center");
        center.add((Component)this.buildLocationField(), "Center");
        rightSide.add((Component)this.buildDeadTimeField(), "Center");
        rightSide.add((Component)this.buildFoundByField(), "East");
        row.add((Component)leftSide, "West");
        row.add((Component)center, "Center");
        row.add((Component)rightSide, "East");
        this.add(row);
    }

    private JPanel buildWorldField() {
        JPanel column = new JPanel(new BorderLayout());
        column.setOpaque(false);
        Object worldTypeSpecifier = this.data.getWorldTypeSpecifier();
        if (worldTypeSpecifier != "") {
            worldTypeSpecifier = " " + (String)worldTypeSpecifier;
        }
        Color foreground = null;
        if (this.data.getWorldId() == this.plugin.getClient().getWorld()) {
            foreground = Color.GREEN;
        } else if (this.data.getWorldTypeSpecifier() == "PVP") {
            foreground = Color.RED;
        } else if (this.data.isP2p()) {
            foreground = Color.ORANGE;
        }
        JPanel worldField = this.buildMultiLineTextField(this.data.getWorldId() + (String)worldTypeSpecifier, 3, foreground);
        worldField.setBorder(new EmptyBorder(0, 2, 0, 0));
        worldField.setPreferredSize(new Dimension(30, 30));
        column.add(worldField);
        column.addMouseListener(this.labelMouseListener);
        return column;
    }

    private JPanel buildTierField() {
        JPanel column = new JPanel(new BorderLayout());
        column.setOpaque(false);
        JLabel tierField = new JLabel("" + this.data.getTier(this.plugin.getConfig().estimateTier()), 0);
        tierField.setFont(FontManager.getRunescapeSmallFont());
        tierField.setPreferredSize(new Dimension(20, 30));
        column.add(tierField);
        column.addMouseListener(this.labelMouseListener);
        return column;
    }

    private JPanel buildLocationField() {
        JPanel column = new JPanel(new BorderLayout());
        column.setOpaque(false);
        JPanel locationField = this.buildMultiLineTextField(this.data.getLocation(), 16, this.data.isWilderness() ? Color.RED : null);
        locationField.setBorder(new EmptyBorder(0, 2, 0, 2));
        column.add(locationField);
        column.addMouseListener(this.labelMouseListener);
        return column;
    }

    private JPanel buildDeadTimeField() {
        JPanel column = new JPanel(new BorderLayout());
        column.setOpaque(false);
        JLabel deadTimeField = new JLabel(this.data.getDeadTime() + "m");
        deadTimeField.setForeground(this.data.getDeadTime() <= 0 ? Color.RED : (this.data.getDeadTime() <= 20 ? Color.YELLOW : Color.GREEN));
        deadTimeField.setHorizontalAlignment(0);
        deadTimeField.setFont(FontManager.getRunescapeSmallFont());
        deadTimeField.setPreferredSize(new Dimension(40, 30));
        column.add(deadTimeField);
        column.addMouseListener(this.labelMouseListener);
        return column;
    }

    private JPanel buildFoundByField() {
        JPanel column = new JPanel(new BorderLayout());
        column.setOpaque(false);
        JPanel foundByField = this.buildMultiLineTextField(this.fitUsername(this.data.getFoundBy(), 8), 8, null);
        foundByField.setPreferredSize(new Dimension(50, 30));
        column.add(foundByField);
        column.addMouseListener(this.labelMouseListener);
        return column;
    }

    private JPanel buildMultiLineTextField(String text, int charLimit, Color foreground) {
        JPanel column = new JPanel((LayoutManager)new DynamicGridLayout(3, 1));
        List<String> lines = this.getLines(text, charLimit);
        for (int i = 0; i < lines.size() && i < 3; ++i) {
            JLabel label = new JLabel(lines.get(i));
            label.setFont(FontManager.getRunescapeSmallFont());
            if (foreground != null) {
                label.setForeground(foreground);
            }
            column.add(label);
        }
        column.setOpaque(false);
        return column;
    }

    private List<String> getLines(String text, int lineLength) {
        ArrayList<String> lines = new ArrayList<String>();
        Object currentLine = "";
        for (String s : text.split(" ")) {
            if (s.length() + ((String)currentLine).length() + 1 > lineLength) {
                if (((String)currentLine).isEmpty()) {
                    lines.add(s);
                    continue;
                }
                lines.add((String)currentLine);
                currentLine = s;
                continue;
            }
            currentLine = (String)currentLine + (String)(((String)currentLine).isEmpty() ? s : " " + s);
        }
        if (!((String)currentLine).isEmpty()) {
            lines.add((String)currentLine);
        }
        return lines;
    }

    private String fitUsername(String username, int charLimit) {
        if (username.length() > charLimit) {
            CharSequence[] arr = username.split(" ");
            for (int i = 0; i < arr.length; ++i) {
                if (arr[i].length() <= charLimit - 1) continue;
                arr[i] = ((String)arr[i]).substring(0, charLimit - 1) + " " + ((String)arr[i]).substring(charLimit - 1);
            }
            username = String.join((CharSequence)" ", arr);
        }
        return username;
    }

    public StarData getData() {
        return this.data;
    }

    public boolean isRowVisible() {
        return this.rowVisible;
    }

    public void setRowVisible(boolean rowVisible) {
        this.rowVisible = rowVisible;
    }

    private static final class StringBool {
        private final String string;
        private final boolean boolValue;

        public String getString() {
            return this.string;
        }

        public boolean isBoolValue() {
            return this.boolValue;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StringBool)) {
                return false;
            }
            StringBool other = (StringBool)o;
            if (this.isBoolValue() != other.isBoolValue()) {
                return false;
            }
            String this$string = this.getString();
            String other$string = other.getString();
            return !(this$string == null ? other$string != null : !this$string.equals(other$string));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isBoolValue() ? 79 : 97);
            String $string = this.getString();
            result = result * 59 + ($string == null ? 43 : $string.hashCode());
            return result;
        }

        public String toString() {
            return "TableRow.StringBool(string=" + this.getString() + ", boolValue=" + this.isBoolValue() + ")";
        }

        public StringBool(String string, boolean boolValue) {
            this.string = string;
            this.boolValue = boolValue;
        }
    }
}

