/*
 * Decompiled with CFR 0.152.
 */
package com.starcallingassist.sidepanel;

import com.starcallingassist.StarCallingAssistPlugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.ImageUtil;

class TableHeader
extends JPanel {
    private static final ImageIcon ARROW_UP;
    private static final ImageIcon HIGHLIGHT_ARROW_DOWN;
    private static final ImageIcon HIGHLIGHT_ARROW_UP;
    private static final Color ARROW_COLOR;
    private static final Color HIGHLIGHT_COLOR;
    private final JLabel textLabel = new JLabel();
    private final JLabel arrowLabel = new JLabel();
    private boolean ordering = false;

    TableHeader(String title, boolean ordered, boolean ascending) {
        this.setLayout(new BorderLayout(0, 0));
        this.setBackground(ColorScheme.SCROLL_TRACK_COLOR);
        this.setBorder(new CompoundBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, ColorScheme.MEDIUM_GRAY_COLOR), new EmptyBorder(0, 2, 0, -2)));
        this.arrowLabel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.textLabel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                TableHeader.this.textLabel.setForeground(HIGHLIGHT_COLOR);
                if (!TableHeader.this.ordering) {
                    TableHeader.this.arrowLabel.setIcon(HIGHLIGHT_ARROW_UP);
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                if (!TableHeader.this.ordering) {
                    TableHeader.this.textLabel.setForeground(ARROW_COLOR);
                    TableHeader.this.arrowLabel.setIcon(ARROW_UP);
                }
            }
        });
        this.textLabel.setText(title);
        this.textLabel.setFont(FontManager.getRunescapeSmallFont());
        this.highlight(ordered, ascending);
        this.add((Component)this.textLabel, "West");
        this.add((Component)this.arrowLabel, "East");
    }

    TableHeader(String title) {
        this.setLayout(new BorderLayout(0, 0));
        this.setBackground(ColorScheme.SCROLL_TRACK_COLOR);
        this.setBorder(new CompoundBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, ColorScheme.MEDIUM_GRAY_COLOR), new EmptyBorder(0, 2, 0, -2)));
        this.textLabel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.textLabel.setText(title);
        this.textLabel.setFont(FontManager.getRunescapeSmallFont());
        this.add((Component)this.textLabel, "West");
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        super.addMouseListener(mouseListener);
        this.textLabel.addMouseListener(mouseListener);
        this.arrowLabel.addMouseListener(mouseListener);
    }

    public void highlight(boolean on, boolean ascending) {
        this.ordering = on;
        this.arrowLabel.setIcon(on ? (ascending ? HIGHLIGHT_ARROW_DOWN : HIGHLIGHT_ARROW_UP) : ARROW_UP);
        this.textLabel.setForeground(on ? HIGHLIGHT_COLOR : ARROW_COLOR);
    }

    static {
        ARROW_COLOR = ColorScheme.LIGHT_GRAY_COLOR;
        HIGHLIGHT_COLOR = ColorScheme.BRAND_ORANGE;
        BufferedImage arrowDown = ImageUtil.loadImageResource(StarCallingAssistPlugin.class, (String)"/arrow_down.png");
        BufferedImage arrowUp = ImageUtil.rotateImage((BufferedImage)arrowDown, (double)Math.PI);
        BufferedImage arrowUpFaded = ImageUtil.luminanceOffset((Image)arrowUp, (int)-80);
        ARROW_UP = new ImageIcon(arrowUpFaded);
        BufferedImage highlightArrowDown = ImageUtil.fillImage((BufferedImage)arrowDown, (Color)HIGHLIGHT_COLOR);
        BufferedImage highlightArrowUp = ImageUtil.fillImage((BufferedImage)arrowUp, (Color)HIGHLIGHT_COLOR);
        HIGHLIGHT_ARROW_DOWN = new ImageIcon(highlightArrowDown);
        HIGHLIGHT_ARROW_UP = new ImageIcon(highlightArrowUp);
    }
}

