/*
 * Decompiled with CFR 0.152.
 */
package com.starcallingassist.sidepanel;

import com.starcallingassist.sidepanel.constants.TotalLevelType;
import java.util.EnumSet;
import net.runelite.http.api.worlds.World;
import net.runelite.http.api.worlds.WorldType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StarData {
    private static final Logger log = LoggerFactory.getLogger(StarData.class);
    private int tier;
    private int worldId;
    private World world;
    private int region;
    private long updatedAt;
    private String location;
    private String foundBy;
    private final int[] timeUntilDead = new int[]{0, 420000, 840000, 1260000, 1680000, 0x200B20, 2520000, 2940000, 3360000, 3780000};

    public StarData(int worldId, World world, int tier, String location, String foundBy, long updatedAt, int region) {
        this.worldId = worldId;
        this.world = world;
        this.tier = tier;
        this.location = location;
        this.foundBy = foundBy;
        this.updatedAt = updatedAt;
        this.region = region;
    }

    public int getTier(boolean estimate) {
        if (!estimate) {
            return this.tier;
        }
        long timeSinceUpdate = System.currentTimeMillis() - this.updatedAt * 1000L;
        for (int i = 0; i < this.timeUntilDead.length; ++i) {
            if ((long)this.timeUntilDead[i] <= (long)this.timeUntilDead[this.tier] - timeSinceUpdate) continue;
            return i;
        }
        return 9;
    }

    public int getDeadTime() {
        long deadAt = this.updatedAt * 1000L + (long)this.timeUntilDead[this.tier];
        return (int)((deadAt - System.currentTimeMillis()) / 60000L);
    }

    public EnumSet<WorldType> getWorldTypes() {
        if (this.world == null) {
            return null;
        }
        return this.world.getTypes();
    }

    public TotalLevelType getTotalLevelType() {
        if (!this.world.getTypes().contains(WorldType.SKILL_TOTAL)) {
            return TotalLevelType.NONE;
        }
        switch (this.world.getActivity().substring(0, 4).trim()) {
            case "500": {
                return TotalLevelType.TOTAL_500;
            }
            case "750": {
                return TotalLevelType.TOTAL_750;
            }
            case "1250": {
                return TotalLevelType.TOTAL_1250;
            }
            case "1500": {
                return TotalLevelType.TOTAL_1500;
            }
            case "1750": {
                return TotalLevelType.TOTAL_1750;
            }
            case "2000": {
                return TotalLevelType.TOTAL_2000;
            }
            case "2200": {
                return TotalLevelType.TOTAL_2200;
            }
        }
        return TotalLevelType.NONE;
    }

    public String getWorldTypeSpecifier() {
        if (this.world == null) {
            return "";
        }
        if (this.world.getTypes().contains(WorldType.SKILL_TOTAL)) {
            return this.world.getActivity().substring(0, 4).trim();
        }
        if (this.world.getTypes().contains(WorldType.PVP)) {
            return "PVP";
        }
        if (this.world.getTypes().contains(WorldType.HIGH_RISK)) {
            return "HR";
        }
        if (this.world.getTypes().contains(WorldType.BETA_WORLD)) {
            return "Beta";
        }
        if (this.world.getTypes().contains(WorldType.DEADMAN)) {
            return "DMM";
        }
        if (this.world.getTypes().contains(WorldType.SEASONAL)) {
            return "S";
        }
        return "";
    }

    public boolean isWilderness() {
        return this.region == 13;
    }

    public boolean isPvp() {
        if (this.world == null) {
            return true;
        }
        return this.world.getTypes().contains(WorldType.PVP);
    }

    public boolean isHighRisk() {
        if (this.world == null) {
            return true;
        }
        return this.world.getTypes().contains(WorldType.HIGH_RISK);
    }

    public boolean isP2p() {
        if (this.world == null) {
            return true;
        }
        return this.world.getTypes().contains(WorldType.MEMBERS);
    }

    public int getWorldId() {
        return this.worldId;
    }

    public World getWorld() {
        return this.world;
    }

    public int getRegion() {
        return this.region;
    }

    public long getUpdatedAt() {
        return this.updatedAt;
    }

    public String getLocation() {
        return this.location;
    }

    public String getFoundBy() {
        return this.foundBy;
    }
}

