/*
 * Decompiled with CFR 0.152.
 */
package com.starcallingassist.sidepanel;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.starcallingassist.StarCallingAssistPlugin;
import com.starcallingassist.sidepanel.InfoPanel;
import com.starcallingassist.sidepanel.StarData;
import com.starcallingassist.sidepanel.TableHeader;
import com.starcallingassist.sidepanel.TableRow;
import com.starcallingassist.sidepanel.constants.OrderBy;
import com.starcallingassist.sidepanel.constants.Region;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.runelite.api.GameState;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.game.WorldService;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.DynamicGridLayout;
import net.runelite.client.ui.PluginPanel;
import net.runelite.http.api.worlds.World;
import net.runelite.http.api.worlds.WorldResult;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SidePanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(SidePanel.class);
    private static final Color ODD_ROW_COLOR = new Color(44, 44, 44);
    public static final int WORLD_COLUMN_WIDTH = 30;
    public static final int TIER_COLUMN_WIDTH = 20;
    public static final int DEAD_TIME_COLUMN_WIDTH = 40;
    public static final int FOUND_BY_COLUMN_WIDTH = 50;
    private static final int FETCH_TIMEOUT = 20000;
    private long nextFetch = 0L;
    private TableHeader worldHeader;
    private TableHeader tierHeader;
    private TableHeader locationHeader;
    private TableHeader deadTimeHeader;
    private TableHeader foundByHeader;
    private JPanel tableRowContainer;
    private InfoPanel infoPanel;
    @Inject
    OkHttpClient okHttpClient;
    @Inject
    Gson gson;
    @Inject
    WorldService worldService;
    @Inject
    StarCallingAssistPlugin plugin;
    @Inject
    ConfigManager configManager;
    private OrderBy orderBy = OrderBy.TIER;
    private boolean ascendingOrder = true;
    private final List<TableRow> tableRows = new ArrayList<TableRow>();
    private List<StarData> starData = new ArrayList<StarData>();
    private List<World> worldList = new ArrayList<World>();

    public void init() {
        this.setBorder(null);
        this.setLayout((LayoutManager)new DynamicGridLayout(0, 1));
        this.infoPanel = new InfoPanel(this.plugin);
        JPanel headerContainer = this.buildTableHeader();
        this.tableRowContainer = new JPanel();
        this.tableRowContainer.setLayout(new GridLayout(0, 1));
        this.add(this.infoPanel);
        this.add(headerContainer);
        this.add(this.tableRowContainer);
        this.fetchWorldData();
        this.fetchStarData();
    }

    public void updateInfoPanel() {
        this.infoPanel.rebuild();
    }

    public void updateTableRows() {
        this.tableRowContainer.removeAll();
        this.tableRows.sort((r1, r2) -> {
            switch (this.orderBy) {
                case WORLD: {
                    return this.ascendingOrder ? Integer.compare(r2.getData().getWorldId(), r1.getData().getWorldId()) : Integer.compare(r1.getData().getWorldId(), r2.getData().getWorldId());
                }
                case TIER: {
                    return this.ascendingOrder ? Integer.compare(r2.getData().getTier(this.plugin.getConfig().estimateTier()), r1.getData().getTier(this.plugin.getConfig().estimateTier())) : Integer.compare(r1.getData().getTier(this.plugin.getConfig().estimateTier()), r2.getData().getTier(this.plugin.getConfig().estimateTier()));
                }
                case LOCATION: {
                    return this.ascendingOrder ? r2.getData().getLocation().compareTo(r1.getData().getLocation()) : r1.getData().getLocation().compareTo(r2.getData().getLocation());
                }
                case DEAD_TIME: {
                    return this.ascendingOrder ? Integer.compare(r2.getData().getDeadTime(), r1.getData().getDeadTime()) : Integer.compare(r1.getData().getDeadTime(), r2.getData().getDeadTime());
                }
            }
            return 0;
        });
        for (TableRow row : this.tableRows) {
            row.setRowVisible(this.shouldBeVisible(row.getData()));
            if (!row.isRowVisible()) continue;
            this.tableRowContainer.add(row);
        }
        this.colorRows();
        this.tableRowContainer.revalidate();
        this.tableRowContainer.repaint();
    }

    public void rebuildTableRows() {
        this.tableRows.clear();
        for (StarData data : this.starData) {
            this.tableRows.add(new TableRow(data, this.plugin));
        }
        this.updateTableRows();
    }

    private boolean shouldBeVisible(StarData data) {
        if (data.isP2p() && !this.plugin.getConfig().showMembers()) {
            return false;
        }
        if (!data.isP2p() && !this.plugin.getConfig().showF2P()) {
            return false;
        }
        if (data.isPvp() && !this.plugin.getConfig().showPvp()) {
            return false;
        }
        if (data.isHighRisk() && !this.plugin.getConfig().showHighRisk()) {
            return false;
        }
        if (data.getTotalLevelType().ordinal() > this.plugin.getConfig().totalLevelType().ordinal()) {
            return false;
        }
        if (data.getTier(this.plugin.getConfig().estimateTier()) < this.plugin.getConfig().minTier() || data.getTier(this.plugin.getConfig().estimateTier()) > this.plugin.getConfig().maxTier()) {
            return false;
        }
        if (data.getDeadTime() < this.plugin.getConfig().minDeadTime()) {
            return false;
        }
        Region[] regions = Region.values();
        if (data.getRegion() >= 0 && data.getRegion() < regions.length) {
            return Boolean.parseBoolean(this.configManager.getConfiguration("starcallingassistplugin", regions[data.getRegion()].getKeyName()));
        }
        return true;
    }

    private void colorRows() {
        int i = 0;
        for (TableRow row : this.tableRows) {
            if (!row.isRowVisible()) continue;
            if (i++ % 2 == 0) {
                row.setBackground(ColorScheme.DARKER_GRAY_COLOR);
                continue;
            }
            row.setBackground(ODD_ROW_COLOR);
        }
    }

    private JPanel buildTableHeader() {
        JPanel header = new JPanel(new BorderLayout());
        JPanel leftSide = new JPanel(new BorderLayout());
        JPanel center = new JPanel(new BorderLayout());
        JPanel rightSide = new JPanel(new BorderLayout());
        this.worldHeader = new TableHeader("W", this.orderBy == OrderBy.WORLD, this.ascendingOrder);
        this.worldHeader.setPreferredSize(new Dimension(30, 0));
        this.worldHeader.addMouseListener(new HeaderMouseListener(OrderBy.WORLD, this));
        this.tierHeader = new TableHeader("T", this.orderBy == OrderBy.TIER, this.ascendingOrder);
        this.tierHeader.setPreferredSize(new Dimension(20, 0));
        this.tierHeader.addMouseListener(new HeaderMouseListener(OrderBy.TIER, this));
        this.locationHeader = new TableHeader("Location", this.orderBy == OrderBy.LOCATION, this.ascendingOrder);
        this.locationHeader.addMouseListener(new HeaderMouseListener(OrderBy.LOCATION, this));
        this.deadTimeHeader = new TableHeader("Dead", this.orderBy == OrderBy.DEAD_TIME, this.ascendingOrder);
        this.deadTimeHeader.setPreferredSize(new Dimension(40, 0));
        this.deadTimeHeader.addMouseListener(new HeaderMouseListener(OrderBy.DEAD_TIME, this));
        this.foundByHeader = new TableHeader("Found by");
        this.foundByHeader.setPreferredSize(new Dimension(50, 0));
        leftSide.add((Component)this.worldHeader, "West");
        leftSide.add((Component)this.tierHeader, "Center");
        center.add((Component)this.locationHeader, "Center");
        rightSide.add((Component)this.deadTimeHeader, "Center");
        rightSide.add((Component)this.foundByHeader, "East");
        header.add((Component)leftSide, "West");
        header.add((Component)center, "Center");
        header.add((Component)rightSide, "East");
        return header;
    }

    public void setOrderBy(OrderBy order) {
        this.worldHeader.highlight(false, this.ascendingOrder);
        this.tierHeader.highlight(false, this.ascendingOrder);
        this.locationHeader.highlight(false, this.ascendingOrder);
        this.deadTimeHeader.highlight(false, this.ascendingOrder);
        switch (order) {
            case WORLD: {
                this.worldHeader.highlight(true, this.ascendingOrder);
                break;
            }
            case TIER: {
                this.tierHeader.highlight(true, this.ascendingOrder);
                break;
            }
            case LOCATION: {
                this.locationHeader.highlight(true, this.ascendingOrder);
                break;
            }
            case DEAD_TIME: {
                this.deadTimeHeader.highlight(true, this.ascendingOrder);
            }
        }
        this.orderBy = order;
        this.updateTableRows();
    }

    public void fetchWorldData() {
        WorldResult worldResult = this.worldService.getWorlds();
        if (worldResult == null) {
            return;
        }
        List worlds = worldResult.getWorlds();
        if (worlds == null || worlds.isEmpty()) {
            return;
        }
        this.worldList = worlds;
    }

    private World getWorldObject(int worldId) {
        Optional<World> result = this.worldList.stream().filter(world -> world.getId() == worldId).findFirst();
        if (result.isPresent()) {
            return result.get();
        }
        return null;
    }

    public void fetchStarData() {
        if (this.nextFetch > System.currentTimeMillis()) {
            return;
        }
        if (this.plugin.getConfig().getAuthorization().isEmpty()) {
            SwingUtilities.invokeLater(() -> this.infoPanel.setErrorMessage(""));
            return;
        }
        if (this.plugin.getClient().getGameState() != GameState.LOGGED_IN) {
            SwingUtilities.invokeLater(() -> this.infoPanel.setErrorMessage("You need to be logged in to update the list!"));
            return;
        }
        this.nextFetch = System.currentTimeMillis() + 20000L;
        try {
            Request request = new Request.Builder().url(this.plugin.getConfig().getEndpoint()).addHeader("authorization", this.plugin.getConfig().getAuthorization()).addHeader("plugin", this.plugin.getName()).get().build();
            this.okHttpClient.newCall(request).enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                    SwingUtilities.invokeLater(() -> SidePanel.this.infoPanel.setErrorMessage(e.getMessage()));
                    call.cancel();
                }

                public void onResponse(Call call, Response res) throws IOException {
                    if (res.isSuccessful()) {
                        SwingUtilities.invokeLater(() -> SidePanel.this.infoPanel.setErrorMessage(""));
                        SidePanel.this.parseData(res.body());
                    } else {
                        SwingUtilities.invokeLater(() -> SidePanel.this.infoPanel.setErrorMessage(res.message()));
                    }
                    res.close();
                }
            });
        }
        catch (IllegalArgumentException iae) {
            SwingUtilities.invokeLater(() -> this.infoPanel.setErrorMessage("Invalid endpoint!"));
        }
    }

    private void parseData(@Nullable ResponseBody body) {
        ArrayList<StarData> starData = new ArrayList<StarData>();
        if (body == null) {
            return;
        }
        try {
            JsonArray jsonArray = (JsonArray)this.gson.fromJson(body.string(), JsonArray.class);
            if (jsonArray.size() < 1) {
                return;
            }
            for (JsonElement element : jsonArray) {
                JsonObject obj = element.getAsJsonObject();
                if (!obj.has("world") || !obj.has("tier") || !obj.has("calledLocation") || !obj.has("calledBy") || !obj.has("calledAt") || !obj.has("location")) continue;
                starData.add(new StarData(obj.get("world").getAsInt(), this.getWorldObject(obj.get("world").getAsInt()), obj.get("tier").getAsInt(), obj.get("calledLocation").getAsString(), obj.get("calledBy").getAsString(), obj.get("calledAt").getAsLong(), obj.get("location").getAsInt()));
            }
        }
        catch (Exception e) {
            log.error("Error parsing response! " + e.getMessage());
        }
        if (!starData.isEmpty()) {
            this.starData = starData;
            SwingUtilities.invokeLater(this::rebuildTableRows);
        }
    }

    private List<Integer> getHiddenRegions() {
        ArrayList<Integer> hiddenRegions = new ArrayList<Integer>();
        for (Region region : Region.values()) {
            if (Boolean.parseBoolean(this.configManager.getConfiguration("starcallingassistplugin", region.keyName))) continue;
            hiddenRegions.add(region.ordinal());
        }
        return hiddenRegions;
    }

    public OrderBy getOrderBy() {
        return this.orderBy;
    }

    public boolean isAscendingOrder() {
        return this.ascendingOrder;
    }

    public void setAscendingOrder(boolean ascendingOrder) {
        this.ascendingOrder = ascendingOrder;
    }

    private class HeaderMouseListener
    extends MouseAdapter {
        private final OrderBy orderBy;
        private final SidePanel sidePanel;

        public HeaderMouseListener(OrderBy orderBy, SidePanel sidePanel2) {
            this.orderBy = orderBy;
            this.sidePanel = sidePanel2;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                return;
            }
            this.sidePanel.setAscendingOrder(this.sidePanel.getOrderBy() != this.orderBy || !this.sidePanel.isAscendingOrder());
            this.sidePanel.setOrderBy(this.orderBy);
        }
    }
}

