/*
 * Decompiled with CFR 0.152.
 */
package com.starcallingassist.sidepanel;

import com.starcallingassist.StarCallingAssistPlugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfoPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(InfoPanel.class);
    private final StarCallingAssistPlugin plugin;
    private String errorMessage = "";

    public InfoPanel(StarCallingAssistPlugin plugin) {
        this.plugin = plugin;
        this.setLayout(new BorderLayout());
        this.setBackground(ColorScheme.SCROLL_TRACK_COLOR);
        this.build();
    }

    public void rebuild() {
        this.removeAll();
        this.build();
        this.revalidate();
        this.repaint();
    }

    public void setErrorMessage(String errorMessage) {
        if (errorMessage.equals(this.errorMessage)) {
            return;
        }
        this.errorMessage = errorMessage;
        this.rebuild();
    }

    private void build() {
        JPanel top = new JPanel(new BorderLayout());
        JPanel bottom = new JPanel(new BorderLayout());
        JPanel discordAdvert = new JPanel(new BorderLayout());
        JLabel discordLink = this.createClickableLink("https://discord.gg/starminers", "Join the Star Miners discord!");
        discordLink.setHorizontalAlignment(0);
        discordAdvert.add((Component)discordLink, "Center");
        discordAdvert.setOpaque(false);
        top.add((Component)discordAdvert, "North");
        if (this.plugin.getConfig().getAuthorization().isEmpty()) {
            JPanel missingKeyInfo = new JPanel(new BorderLayout());
            JLabel keyInfo = new JLabel("<html>To see the list of active stars you need to enter your unique key into the <b>Authorization</b> field in the plugin settings. <br><br> You can get your unique key from the starminers discord: <br><br> discord.gg/starminers</html>");
            keyInfo.setBorder(new EmptyBorder(10, 3, 5, 3));
            missingKeyInfo.add(keyInfo);
            missingKeyInfo.setOpaque(false);
            top.add((Component)missingKeyInfo, "South");
        }
        top.setOpaque(false);
        this.add((Component)top, "North");
        if (!this.errorMessage.isEmpty()) {
            JPanel errorPanel = new JPanel(new BorderLayout());
            JLabel errorInfo = new JLabel("<html>Error when fetching list of stars: <br><br>" + this.errorMessage + "</html>");
            errorInfo.setForeground(Color.RED);
            errorInfo.setBorder(new EmptyBorder(10, 3, 5, 3));
            errorPanel.add(errorInfo);
            errorPanel.setOpaque(false);
            bottom.add((Component)errorPanel, "North");
            bottom.setOpaque(false);
            this.add((Component)bottom, "South");
        }
    }

    private JLabel createClickableLink(final String url, final String text) {
        final JLabel linkLabel = new JLabel("<html><a href=''>" + text + "</a></html>");
        linkLabel.setCursor(new Cursor(12));
        linkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    Desktop.getDesktop().browse(new URI(url));
                }
                catch (Exception ex) {
                    log.error(ex.getMessage());
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                linkLabel.setText("<html><u><font color='orange'>" + text + "</font></u></html>");
            }

            @Override
            public void mouseExited(MouseEvent e) {
                linkLabel.setText("<html><a href=''>" + text + "</a></html>");
            }
        });
        return linkLabel;
    }
}

