/*
 * Decompiled with CFR 0.152.
 */
package com.starcallingassist;

import com.google.inject.Provides;
import com.starcallingassist.CallSender;
import com.starcallingassist.Star;
import com.starcallingassist.StarCallingAssistConfig;
import com.starcallingassist.sidepanel.SidePanel;
import java.awt.Point;
import java.io.IOException;
import java.time.temporal.ChronoUnit;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.ScriptEvent;
import net.runelite.api.World;
import net.runelite.api.coords.WorldArea;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ResizeableChanged;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.WorldService;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.task.Schedule;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Star Miners", description="Displays a list of active stars and crowdsources data about stars you find and mine", tags={"star", "shooting", "shootingstar", "meteor", "crowdsource", "crowdsourcing"})
public class StarCallingAssistPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(StarCallingAssistPlugin.class);
    private static final Point BUTTON_RESIZEABLE_LOCATION = new Point(130, 150);
    private static final Point BUTTON_FIXED_LOCATION = new Point(208, 55);
    private static final int CALL_STAR = 5;
    private static final int CALL_DEAD = 6;
    private static final int CALL_PRIVATE = 7;
    private static final int PLAYER_RENDER_DISTANCE = 13;
    private Widget parent;
    private Widget callButton;
    private Star lastCalledStar;
    private int miners = 0;
    private int hopTarget = -1;
    private int hopAttempts = 0;
    private WorldPoint confirmDeadLocation = null;
    @Inject
    private StarCallingAssistConfig starConfig;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private WorldService worldService;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private CallSender sender;
    private SidePanel sidePanel;
    private NavigationButton navButton;

    @Provides
    StarCallingAssistConfig provideConfig(ConfigManager configManager) {
        return (StarCallingAssistConfig)configManager.getConfig(StarCallingAssistConfig.class);
    }

    protected void startUp() throws Exception {
        this.lastCalledStar = null;
        this.parent = this.client.getWidget(WidgetInfo.MINIMAP_ORBS);
        this.clientThread.invokeLater(this::createCallButton);
        this.sidePanel = (SidePanel)((Object)this.injector.getInstance(SidePanel.class));
        this.sidePanel.init();
        this.navButton = NavigationButton.builder().tooltip("Star Miners").icon(ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/sminers.png")).panel((PluginPanel)this.sidePanel).build();
        this.clientToolbar.addNavigation(this.navButton);
        this.navButton.setOnClick(this::fetchStarData);
    }

    protected void shutDown() throws Exception {
        Star.removeStar();
        this.lastCalledStar = null;
        this.removeCallButton();
        this.clientToolbar.removeNavigation(this.navButton);
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        int tier = Star.getTier(event.getGameObject().getId());
        if (tier != -1) {
            Star.setStar(event.getGameObject(), tier, this.client.getWorld());
            if (this.starConfig.autoCall()) {
                if (this.whitinPlayerDistance()) {
                    this.countMiners();
                    this.prepareCall(false);
                } else {
                    this.miners = -1;
                    this.prepareCall(false);
                }
            }
        }
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned event) {
        if (Star.getTier(event.getGameObject().getId()) != -1) {
            if (this.starConfig.autoCall()) {
                this.confirmDeadLocation = event.getGameObject().getWorldLocation();
            }
            Star.removeStar();
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged state) {
        if (state.getGameState() == GameState.HOPPING || state.getGameState() == GameState.LOGGING_IN) {
            Star.removeStar();
            this.removeCallButton();
        }
        if (state.getGameState() == GameState.LOGGED_IN) {
            SwingUtilities.invokeLater(() -> this.sidePanel.rebuildTableRows());
            this.fetchStarData();
        }
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        if (this.hopTarget != -1) {
            this.performHop();
        }
        if (this.confirmDeadLocation != null) {
            if (Star.getStar() == null && this.client.getLocalPlayer().getWorldLocation().distanceTo(this.confirmDeadLocation) <= 32) {
                this.attemptCall(this.client.getLocalPlayer().getName(), this.client.getWorld(), 0, Star.getLocationName(this.confirmDeadLocation));
            }
            this.confirmDeadLocation = null;
        }
        if (Star.getStar() != null) {
            if (this.client.getLocalPlayer().getWorldLocation().distanceTo(Star.getStar().location) > 32) {
                Star.removeStar();
            }
            if (Star.getStar() != null) {
                this.countMiners();
            }
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals("starcallingassistplugin")) {
            return;
        }
        if (event.getKey().equals("autoCall")) {
            if (this.starConfig.autoCall()) {
                this.clientThread.invokeLater(() -> this.prepareCall(false));
            }
            return;
        }
        if (event.getKey().equals("updateStar")) {
            if (this.starConfig.autoCall() && this.starConfig.updateStar()) {
                this.clientThread.invokeLater(() -> this.prepareCall(false));
            }
            return;
        }
        if (event.getKey().equals("callHorn")) {
            this.removeCallButton();
            this.parent = this.client.getWidget(WidgetInfo.MINIMAP_ORBS);
            this.clientThread.invokeLater(this::createCallButton);
            return;
        }
        if (event.equals((Object)"endpoint")) {
            this.fetchStarData();
            return;
        }
        if (event.getKey().equals("authorization")) {
            this.sidePanel.updateInfoPanel();
            return;
        }
        if (event.getKey().equals("estimateTier")) {
            this.sidePanel.rebuildTableRows();
            return;
        }
        this.sidePanel.updateTableRows();
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        if (event.getGroupId() == 160 && (this.callButton == null || this.parent == null)) {
            this.removeCallButton();
            this.parent = this.client.getWidget(WidgetInfo.MINIMAP_ORBS);
            this.createCallButton();
        }
    }

    @Subscribe
    public void onResizeableChanged(ResizeableChanged event) {
        this.removeCallButton();
        this.parent = this.client.getWidget(WidgetInfo.MINIMAP_ORBS);
        this.createCallButton();
    }

    @Schedule(period=30L, unit=ChronoUnit.SECONDS)
    public void fetchStarData() {
        if (this.navButton.isSelected()) {
            this.sidePanel.fetchStarData();
        }
    }

    @Schedule(period=10L, unit=ChronoUnit.MINUTES)
    public void fetchWorldData() {
        this.sidePanel.fetchWorldData();
    }

    public Client getClient() {
        return this.client;
    }

    public StarCallingAssistConfig getConfig() {
        return this.starConfig;
    }

    public void queueWorldHop(int worldId) {
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            this.hopTarget = worldId;
            this.clientThread.invokeLater(() -> this.logHighlightedToChat("Attempting to quick-hop to world ", "" + this.hopTarget));
        }
    }

    private void performHop() {
        if (++this.hopAttempts >= 5) {
            this.logHighlightedToChat("Unable to quick-hop to world ", "" + this.hopTarget);
            this.hopTarget = -1;
            this.hopAttempts = 0;
            return;
        }
        if (this.client.getWidget(WidgetInfo.WORLD_SWITCHER_LIST) == null) {
            this.client.openWorldHopper();
            return;
        }
        World[] worldList = this.client.getWorldList();
        if (worldList == null) {
            return;
        }
        for (World world : worldList) {
            if (world.getId() != this.hopTarget) continue;
            this.client.hopToWorld(world);
            break;
        }
        this.hopTarget = -1;
        this.hopAttempts = 0;
    }

    private void countMiners() {
        this.miners = 0;
        Star star = Star.getStar();
        if (!this.whitinPlayerDistance()) {
            this.miners = -1;
            return;
        }
        WorldArea areaH = new WorldArea(star.location.dx(-1), 4, 2);
        WorldArea areaV = new WorldArea(star.location.dy(-1), 2, 4);
        for (Player p : this.client.getPlayers()) {
            if (!p.getWorldLocation().isInArea2D(new WorldArea[]{areaH, areaV})) continue;
            ++this.miners;
        }
    }

    private boolean whitinPlayerDistance() {
        return this.client.getLocalPlayer().getWorldLocation().distanceTo(new WorldArea(Star.getStar().location, 2, 2)) <= 13;
    }

    private void createCallButton() {
        if (this.callButton != null || this.parent == null || !this.starConfig.callHorn()) {
            return;
        }
        this.callButton = this.parent.createChild(5);
        this.callButton.setSpriteId(768);
        this.callButton.setOriginalWidth(20);
        this.callButton.setOriginalHeight(23);
        this.setCallButtonLocation();
        this.callButton.setAction(4, "Call star");
        this.callButton.setAction(5, "Call dead");
        this.callButton.setAction(6, "Call private");
        this.callButton.setHasListener(true);
        this.callButton.setNoClickThrough(true);
        this.callButton.setOnOpListener(new Object[]{this::callButtonClicked});
        this.callButton.revalidate();
    }

    private void callButtonClicked(ScriptEvent event) {
        switch (event.getOp()) {
            case 5: {
                this.prepareCall(true);
                break;
            }
            case 6: {
                this.attemptCall(this.client.getLocalPlayer().getName(), this.client.getWorld(), 0, "dead");
                break;
            }
            case 7: {
                this.attemptCall(this.client.getLocalPlayer().getName(), this.client.getWorld(), 0, "pdead");
            }
        }
    }

    private void removeCallButton() {
        if (this.parent == null || this.callButton == null) {
            return;
        }
        Widget[] children = this.parent.getChildren();
        if (children.length <= this.callButton.getIndex() || !children[this.callButton.getIndex()].equals(this.callButton)) {
            return;
        }
        children[this.callButton.getIndex()] = null;
        this.callButton = null;
        this.parent = null;
    }

    private void prepareCall(boolean manual) {
        if (Star.getStar() == null) {
            if (manual) {
                this.logToChat("Unable to find star.");
            }
            return;
        }
        if (this.lastCalledStar != null && this.lastCalledStar.world == Star.getStar().world && this.lastCalledStar.tier == Star.getStar().tier && this.lastCalledStar.location.equals((Object)Star.getStar().location)) {
            if (manual) {
                this.logToChat("This star has already been called.");
            }
            return;
        }
        if (this.lastCalledStar != null && this.lastCalledStar.world == Star.getStar().world && this.lastCalledStar.location.equals((Object)Star.getStar().location) && this.lastCalledStar.tier > Star.getStar().tier && !this.starConfig.updateStar() && !manual) {
            return;
        }
        String location = Star.getLocationName(Star.getStar().location);
        if (location.equals("unknown")) {
            this.logToChat("Star location is unknown, manual call required.");
            return;
        }
        this.attemptCall(this.client.getLocalPlayer().getName(), this.client.getWorld(), Star.getStar().tier, location);
    }

    private void attemptCall(String username, final int world, final int tier, final String location) {
        try {
            this.sender.sendCall(username, world, tier, location, this.miners, new Callback(){

                public void onFailure(Call call, IOException e) {
                    StarCallingAssistPlugin.this.clientThread.invokeLater(() -> StarCallingAssistPlugin.this.logToChat("Unable to post call to " + StarCallingAssistPlugin.this.starConfig.getEndpoint() + "."));
                    call.cancel();
                }

                public void onResponse(Call call, Response res) throws IOException {
                    if (res.isSuccessful()) {
                        if (tier > 0) {
                            StarCallingAssistPlugin.this.lastCalledStar = Star.getStar();
                        }
                        StarCallingAssistPlugin.this.clientThread.invokeLater(() -> StarCallingAssistPlugin.this.logHighlightedToChat("Successfully posted call: ", "W" + world + " T" + tier + " " + location + (String)(StarCallingAssistPlugin.this.miners == -1 || tier == 0 ? "" : " " + StarCallingAssistPlugin.this.miners + " Miners")));
                    } else {
                        StarCallingAssistPlugin.this.clientThread.invokeLater(() -> StarCallingAssistPlugin.this.logHighlightedToChat("Issue posting call to " + StarCallingAssistPlugin.this.starConfig.getEndpoint() + ": ", res.message()));
                    }
                    res.close();
                }
            });
        }
        catch (IllegalArgumentException iae) {
            this.clientThread.invokeLater(() -> this.logHighlightedToChat("Issue posting call to " + this.starConfig.getEndpoint() + ": ", "Invalid endpoint"));
        }
    }

    private void logHighlightedToChat(String normal, String highlight) {
        if (this.starConfig.chatMessages()) {
            String chatMessage = new ChatMessageBuilder().append(ChatColorType.NORMAL).append(normal).append(ChatColorType.HIGHLIGHT).append(highlight).build();
            this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(chatMessage).build());
        }
    }

    private void logToChat(String message) {
        if (this.starConfig.chatMessages()) {
            this.client.addChatMessage(ChatMessageType.CONSOLE, "", message, "");
        }
    }

    private void setCallButtonLocation() {
        if (this.client.isResized()) {
            this.callButton.setOriginalX(StarCallingAssistPlugin.BUTTON_RESIZEABLE_LOCATION.x);
            this.callButton.setOriginalY(StarCallingAssistPlugin.BUTTON_RESIZEABLE_LOCATION.y);
        } else {
            this.callButton.setOriginalX(StarCallingAssistPlugin.BUTTON_FIXED_LOCATION.x);
            this.callButton.setOriginalY(StarCallingAssistPlugin.BUTTON_FIXED_LOCATION.y);
        }
    }
}

