/*
 * Decompiled with CFR 0.152.
 */
package com.starcallingassist;

import com.starcallingassist.sidepanel.constants.TotalLevelType;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.Range;
import net.runelite.client.config.Units;

@ConfigGroup(value="starcallingassistplugin")
public interface StarCallingAssistConfig
extends Config {
    @ConfigSection(name="Caller Settings", description="Settings to configure the caller part of the plugin.", position=2)
    public static final String callerSection = "Caller Settings";
    @ConfigSection(name="Star Panel Settings", description="Settings to configure side panel displaying active stars.", position=8)
    public static final String panelSection = "Star Panel Settings";
    @ConfigSection(name="Region Toggles", description="Toggle regions to be displayed in the side-panel", position=18)
    public static final String regionSection = "Region Toggles";

    @ConfigItem(keyName="endpoint", position=0, name="Endpoint", description="Endpoint to post calls to and fetch calls from")
    default public String getEndpoint() {
        return "https://public.starminers.site/crowdsource";
    }

    @ConfigItem(keyName="authorization", position=1, name="Authorization", description="Used to set the http authorization header.")
    default public String getAuthorization() {
        return "";
    }

    @ConfigItem(keyName="includeIgn", name="Send in-game name", description="Includes your in-game name with your calls. This is required if you want the stars you find to count towards your called stars total.", position=3, section="Caller Settings")
    default public boolean includeIgn() {
        return false;
    }

    @ConfigItem(keyName="autoCall", name="Auto call stars", description="Automatically call stars as they appear or fully depletes", position=4, section="Caller Settings")
    default public boolean autoCall() {
        return true;
    }

    @ConfigItem(keyName="updateStar", name="Auto update stars", description="Posts a new call when the tier of a star changes (Auto call must be enabled)", position=5, section="Caller Settings")
    default public boolean updateStar() {
        return true;
    }

    @ConfigItem(keyName="chatMessages", name="Display chat messages", description="Display chat messages on successful calls, unsuccessful calls and other errors", position=6, section="Caller Settings")
    default public boolean chatMessages() {
        return true;
    }

    @ConfigItem(keyName="callHorn", name="Call Button", description="Enables a button which can be used to call a star.", position=7, section="Caller Settings")
    default public boolean callHorn() {
        return false;
    }

    @ConfigItem(keyName="estimateTier", name="Estimate Tier", description="Estimates the current tier of stars in the list.", position=9, section="Star Panel Settings")
    default public boolean estimateTier() {
        return true;
    }

    @ConfigItem(keyName="minTier", name="Minimum Tier", description="Lowest tier of stars to be displayed in the side-panel.", position=10, section="Star Panel Settings")
    @Range(min=1, max=9)
    default public int minTier() {
        return 1;
    }

    @ConfigItem(keyName="maxTier", name="Maximum Tier", description="Highest tier of stars to be displayed in the side-panel.", position=11, section="Star Panel Settings")
    @Range(min=1, max=9)
    default public int maxTier() {
        return 9;
    }

    @ConfigItem(keyName="minDeadTime", name="Min. Dead Time", description="Hides stars that are estimated to be depleted in less than the specified amount of minutes", position=12, section="Star Panel Settings")
    @Range(min=-90, max=90)
    @Units(value=" mins")
    default public int minDeadTime() {
        return -5;
    }

    @ConfigItem(keyName="showF2P", name="Show F2P", description="Show or hide f2p worlds.", position=13, section="Star Panel Settings")
    default public boolean showF2P() {
        return true;
    }

    @ConfigItem(keyName="showMembers", name="Show Members", description="Show or hide members worlds.", position=14, section="Star Panel Settings")
    default public boolean showMembers() {
        return true;
    }

    @ConfigItem(keyName="showPvp", name="Show PVP", description="Show or hide PVP worlds.", position=15, section="Star Panel Settings")
    default public boolean showPvp() {
        return false;
    }

    @ConfigItem(keyName="showHighRisk", name="Show High-Risk", description="Show or hide high-risk worlds.", position=16, section="Star Panel Settings")
    default public boolean showHighRisk() {
        return true;
    }

    @ConfigItem(keyName="totalLevelType", name="Max total world", description="Hides worlds with a total level requirement higher than this.", position=17, section="Star Panel Settings")
    default public TotalLevelType totalLevelType() {
        return TotalLevelType.TOTAL_2200;
    }

    @ConfigItem(keyName="asgarnia", name="Asgarnia", description="Show or hide this region.", position=19, section="Region Toggles")
    default public boolean asgarnia() {
        return true;
    }

    @ConfigItem(keyName="karamja", name="Crandor/Karamja", description="Show or hide this region.", position=20, section="Region Toggles")
    default public boolean karamja() {
        return true;
    }

    @ConfigItem(keyName="feldip", name="Feldip Hills/Isle Of Souls", description="Show or hide this region.", position=21, section="Region Toggles")
    default public boolean feldip() {
        return true;
    }

    @ConfigItem(keyName="fossil", name="Fossil Island/Mos Le Harmless", description="Show or hide this region.", position=22, section="Region Toggles")
    default public boolean fossil() {
        return true;
    }

    @ConfigItem(keyName="fremmenik", name="Fremmenik/Lunar Isle", description="Show or hide this region.", position=23, section="Region Toggles")
    default public boolean fremmenik() {
        return true;
    }

    @ConfigItem(keyName="kourend", name="Kourend", description="Show or hide this region.", position=24, section="Region Toggles")
    default public boolean kourend() {
        return true;
    }

    @ConfigItem(keyName="kandarin", name="Kandarin", description="Show or hide this region.", position=25, section="Region Toggles")
    default public boolean kandarin() {
        return true;
    }

    @ConfigItem(keyName="kebos", name="Kebos Lowlands", description="Show or hide this region.", position=26, section="Region Toggles")
    default public boolean kebos() {
        return true;
    }

    @ConfigItem(keyName="desert", name="Desert", description="Show or hide this region.", position=27, section="Region Toggles")
    default public boolean desert() {
        return true;
    }

    @ConfigItem(keyName="misthalin", name="Misthalin", description="Show or hide this region.", position=28, section="Region Toggles")
    default public boolean misthalin() {
        return true;
    }

    @ConfigItem(keyName="morytania", name="Morytania", description="Show or hide this region.", position=29, section="Region Toggles")
    default public boolean morytania() {
        return true;
    }

    @ConfigItem(keyName="gnome", name="Piscatoris/Gnome Stronghold", description="Show or hide this region.", position=30, section="Region Toggles")
    default public boolean gnome() {
        return true;
    }

    @ConfigItem(keyName="tirannwn", name="Tirannwn", description="Show or hide this region.", position=31, section="Region Toggles")
    default public boolean tirannwn() {
        return true;
    }

    @ConfigItem(keyName="wilderness", name="Wilderness", description="Show or hide this region.", position=32, section="Region Toggles")
    default public boolean wilderness() {
        return true;
    }

    @ConfigItem(keyName="unknown", name="Unknown/Unscoped", description="Show or hide stars where the region is unscoped.", position=33, section="Region Toggles")
    default public boolean unknown() {
        return true;
    }
}

