/*
 * Decompiled with CFR 0.152.
 */
package com.starcallingassist;

import java.awt.Point;
import java.util.HashMap;
import java.util.Map;
import net.runelite.api.GameObject;
import net.runelite.api.coords.WorldPoint;

public class Star {
    private static Star currentStar = null;
    private static final int[] TIER_IDS = new int[]{41229, 41228, 41227, 41226, 41225, 41224, 41223, 41021, 41020};
    public final GameObject starObject;
    public final int tier;
    public final WorldPoint location;
    public final int world;
    private static final Map<Point, String> LOCATION_NAMES = new HashMap<Point, String>(){
        {
            this.put(new Point(2974, 3241), "Rimmington mine");
            this.put(new Point(2940, 3280), "Crafting guild");
            this.put(new Point(2906, 3355), "West Falador mine");
            this.put(new Point(3030, 3348), "East Falador bank");
            this.put(new Point(3018, 3443), "North Dwarven Mine entrance");
            this.put(new Point(2882, 3474), "Taverley house portal");
            this.put(new Point(2736, 3221), "Brimhaven northwest gold mine");
            this.put(new Point(2742, 3143), "Southwest of Brimhaven Poh");
            this.put(new Point(2845, 3037), "Nature Altar mine north of Shilo");
            this.put(new Point(2827, 2999), "Shilo Village gem mine");
            this.put(new Point(2835, 3296), "North Crandor");
            this.put(new Point(2822, 3238), "South Crandor");
            this.put(new Point(3296, 3298), "Al Kharid mine");
            this.put(new Point(3276, 3164), "Al Kharid bank");
            this.put(new Point(3351, 3281), "North of Al Kharid PvP Arena");
            this.put(new Point(3424, 3160), "Nw of Uzer (Eagle's Eyrie)");
            this.put(new Point(3434, 2889), "Nardah bank");
            this.put(new Point(3316, 2867), "Agility Pyramid mine");
            this.put(new Point(3171, 2910), "Desert Quarry mine");
            this.put(new Point(2567, 2858), "Corsair Cove bank");
            this.put(new Point(2483, 2886), "Corsair Resource Area");
            this.put(new Point(2468, 2842), "Myths' Guild");
            this.put(new Point(2571, 2964), "Feldip Hills (aks fairy ring)");
            this.put(new Point(2630, 2993), "Rantz cave");
            this.put(new Point(2200, 2792), "Soul Wars south mine");
            this.put(new Point(3818, 3801), "Fossil Island Volcanic Mine entrance");
            this.put(new Point(3774, 3814), "Fossil Island rune rocks");
            this.put(new Point(3686, 2969), "Mos Le'Harmless west bank");
            this.put(new Point(2727, 3683), "Keldagrim entrance mine");
            this.put(new Point(2683, 3699), "Rellekka mine");
            this.put(new Point(2393, 3814), "Jatizso mine entrance");
            this.put(new Point(2375, 3832), "Neitiznot south of rune rock");
            this.put(new Point(2528, 3887), "Miscellania mine (cip fairy ring)");
            this.put(new Point(2139, 3938), "Lunar Isle mine entrance");
            this.put(new Point(2602, 3086), "Yanille bank");
            this.put(new Point(2624, 3141), "Port Khazard mine");
            this.put(new Point(2608, 3233), "Ardougne Monastery");
            this.put(new Point(2705, 3333), "South of Legends' Guild");
            this.put(new Point(2804, 3434), "Catherby bank");
            this.put(new Point(2589, 3478), "Coal Trucks west of Seers'");
            this.put(new Point(1778, 3493), "Hosidius mine");
            this.put(new Point(1769, 3709), "Port Piscarilius mine in Kourend");
            this.put(new Point(1597, 3648), "Shayzien mine south of Kourend Castle");
            this.put(new Point(1534, 3747), "South Lovakengj bank");
            this.put(new Point(1437, 3840), "Lovakite mine");
            this.put(new Point(1760, 3853), "Arceuus dense essence mine");
            this.put(new Point(1322, 3816), "Mount Karuulm bank");
            this.put(new Point(1279, 3817), "Mount Karuulm mine");
            this.put(new Point(1210, 3651), "Kebos Swamp mine");
            this.put(new Point(1258, 3564), "Chambers of Xeric bank");
            this.put(new Point(3258, 3408), "Varrock east bank");
            this.put(new Point(3290, 3353), "Southeast Varrock mine");
            this.put(new Point(3175, 3362), "Champions' Guild mine");
            this.put(new Point(3094, 3235), "Draynor Village");
            this.put(new Point(3153, 3150), "West Lumbridge Swamp mine");
            this.put(new Point(3230, 3155), "East Lumbridge Swamp mine");
            this.put(new Point(3635, 3340), "Darkmeyer ess. mine entrance");
            this.put(new Point(3650, 3214), "Theatre of Blood bank");
            this.put(new Point(3505, 3485), "Canifis bank");
            this.put(new Point(3500, 3219), "Burgh de Rott bank");
            this.put(new Point(3451, 3233), "Abandoned Mine west of Burgh");
            this.put(new Point(2444, 3490), "West of Grand Tree");
            this.put(new Point(2448, 3436), "Gnome Stronghold spirit tree");
            this.put(new Point(2341, 3635), "Piscatoris (akq fairy ring)");
            this.put(new Point(2329, 3163), "Lletya");
            this.put(new Point(2269, 3158), "Isafdar runite rocks");
            this.put(new Point(3274, 6055), "Prifddinas Zalcano entrance");
            this.put(new Point(2318, 3269), "Arandar mine north of Lletya");
            this.put(new Point(2173, 3409), "Mynydd nw of Prifddinas");
            this.put(new Point(3108, 3569), "Mage of Zamorak mine (lvl 7 Wildy)");
            this.put(new Point(3018, 3593), "Skeleton mine (lvl 10 Wildy)");
            this.put(new Point(3093, 3756), "Hobgoblin mine (lvl 30 Wildy)");
            this.put(new Point(3057, 3887), "Lava maze runite mine (lvl 46 Wildy)");
            this.put(new Point(3049, 3940), "Pirates' Hideout (lvl 53 Wildy)");
            this.put(new Point(3091, 3962), "Mage Arena bank (lvl 56 Wildy)");
            this.put(new Point(3188, 3932), "Wilderness Resource Area");
        }
    };

    Star(GameObject starObject, int tier, WorldPoint location, int world) {
        this.starObject = starObject;
        this.tier = tier;
        this.location = location;
        this.world = world;
    }

    public static Star getStar() {
        return currentStar;
    }

    public static void removeStar() {
        currentStar = null;
    }

    public static void setStar(GameObject star, int tier, int world) {
        currentStar = new Star(star, tier, star.getWorldLocation(), world);
    }

    public static int getTier(int id) {
        for (int i = 0; i < TIER_IDS.length; ++i) {
            if (id != TIER_IDS[i]) continue;
            return i + 1;
        }
        return -1;
    }

    public static String getLocationName(WorldPoint location) {
        String locationName = LOCATION_NAMES.get(new Point(location.getX(), location.getY()));
        if (locationName != null) {
            return locationName;
        }
        return "unknown";
    }

    public static String getLocationName(int x, int y) {
        String locationName = LOCATION_NAMES.get(new Point(x, y));
        if (locationName != null) {
            return locationName;
        }
        return "unknown";
    }
}

