/*
 * Decompiled with CFR 0.152.
 */
package com.starcallingassist;

import com.starcallingassist.StarCallingAssistConfig;
import javax.inject.Inject;
import net.runelite.http.api.RuneLiteAPI;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

public class CallSender {
    @Inject
    private StarCallingAssistConfig starConfig;
    @Inject
    private OkHttpClient okHttpClient;

    public void sendCall(String username, int world, int tier, String location, int miners, Callback callback) throws IllegalArgumentException {
        Request request = new Request.Builder().url(this.starConfig.getEndpoint()).addHeader("authorization", this.starConfig.getAuthorization()).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)RuneLiteAPI.GSON.toJson((Object)new CallData(this.starConfig.includeIgn() ? username : "", world, tier, location, miners)))).build();
        this.okHttpClient.newCall(request).enqueue(callback);
    }

    private class CallData {
        private final int world;
        private final int tier;
        private final int miners;
        private final String location;
        private final String sender;

        public CallData(String sender, int world, int tier, String location, int miners) {
            this.sender = sender;
            this.world = world;
            this.tier = tier;
            this.location = location;
            this.miners = miners;
        }
    }
}

