/*
 * Decompiled with CFR 0.152.
 */
package com.EvilCreatures;

import com.EvilCreatures.ModelPair;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Animation;
import net.runelite.api.Client;
import net.runelite.api.Model;
import net.runelite.api.NPC;
import net.runelite.api.Renderable;
import net.runelite.api.RuneLiteObject;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.callback.Hooks;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Evil Creatures")
public class EvilCreatureModelSwap
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(EvilCreatureModelSwap.class);
    private static final int[] gnomeIDs = new int[]{6094, 6095, 6096, 6081, 6082, 6086, 6087};
    private static final int evilCreatureHeadModelID = 16957;
    private static final int evilCreatureBodyModelID = 16955;
    private static final int evilCreatureStandingCode = 4472;
    private static final int evilCreatureMovingCode = 4473;
    private static final int gnomeMovingCode = 189;
    private static final int gnomeStandingCode = 195;
    private Model evilCreatureHeadModel;
    private Model evilCreatureBodyModel;
    private Animation evilCreatureStandingAnimation;
    private Animation evilCreatureMovingAnimation;
    private ArrayList<ModelPair> currentlyTrackedGnomes;
    private boolean initialized;
    private final Hooks.RenderableDrawListener drawListener = this::shouldDraw;
    @Inject
    private Hooks hooks;
    @Inject
    private ClientThread clientThread;
    @Inject
    private Client client;

    protected void startUp() throws Exception {
        this.currentlyTrackedGnomes = new ArrayList();
        this.hooks.registerRenderableDrawListener(this.drawListener);
        this.initialized = false;
        this.clientThread.invoke(() -> {
            this.evilCreatureHeadModel = this.client.loadModel(16957);
            this.evilCreatureBodyModel = this.client.loadModel(16955);
            this.evilCreatureMovingAnimation = this.client.loadAnimation(4473);
            this.evilCreatureStandingAnimation = this.client.loadAnimation(4472);
            this.initialized = this.evilCreatureHeadModel != null && this.evilCreatureBodyModel != null;
        });
    }

    protected void shutDown() throws Exception {
        this.hooks.unregisterRenderableDrawListener(this.drawListener);
        this.clientThread.invoke(() -> {
            for (ModelPair currentPair : this.currentlyTrackedGnomes) {
                currentPair.getHead().setActive(false);
                currentPair.getBody().setActive(false);
            }
            this.currentlyTrackedGnomes.clear();
        });
        this.initialized = false;
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (this.initialized) {
            this.currentlyTrackedGnomes.clear();
            List allNPCs = this.client.getNpcs();
            for (NPC possibleGnome : allNPCs) {
                if (!this.isGnome(possibleGnome)) continue;
                this.addPair(possibleGnome);
            }
        }
    }

    @Subscribe
    public void onClientTick(ClientTick tick) {
        if (!this.initialized) {
            return;
        }
        for (ModelPair currentPair : this.currentlyTrackedGnomes) {
            RuneLiteObject currentCreatureHead = currentPair.getHead();
            RuneLiteObject currentCreatureBody = currentPair.getBody();
            NPC currentGnome = currentPair.getNPC();
            LocalPoint currentLocation = currentGnome.getLocalLocation();
            int currentWorld = currentGnome.getWorldLocation().getPlane();
            int currentOrientation = currentGnome.getOrientation();
            currentCreatureHead.setModel(this.evilCreatureHeadModel);
            currentCreatureHead.setLocation(currentLocation, currentWorld);
            currentCreatureHead.setOrientation(currentOrientation);
            currentCreatureHead.setActive(true);
            currentCreatureBody.setModel(this.evilCreatureBodyModel);
            currentCreatureBody.setLocation(currentLocation, currentWorld);
            currentCreatureBody.setOrientation(currentOrientation);
            currentCreatureBody.setActive(true);
            if (currentGnome.getPoseAnimation() == 195 && currentCreatureHead.getAnimation() != this.evilCreatureStandingAnimation) {
                currentCreatureHead.setAnimation(this.evilCreatureStandingAnimation);
                currentCreatureHead.setShouldLoop(true);
                currentCreatureBody.setAnimation(this.evilCreatureStandingAnimation);
                currentCreatureBody.setShouldLoop(true);
                continue;
            }
            if (currentGnome.getPoseAnimation() != 189 || currentCreatureHead.getAnimation() == this.evilCreatureMovingAnimation) continue;
            currentCreatureHead.setAnimation(this.evilCreatureMovingAnimation);
            currentCreatureHead.setShouldLoop(true);
            currentCreatureBody.setAnimation(this.evilCreatureMovingAnimation);
            currentCreatureBody.setShouldLoop(true);
        }
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned inNPCSpawned) {
        NPC newNPC = inNPCSpawned.getNpc();
        if (this.isNewGnome(newNPC)) {
            this.addPair(newNPC);
        }
    }

    private void addPair(NPC inNPC) {
        this.currentlyTrackedGnomes.add(new ModelPair(inNPC, this.client.createRuneLiteObject(), this.client.createRuneLiteObject()));
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned inNPCDespawned) {
        NPC goneNPC = inNPCDespawned.getNpc();
        if (this.isOnList(goneNPC)) {
            for (ModelPair gnomeTest : this.currentlyTrackedGnomes) {
                if (gnomeTest.getNPC() != goneNPC) continue;
                this.removeCreature(gnomeTest);
                return;
            }
        }
    }

    private void removeCreature(ModelPair inModelPair) {
        inModelPair.getHead().setActive(false);
        inModelPair.getBody().setActive(false);
        this.currentlyTrackedGnomes.remove(inModelPair);
    }

    private boolean isNewGnome(NPC inNPC) {
        return this.isGnome(inNPC) && !this.isOnList(inNPC);
    }

    private boolean isOnList(NPC inNPC) {
        for (ModelPair gnomeTest : this.currentlyTrackedGnomes) {
            if (gnomeTest.getNPC() != inNPC) continue;
            return true;
        }
        return false;
    }

    private boolean isGnome(NPC inNPC) {
        for (int gnomeID : gnomeIDs) {
            if (gnomeID != inNPC.getId()) continue;
            return true;
        }
        return false;
    }

    public boolean shouldDraw(Renderable inRenderable, boolean isUIElement) {
        if (inRenderable instanceof NPC) {
            NPC currentRenderable = (NPC)inRenderable;
            return !this.isGnome(currentRenderable);
        }
        return true;
    }
}

