/*
 * Decompiled with CFR 0.152.
 */
package com.xpdrops.predictedhit.npcswithscalingbonus.cox;

import com.xpdrops.predictedhit.npcswithscalingbonus.cox.AbyssalPortal;
import com.xpdrops.predictedhit.npcswithscalingbonus.cox.CoXNPC;
import com.xpdrops.predictedhit.npcswithscalingbonus.cox.GlowingCrystal;
import com.xpdrops.predictedhit.npcswithscalingbonus.cox.GreatOlm;
import com.xpdrops.predictedhit.npcswithscalingbonus.cox.Scavenger;
import com.xpdrops.predictedhit.npcswithscalingbonus.cox.Tekton;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

public enum CoXNPCs {
    TEKTON(CoXNPCStats.TEKTON.getCoxnpc(), 7541, 7542),
    TEKTON_ENRAGED(CoXNPCStats.TEKTON_ENRAGED.getCoxnpc(), 7543, 7544),
    ICE_DEMON(CoXNPCStats.ICE_DEMON.getCoxnpc(), 7584, 7585),
    LIZARDMAN(CoXNPCStats.LIZARDMAN.getCoxnpc(), 7573, 7574),
    MELEE_VANG(CoXNPCStats.MELEE_VANG.getCoxnpc(), 7527),
    MAGE_VANG(CoXNPCStats.MAGE_VANG.getCoxnpc(), 7529),
    RANGE_VANG(CoXNPCStats.RANGE_VANG.getCoxnpc(), 7528),
    VESPULA(CoXNPCStats.VESPULA.getCoxnpc(), 7530, 7531, 7532),
    ABYSSAL_PORTAL(CoXNPCStats.ABYSSAL_PORTAL.getCoxnpc(), 7533),
    GUARDIAN(CoXNPCStats.GUARDIAN.getCoxnpc(), 7569, 7570, 7571, 7572),
    VASA(CoXNPCStats.VASA.getCoxnpc(), 7566, 7567),
    GLOWING_CRYSTAL(CoXNPCStats.GLOWING_CRYSTAL.getCoxnpc(), 7568),
    MYSTIC(CoXNPCStats.MYSTIC.getCoxnpc(), 7604, 7605, 7606),
    SMALL_CROC(CoXNPCStats.SMALL_CROC.getCoxnpc(), 7562),
    BIG_CROC(CoXNPCStats.BIG_CROC.getCoxnpc(), 7563),
    ROPE_RANGER(CoXNPCStats.ROPE_RANGER.getCoxnpc(), 7559),
    ROPE_MAGER(CoXNPCStats.ROPE_MAGER.getCoxnpc(), 7560),
    GREAT_OLM(CoXNPCStats.GREAT_OLM.getCoxnpc(), 7551, 7554),
    GREAT_OLM_MAGE_HAND(CoXNPCStats.GREAT_OLM_MAGE_HAND.getCoxnpc(), 7552, 7555),
    GREAT_OLM_MELEE_HAND(CoXNPCStats.GREAT_OLM_MELEE_HAND.getCoxnpc(), 7550, 7553),
    SCAVENGER(CoXNPCStats.SCAVENGER.getCoxnpc(), 7548, 7549);

    private final HashSet<Integer> ids;
    private final CoXNPC npcWithScalingBonus;
    private static final HashMap<Integer, CoXNPC> COXNPC_MAPPING;

    private CoXNPCs(CoXNPC coxnpc, int ... ids) {
        this.npcWithScalingBonus = coxnpc;
        this.ids = new HashSet();
        Arrays.stream(ids).forEach(this.ids::add);
    }

    public static boolean isCOXNPC(int id) {
        return COXNPC_MAPPING.containsKey(id);
    }

    public static double getModifier(int id, int partySize, int raidType) {
        if (CoXNPCs.isCOXNPC(id)) {
            return COXNPC_MAPPING.get(id).calculateModifier(raidType, partySize);
        }
        return 1.0;
    }

    static {
        COXNPC_MAPPING = new HashMap();
        for (CoXNPCs value : CoXNPCs.values()) {
            for (Integer id : value.ids) {
                COXNPC_MAPPING.put(id, value.npcWithScalingBonus);
            }
        }
    }

    static enum CoXNPCStats {
        TEKTON(new Tekton(300, 390, 390, 205, 1, 205, 64, 20, 155, 165, 105, 0, 0)),
        TEKTON_ENRAGED(new Tekton(300, 390, 390, 205, 1, 205, 64, 30, 280, 290, 180, 0, 0)),
        ICE_DEMON(new CoXNPC(140, 1, 1, 390, 390, 160, 0, 0, 70, 70, 110, 60, 140)),
        LIZARDMAN(new CoXNPC(190, 130, 130, 130, 130, 210, 58, 52, 102, 160, 150, 160, 0)),
        MAGE_VANG(new CoXNPC(180, 150, 150, 150, 150, 160, 0, 0, 315, 340, 400, 110, 50)),
        MELEE_VANG(new CoXNPC(180, 150, 150, 150, 150, 160, 20, 10, 150, 150, 150, 20, 400)),
        RANGE_VANG(new CoXNPC(180, 150, 150, 150, 150, 160, 0, 0, 55, 60, 100, 400, 300)),
        VESPULA(new CoXNPC(200, 150, 150, 88, 150, 88, 0, 0, 0, 0, 0, 70, 60)),
        ABYSSAL_PORTAL(new AbyssalPortal(250, 1, 1, 176, 1, 176, 0, 0, 0, 0, 0, 60, 140)),
        GUARDIAN(new CoXNPC(250, 140, 140, 1, 1, 100, 0, 20, 80, 180, -10, 0, 0)),
        VASA(new CoXNPC(300, 1, 1, 230, 230, 175, 0, 0, 170, 190, 50, 400, 60)),
        GLOWING_CRYSTAL(new GlowingCrystal(120, 1, 1, 100, 1, 100, 0, 0, -5, 180, 180, 0, 0)),
        MYSTIC(new CoXNPC(160, 140, 140, 140, 1, 187, 85, 50, 155, 155, 115, 140, 115)),
        SMALL_CROC(new CoXNPC(250, 150, 150, 1, 150, 138, 71, 64, -5, 72, 50, 60, 0)),
        BIG_CROC(new CoXNPC(250, 250, 250, 250, 250, 220, 88, 74, -5, 82, 60, 75, 0)),
        ROPE_RANGER(new CoXNPC(120, 1, 1, 155, 210, 155, 0, 0, 0, 0, 0, 0, 0)),
        ROPE_MAGER(new CoXNPC(120, 1, 1, 210, 1, 155, 0, 0, 0, 0, 0, 0, 0)),
        GREAT_OLM(new GreatOlm(800, 250, 250, 250, 250, 150, 0, 0, 200, 200, 200, 200, 50)),
        GREAT_OLM_MAGE_HAND(new GreatOlm(600, 250, 250, 175, 250, 175, 0, 0, 50, 50, 50, 50, 50)),
        GREAT_OLM_MELEE_HAND(new GreatOlm(600, 250, 250, 87, 250, 175, 0, 0, 200, 200, 200, 50, 200)),
        SCAVENGER(new Scavenger(30, 120, 120, 1, 1, 45, 0, 0, 0, 0, 0, 0, 0));

        private final CoXNPC coxnpc;

        private CoXNPCStats(CoXNPC coxnpc) {
            this.coxnpc = coxnpc;
        }

        public CoXNPC getCoxnpc() {
            return this.coxnpc;
        }
    }
}

