/*
 * Decompiled with CFR 0.152.
 */
package com.xpdrops.predictedhit.npcswithscalingbonus.cox;

import com.xpdrops.predictedhit.npcswithscalingbonus.NPCStats;

public class CoXNPC
extends NPCStats {
    public CoXNPC(int hp, int att, int str, int mage, int range, int def, int offensiveAtt, int offensiveStr, int defensiveStab, int defensiveSlash, int defensiveCrush, int defensiveMage, int defensiveRange) {
        super(hp, att, str, def, mage, range, offensiveAtt, offensiveStr, defensiveStab, defensiveSlash, defensiveCrush, defensiveMage, defensiveRange);
    }

    private boolean isCM(int raidType) {
        return raidType > 0;
    }

    protected double cmHpMultiplier() {
        return 1.5;
    }

    protected double cmOffensiveMultiplier() {
        return 1.5;
    }

    protected double cmMagicMultiplier() {
        return 1.5;
    }

    protected double cmDefenseMultiplier() {
        return 1.5;
    }

    protected double calculateHpScaling(int partySize) {
        return 1.0 + Math.floor((double)partySize / 2.0);
    }

    protected double calculateOffensiveScaling(int partySize) {
        return (Math.floor(Math.sqrt((double)partySize - 1.0)) * 7.0 + ((double)partySize - 1.0) + 100.0) / 100.0;
    }

    protected double calculateDefensiveScaling(int partySize) {
        return (Math.floor(Math.sqrt((double)partySize - 1.0)) + Math.floor((double)(partySize - 1) * 7.0 / 10.0) + 100.0) / 100.0;
    }

    protected double calculateModifier(int raidType, int partySize) {
        double hpScaling = this.calculateHpScaling(partySize);
        double offensiveScaling = this.calculateOffensiveScaling(partySize);
        double defensiveScaling = this.calculateDefensiveScaling(partySize);
        double cmOffensiveMultiplier = this.isCM(raidType) ? this.cmOffensiveMultiplier() : 1.0;
        double cmDefenseMultiplier = this.isCM(raidType) ? this.cmDefenseMultiplier() : 1.0;
        double cmMagicMultiplier = this.isCM(raidType) ? this.cmMagicMultiplier() : 1.0;
        NPCStats scaledStats = new NPCStats((int)(hpScaling * (double)this.getHp() * this.cmHpMultiplier()), (int)(offensiveScaling * (double)this.getAtt() * cmOffensiveMultiplier), (int)(offensiveScaling * (double)this.getStr() * cmOffensiveMultiplier), (int)(defensiveScaling * (double)this.getDef() * cmDefenseMultiplier), (int)(offensiveScaling * (double)this.getMage() * cmMagicMultiplier), (int)(offensiveScaling * (double)this.getRange() * cmOffensiveMultiplier), this.getOffensiveAtt(), this.getOffensiveStr(), this.getDefensiveStab(), this.getDefensiveSlash(), this.getDefensiveCrush(), this.getDefensiveMage(), this.getDefensiveRange());
        return CoXNPC.modifierFromStats(scaledStats);
    }
}

