/*
 * Decompiled with CFR 0.152.
 */
package com.xpdrops.predictedhit.npcswithscalingbonus;

public class NPCStats {
    private int hp;
    private int att;
    private int str;
    private int def;
    private int mage;
    private int range;
    private int offensiveAtt;
    private int offensiveStr;
    private int defensiveStab;
    private int defensiveSlash;
    private int defensiveCrush;
    private int defensiveMage;
    private int defensiveRange;
    private static final int MAX_HP_FOR_MULTIPLIER = 2000;

    public NPCStats() {
    }

    protected static double modifierFromStats(NPCStats npcStats) {
        int hp = Math.min(npcStats.hp, 2000);
        double averageLevel = Math.floor((double)(hp + npcStats.getAtt() + npcStats.getStr() + npcStats.getDef()) / 4.0);
        double averageDefBonus = Math.floor((double)(npcStats.getDefensiveStab() + npcStats.getDefensiveSlash() + npcStats.getDefensiveCrush()) / 3.0);
        return 1.0 + 0.025 * Math.floor(averageLevel * (averageDefBonus + (double)npcStats.getOffensiveStr() + (double)npcStats.getOffensiveAtt()) / 5120.0);
    }

    public NPCStats(int hp, int att, int str, int def, int mage, int range, int offensiveAtt, int offensiveStr, int defensiveStab, int defensiveSlash, int defensiveCrush, int defensiveMage, int defensiveRange) {
        this.hp = hp;
        this.att = att;
        this.str = str;
        this.def = def;
        this.mage = mage;
        this.range = range;
        this.offensiveAtt = offensiveAtt;
        this.offensiveStr = offensiveStr;
        this.defensiveStab = defensiveStab;
        this.defensiveSlash = defensiveSlash;
        this.defensiveCrush = defensiveCrush;
        this.defensiveMage = defensiveMage;
        this.defensiveRange = defensiveRange;
    }

    public int getHp() {
        return this.hp;
    }

    public int getAtt() {
        return this.att;
    }

    public int getStr() {
        return this.str;
    }

    public int getDef() {
        return this.def;
    }

    public int getMage() {
        return this.mage;
    }

    public int getRange() {
        return this.range;
    }

    public int getOffensiveAtt() {
        return this.offensiveAtt;
    }

    public int getOffensiveStr() {
        return this.offensiveStr;
    }

    public int getDefensiveStab() {
        return this.defensiveStab;
    }

    public int getDefensiveSlash() {
        return this.defensiveSlash;
    }

    public int getDefensiveCrush() {
        return this.defensiveCrush;
    }

    public int getDefensiveMage() {
        return this.defensiveMage;
    }

    public int getDefensiveRange() {
        return this.defensiveRange;
    }
}

