/*
 * Decompiled with CFR 0.152.
 */
package com.xpdrops.overlay;

import com.xpdrops.Skill;
import com.xpdrops.config.XpDropsConfig;
import com.xpdrops.overlay.XpDropFontHandler;
import com.xpdrops.overlay.XpDropOverlayManager;
import com.xpdrops.overlay.XpDropOverlayUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.plugins.xptracker.XpTrackerService;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.util.Text;

public class XpTrackerOverlay
extends Overlay {
    private final XpDropsConfig config;
    private final XpDropOverlayManager xpDropOverlayManager;
    private final XpDropFontHandler xpDropFontHandler = new XpDropFontHandler();
    private static final int PROGRESS_BAR_HEIGHT = 6;
    @Inject
    private Client client;
    private final XpTrackerService xpTrackerService;

    @Inject
    private XpTrackerOverlay(XpDropsConfig config, XpDropOverlayManager xpDropOverlayManager, XpTrackerService xpTrackerService) {
        this.config = config;
        this.xpDropOverlayManager = xpDropOverlayManager;
        this.xpTrackerService = xpTrackerService;
        this.setLayer(OverlayLayer.UNDER_WIDGETS);
        this.setPosition(OverlayPosition.TOP_RIGHT);
        this.setPriority(config.xpTrackerOverlayPriority());
    }

    public Dimension render(Graphics2D graphics) {
        Dimension dimension = null;
        if (this.config.useXpTracker()) {
            this.xpDropFontHandler.updateFont(this.config.xpTrackerFontName(), this.config.xpTrackerFontSize(), this.config.xpTrackerFontStyle());
            XpDropOverlayUtilities.setGraphicsProperties(graphics);
            this.xpDropFontHandler.handleFont(graphics);
            Skill currentSkill = this.xpDropOverlayManager.getLastSkill();
            long xp = this.getSkillExperience(currentSkill);
            int icon = this.getSkillIconIndex(currentSkill);
            int width = graphics.getFontMetrics().stringWidth("###,###,###");
            int height = graphics.getFontMetrics().getHeight();
            if (this.xpDropOverlayManager.isShouldDraw()) {
                Dimension trackerDimensions = this.drawXpTracker(graphics, icon, xp);
                width = (int)trackerDimensions.getWidth();
                if (this.config.showXpTrackerProgressBar() && !Skill.OVERALL.equals((Object)currentSkill)) {
                    int startGoalXp = this.xpTrackerService.getStartGoalXp(currentSkill.toSkill());
                    int endGoalXp = this.xpTrackerService.getEndGoalXp(currentSkill.toSkill());
                    int barHeight = this.drawProgressBar(graphics, 0, (int)trackerDimensions.getHeight() + 1, width, startGoalXp, endGoalXp, xp);
                    height = (int)(trackerDimensions.getHeight() + (double)barHeight);
                }
            }
            dimension = new Dimension(width, height);
        }
        return dimension;
    }

    private long getSkillExperience(Skill skill) {
        long xp = Skill.OVERALL.equals((Object)skill) ? this.client.getOverallExperience() : (long)this.client.getSkillExperience(skill.toSkill());
        return xp;
    }

    private int getSkillIconIndex(Skill skill) {
        return skill.ordinal();
    }

    private int getAlpha() {
        int alpha = 255;
        if (this.config.xpTrackerClientTicksToLinger() != 0) {
            long deltaTime = System.currentTimeMillis() - this.xpDropOverlayManager.getLastSkillSetMillis();
            long deltaClientTicks = deltaTime / 20L;
            if (this.config.xpTrackerFadeOut()) {
                int delta = Math.min(33, (int)(0.33f * (float)this.config.xpTrackerClientTicksToLinger()));
                int threshold = this.config.xpTrackerClientTicksToLinger() - delta;
                int point = (int)(deltaClientTicks - (long)threshold);
                float fade = Math.max(0.0f, Math.min(1.0f, (float)point / (float)delta));
                alpha = (int)Math.max(0.0f, 255.0f - fade * 255.0f);
            } else if (deltaClientTicks > (long)this.config.xpTrackerClientTicksToLinger()) {
                alpha = 0;
            }
        }
        return alpha;
    }

    private Dimension drawXpTracker(Graphics2D graphics, int icon, long experience) {
        String xpTrackerColor = XpDropOverlayUtilities.RGBToHex(this.config.xpTrackerColor().getRGB());
        String text = XpDropOverlayManager.XP_FORMATTER.format(experience);
        int textY = graphics.getFontMetrics().getMaxAscent();
        int textWidth = graphics.getFontMetrics().stringWidth(Text.removeTags((String)text));
        int monospacedTextWidth = XpDropOverlayManager.monospacedWidth(graphics, Text.removeTags((String)text));
        int imageY = textY - graphics.getFontMetrics().getMaxAscent();
        int alpha = this.getAlpha();
        Dimension iconDimensions = this.drawIcon(graphics, icon, 0, imageY, alpha);
        int imageWidth = (int)(iconDimensions.getWidth() + 5.0);
        XpDropOverlayUtilities.drawText(graphics, XpDropOverlayUtilities.wrapWithTags(xpTrackerColor) + text, imageWidth + monospacedTextWidth - textWidth, textY, alpha, this.config.xpTrackerBackground());
        return new Dimension(monospacedTextWidth + imageWidth, (int)Math.max((double)graphics.getFontMetrics().getHeight(), iconDimensions.getHeight()));
    }

    private int drawProgressBar(Graphics2D graphics, int x, int y, int width, long start, long end, long _current) {
        if (start < 0L || end < 0L || start == end) {
            return 0;
        }
        long total = end - start;
        double ratio = 1.0;
        long current = Math.max(0L, _current - start);
        if (total > 0L) {
            ratio = (double)current / (double)total;
        }
        int alpha = this.getAlpha();
        int progressBarWidth = (int)(ratio * (double)(width - 4));
        int barHeight = 6;
        Color borderColor = new Color(this.config.xpTrackerBorderColor().getRed(), this.config.xpTrackerBorderColor().getGreen(), this.config.xpTrackerBorderColor().getBlue(), alpha);
        graphics.setColor(borderColor);
        graphics.fillRect(x, y, width, barHeight + 2);
        Color blackBackgroundColor = new Color(0, 0, 0, alpha);
        graphics.setColor(blackBackgroundColor);
        graphics.fillRect(x + 1, y + 1, width - 2, barHeight);
        double rMod = 130.0 * ratio;
        double gMod = 255.0 * ratio;
        Color c = new Color((int)(255.0 - rMod), (int)(0.0 + gMod), 0, alpha);
        graphics.setColor(c);
        graphics.fillRect(x + 2, y + 2, progressBarWidth, barHeight - 2);
        return 6;
    }

    private Dimension drawIcon(Graphics2D graphics, int icon, int x, int y, float alpha) {
        BufferedImage image;
        int iconSize = graphics.getFontMetrics().getHeight();
        if (this.config.xpTrackerIconSizeOverride() > 0) {
            iconSize = this.config.xpTrackerIconSizeOverride();
        }
        if (this.config.showIconsXpTracker() && (image = this.xpDropOverlayManager.getStatIcon(icon)) != null) {
            int _iconSize = Math.max(iconSize, 18);
            int iconWidth = image.getWidth() * _iconSize / 25;
            int iconHeight = image.getHeight() * _iconSize / 25;
            return XpDropOverlayUtilities.drawIcon(graphics, image, x, y, iconWidth, iconHeight, alpha / 255.0f, false);
        }
        return new Dimension(0, 0);
    }
}

