/*
 * Decompiled with CFR 0.152.
 */
package com.xpdrops.overlay;

import com.xpdrops.CustomizableXpDropsPlugin;
import com.xpdrops.Skill;
import com.xpdrops.XpDrop;
import com.xpdrops.XpDropStyle;
import com.xpdrops.attackstyles.AttackStyle;
import com.xpdrops.config.XpDropsConfig;
import com.xpdrops.config.XpTrackerSkills;
import com.xpdrops.overlay.XpDropInFlight;
import com.xpdrops.overlay.XpDropOverlay;
import com.xpdrops.overlay.XpDropOverlayUtilities;
import com.xpdrops.overlay.XpDropSceneOverlay;
import com.xpdrops.overlay.XpTrackerOverlay;
import com.xpdrops.predictedhit.Hit;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.SpritePixels;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class XpDropOverlayManager {
    private static final Logger log = LoggerFactory.getLogger(XpDropOverlayManager.class);
    private static final int RED_HIT_SPLAT_SPRITE_ID = 1359;
    private static final int FAKE_SKILL_ICON_ID = 423;
    private static final int[] SKILL_ICON_ORDINAL_ICONS = new int[]{197, 199, 198, 203, 200, 201, 202, 212, 214, 208, 211, 213, 207, 210, 209, 205, 204, 206, 216, 217, 215, 220, 221, 898};
    private static final HashMap<Integer, BufferedImage> ICON_CACHE = new HashMap();
    public static final String XP_FORMAT_PATTERN = "###,###,###";
    public static final float FRAMES_PER_SECOND = 50.0f;
    public static final float CONSTANT_FRAME_TIME = 20.0f;
    public static final DecimalFormat XP_FORMATTER = new DecimalFormat("###,###,###");
    public static final Font RUNESCAPE_BOLD_FONT = XpDropOverlayUtilities.initRuneScapeBold();
    public static final int[] SKILL_INDICES = new int[]{10, 0, 2, 4, 6, 1, 3, 5, 16, 15, 17, 12, 20, 14, 13, 7, 11, 8, 9, 18, 19, 22, 21};
    @Inject
    private XpDropOverlay xpDropOverlay;
    @Inject
    private XpDropSceneOverlay xpDropSceneOverlay;
    @Inject
    private XpTrackerOverlay xpTrackerOverlay;
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    private final ArrayList<XpDropInFlight> xpDropsInFlight = new ArrayList();
    private boolean shouldDraw = true;
    private long lastFrameTime = 0L;
    private Skill lastSkill = Skill.OVERALL;
    private long lastSkillSetMillis = 0L;
    private Overlay currentXpDropOverlay;
    private Overlay currentXpTrackerOverlay;
    private final CustomizableXpDropsPlugin plugin;
    private final XpDropsConfig config;
    private static MaxMonospaceDigit maxMonospaceDigit;

    @Inject
    private XpDropOverlayManager(CustomizableXpDropsPlugin plugin, XpDropsConfig xpDropsConfig) {
        this.plugin = plugin;
        this.config = xpDropsConfig;
    }

    @Nullable
    public BufferedImage getStatIcon(int index) {
        int icon = SKILL_ICON_ORDINAL_ICONS[index];
        return this.getIcon(icon, 0);
    }

    @Nullable
    public BufferedImage getFakeSkillIcon() {
        return this.getIcon(423, 11);
    }

    @Nullable
    public BufferedImage getHitsplatIcon() {
        return this.getIcon(1359, 0);
    }

    public void xpDropOverlayPriorityChanged() {
        this.xpDropOverlay.setPriority(this.config.xpDropOverlayPriority());
        this.overlayManager.saveOverlay((Overlay)this.xpDropOverlay);
    }

    public void xpTrackerOverlayPriorityChanged() {
        this.xpTrackerOverlay.setPriority(this.config.xpTrackerOverlayPriority());
        this.overlayManager.saveOverlay((Overlay)this.xpTrackerOverlay);
    }

    public void overlayTypeConfigChanged() {
        if (this.config.attachToPlayer() || this.config.attachToTarget()) {
            if (this.currentXpDropOverlay != this.xpDropSceneOverlay) {
                this.overlayManager.remove(this.currentXpDropOverlay);
                this.currentXpDropOverlay = this.xpDropSceneOverlay;
                this.overlayManager.add(this.currentXpDropOverlay);
            }
        } else if (this.currentXpDropOverlay != this.xpDropOverlay) {
            this.overlayManager.remove(this.currentXpDropOverlay);
            this.currentXpDropOverlay = this.xpDropOverlay;
            this.overlayManager.add(this.currentXpDropOverlay);
        }
    }

    public void startup() {
        this.clearIconCache();
        this.currentXpDropOverlay = this.config.attachToTarget() || this.config.attachToPlayer() ? this.xpDropSceneOverlay : this.xpDropOverlay;
        this.currentXpTrackerOverlay = this.xpTrackerOverlay;
        this.overlayManager.add(this.currentXpDropOverlay);
        this.overlayManager.add(this.currentXpTrackerOverlay);
    }

    public void shutdown() {
        this.overlayManager.remove(this.currentXpDropOverlay);
        this.overlayManager.remove(this.currentXpTrackerOverlay);
    }

    public void update() {
        Skill _lastSkill;
        if (this.lastFrameTime <= 0L) {
            this.lastFrameTime = System.currentTimeMillis() - 20L;
        }
        if ((_lastSkill = this.pollLastSkill()) != null) {
            this.lastSkillSetMillis = System.currentTimeMillis();
            this.lastSkill = _lastSkill;
        }
        this.updateDrops();
        this.pollDrops();
        this.lastFrameTime = System.currentTimeMillis();
    }

    private Skill pollLastSkill() {
        Skill currentSkill = null;
        if (this.config.xpTrackerSkill().equals((Object)XpTrackerSkills.MOST_RECENT)) {
            XpDrop topDrop = this.plugin.getQueue().peek();
            for (XpDrop xpDrop : this.plugin.getQueue()) {
                if (xpDrop == null || this.plugin.getFilteredSkills().contains(xpDrop.getSkill().toString().toLowerCase())) continue;
                return xpDrop.getSkill();
            }
        } else {
            currentSkill = this.config.xpTrackerSkill().getAssociatedSkill();
        }
        return currentSkill;
    }

    private void updateDrops() {
        this.xpDropsInFlight.removeIf(xpDropInFlight -> xpDropInFlight.getFrame() > (float)this.config.framesPerDrop());
        int xModifier = this.config.xDirection() == XpDropsConfig.HorizontalDirection.LEFT ? -1 : 1;
        int yModifier = this.config.yDirection() == XpDropsConfig.VerticalDirection.UP ? -1 : 1;
        float frameTime = System.currentTimeMillis() - this.lastFrameTime;
        float frameTimeModifier = frameTime / 20.0f;
        for (XpDropInFlight xpDropInFlight2 : this.xpDropsInFlight) {
            if (xpDropInFlight2.getFrame() >= 0.0f) {
                xpDropInFlight2.setXOffset(xpDropInFlight2.getXOffset() + (float)this.config.xPixelsPerSecond() / 50.0f * (float)xModifier * frameTimeModifier);
                xpDropInFlight2.setYOffset(xpDropInFlight2.getYOffset() + (float)this.config.yPixelsPerSecond() / 50.0f * (float)yModifier * frameTimeModifier);
            }
            xpDropInFlight2.setFrame(xpDropInFlight2.getFrame() + frameTimeModifier);
        }
        if (this.config.fadeOut()) {
            int threshold = (int)(0.66f * (float)this.config.framesPerDrop());
            int delta = this.config.framesPerDrop() - threshold;
            for (XpDropInFlight xpDropInFlight3 : this.xpDropsInFlight) {
                if (!(xpDropInFlight3.getFrame() > (float)threshold)) continue;
                int point = (int)xpDropInFlight3.getFrame() - threshold;
                float fade = Math.max(0.0f, Math.min(1.0f, (float)point / (float)delta));
                xpDropInFlight3.setAlpha(Math.max(0.0f, 255.0f - fade * 255.0f));
            }
        }
    }

    private void pollDrops() {
        float lastFrame = 0.0f;
        if (this.xpDropsInFlight.size() > 0) {
            XpDropInFlight xpDropInFlight = this.xpDropsInFlight.get(this.xpDropsInFlight.size() - 1);
            lastFrame = xpDropInFlight.getFrame();
            lastFrame -= (float)this.config.groupedDelay();
        }
        ArrayList<XpDropInFlight> drops = new ArrayList<XpDropInFlight>();
        int totalHit = 0;
        AttackStyle predictedHitAttackStyle = null;
        Actor target = null;
        Hit hit = this.plugin.getHitBuffer().poll();
        while (hit != null) {
            totalHit += hit.getHit();
            target = hit.getAttachedActor();
            predictedHitAttackStyle = hit.getStyle();
            hit = this.plugin.getHitBuffer().poll();
        }
        if (!this.config.showPredictedHit()) {
            totalHit = 0;
        }
        boolean filteredHit = false;
        XpDropStyle style = XpDropStyle.DEFAULT;
        for (XpDrop xpDrop : this.plugin.getQueue()) {
            filteredHit |= this.plugin.getFilteredSkillsPredictedHits().contains(xpDrop.getSkill().getName().toLowerCase());
            if (xpDrop.getStyle() == XpDropStyle.DEFAULT) continue;
            style = xpDrop.getStyle();
        }
        if (this.config.showPredictedHit() && this.config.neverGroupPredictedHit() && totalHit > 0 && !filteredHit) {
            Skill skill = null;
            if (predictedHitAttackStyle != null && predictedHitAttackStyle.getSkills().length > 0) {
                skill = predictedHitAttackStyle.getSkills()[0];
            }
            int icons = 0;
            if (skill != null && (this.config.predictedHitIcon() == XpDropsConfig.PredictedHitIconStyle.SKILL || this.config.predictedHitIcon() == XpDropsConfig.PredictedHitIconStyle.HITSPLAT_SKILL)) {
                icons |= 1 << CustomizableXpDropsPlugin.SKILL_PRIORITY[skill.ordinal()];
            }
            if (this.config.predictedHitIcon() == XpDropsConfig.PredictedHitIconStyle.HITSPLAT || this.config.predictedHitIcon() == XpDropsConfig.PredictedHitIconStyle.HITSPLAT_SKILL) {
                icons |= 0x1000000;
            }
            XpDropInFlight xpDropInFlight = new XpDropInFlight(icons, totalHit, style, 0.0f, 0.0f, 255.0f, 0.0f, 0, target, true);
            drops.add(xpDropInFlight);
        }
        if (this.config.isGrouped()) {
            int amount = 0;
            int icons = 0;
            XpDrop xpDrop = this.plugin.getQueue().poll();
            while (xpDrop != null) {
                if (!this.plugin.getFilteredSkills().contains(xpDrop.getSkill().getName().toLowerCase())) {
                    amount += xpDrop.getExperience();
                    if (this.config.showIcons()) {
                        icons |= 1 << CustomizableXpDropsPlugin.SKILL_PRIORITY[xpDrop.getSkill().ordinal()];
                    }
                    if (xpDrop.isFake() && this.config.showFakeIcon()) {
                        icons |= 0x800000;
                    }
                }
                xpDrop = this.plugin.getQueue().poll();
            }
            if (amount > 0) {
                int hit2 = this.config.neverGroupPredictedHit() || filteredHit ? 0 : totalHit;
                XpDropInFlight xpDropInFlight = new XpDropInFlight(icons, amount, style, 0.0f, 0.0f, 255.0f, 0.0f, hit2, target, false);
                drops.add(xpDropInFlight);
            }
        } else {
            XpDrop xpDrop = this.plugin.getQueue().poll();
            HashMap<Skill, XpDropInFlight> dropsInFlightMap = new HashMap<Skill, XpDropInFlight>();
            ArrayList<XpDropInFlight> dropsInFlight = new ArrayList<XpDropInFlight>();
            while (xpDrop != null) {
                if (!this.plugin.getFilteredSkills().contains(xpDrop.getSkill().getName().toLowerCase())) {
                    XpDropInFlight xpDropInFlight;
                    int hit3;
                    int icons = 0;
                    if (this.config.showIcons()) {
                        icons = 1 << CustomizableXpDropsPlugin.SKILL_PRIORITY[xpDrop.getSkill().ordinal()];
                    }
                    int amount = xpDrop.getExperience();
                    if (xpDrop.isFake() && this.config.showFakeIcon()) {
                        icons |= 0x800000;
                    }
                    if (dropsInFlightMap.containsKey((Object)xpDrop.getSkill())) {
                        hit3 = this.config.neverGroupPredictedHit() || filteredHit ? 0 : totalHit;
                        xpDropInFlight = (XpDropInFlight)dropsInFlightMap.get((Object)xpDrop.getSkill());
                        xpDropInFlight.setHit(hit3);
                        xpDropInFlight.setAmount(xpDropInFlight.getAmount() + amount);
                    } else {
                        hit3 = this.config.neverGroupPredictedHit() || filteredHit ? 0 : totalHit;
                        xpDropInFlight = new XpDropInFlight(icons, amount, style, 0.0f, 0.0f, 255.0f, 0.0f, hit3, xpDrop.getAttachedActor(), false);
                        dropsInFlightMap.put(xpDrop.getSkill(), xpDropInFlight);
                        dropsInFlight.add(xpDropInFlight);
                    }
                }
                xpDrop = this.plugin.getQueue().poll();
            }
            drops.addAll(dropsInFlight);
        }
        int index = 0;
        lastFrame = Math.min(0.0f, lastFrame);
        for (XpDropInFlight drop : drops) {
            float frameOffset = (float)(-index * this.config.groupedDelay()) + lastFrame;
            drop.setFrame(frameOffset);
            this.xpDropsInFlight.add(drop);
            ++index;
        }
    }

    public void clearIconCache() {
        ICON_CACHE.clear();
    }

    private BufferedImage getIcon(int icon, int spriteIndex) {
        int key = icon + spriteIndex << 16;
        if (ICON_CACHE.containsKey(key) && ICON_CACHE.get(key) != null) {
            return ICON_CACHE.get(key);
        }
        if (this.client == null) {
            return null;
        }
        if (this.config.iconOverride() && this.client.getSpriteOverrides().containsKey(icon)) {
            BufferedImage img = ((SpritePixels)this.client.getSpriteOverrides().get(icon)).toBufferedImage();
            ICON_CACHE.put(key, img);
            return img;
        }
        SpritePixels[] pixels = this.client.getSprites(this.client.getIndexSprites(), icon, 0);
        if (pixels != null && pixels.length >= spriteIndex + 1 && pixels[spriteIndex] != null) {
            BufferedImage img = pixels[spriteIndex].toBufferedImage();
            ICON_CACHE.put(key, img);
            return img;
        }
        return null;
    }

    public static int monospacedWidth(Graphics2D graphics, String text) {
        if (maxMonospaceDigit == null || maxMonospaceDigit.getFont() == null || !maxMonospaceDigit.getFont().equals(graphics.getFont())) {
            char[] chars;
            maxMonospaceDigit = new MaxMonospaceDigit(0, "0", graphics.getFont());
            for (char aChar : chars = new char[]{'1', '2', '3', '4', '5', '6', '7', '8', '9', '0'}) {
                if (graphics.getFontMetrics().charWidth(aChar) < maxMonospaceDigit.getWidth()) continue;
                maxMonospaceDigit.setCharacter(String.valueOf(aChar));
                maxMonospaceDigit.setWidth(graphics.getFontMetrics().charWidth(aChar));
            }
        }
        return graphics.getFontMetrics().stringWidth(text.replaceAll("[0-9]", maxMonospaceDigit.getCharacter()));
    }

    public ArrayList<XpDropInFlight> getXpDropsInFlight() {
        return this.xpDropsInFlight;
    }

    public boolean isShouldDraw() {
        return this.shouldDraw;
    }

    public void setShouldDraw(boolean shouldDraw) {
        this.shouldDraw = shouldDraw;
    }

    public long getLastFrameTime() {
        return this.lastFrameTime;
    }

    public void setLastFrameTime(long lastFrameTime) {
        this.lastFrameTime = lastFrameTime;
    }

    public Skill getLastSkill() {
        return this.lastSkill;
    }

    public void setLastSkillSetMillis(long lastSkillSetMillis) {
        this.lastSkillSetMillis = lastSkillSetMillis;
    }

    public long getLastSkillSetMillis() {
        return this.lastSkillSetMillis;
    }

    static class MaxMonospaceDigit {
        int width;
        String character;
        Font font;

        public int getWidth() {
            return this.width;
        }

        public String getCharacter() {
            return this.character;
        }

        public Font getFont() {
            return this.font;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public void setCharacter(String character) {
            this.character = character;
        }

        public void setFont(Font font) {
            this.font = font;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MaxMonospaceDigit)) {
                return false;
            }
            MaxMonospaceDigit other = (MaxMonospaceDigit)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getWidth() != other.getWidth()) {
                return false;
            }
            String this$character = this.getCharacter();
            String other$character = other.getCharacter();
            if (this$character == null ? other$character != null : !this$character.equals(other$character)) {
                return false;
            }
            Font this$font = this.getFont();
            Font other$font = other.getFont();
            return !(this$font == null ? other$font != null : !((Object)this$font).equals(other$font));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MaxMonospaceDigit;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getWidth();
            String $character = this.getCharacter();
            result = result * 59 + ($character == null ? 43 : $character.hashCode());
            Font $font = this.getFont();
            result = result * 59 + ($font == null ? 43 : ((Object)$font).hashCode());
            return result;
        }

        public String toString() {
            return "XpDropOverlayManager.MaxMonospaceDigit(width=" + this.getWidth() + ", character=" + this.getCharacter() + ", font=" + this.getFont() + ")";
        }

        public MaxMonospaceDigit(int width, String character, Font font) {
            this.width = width;
            this.character = character;
            this.font = font;
        }
    }
}

