/*
 * Decompiled with CFR 0.152.
 */
package com.xpdrops;

import com.google.inject.Provides;
import com.xpdrops.Skill;
import com.xpdrops.XpDrop;
import com.xpdrops.XpDropStyle;
import com.xpdrops.XpPrayer;
import com.xpdrops.attackstyles.AttackStyle;
import com.xpdrops.attackstyles.WeaponType;
import com.xpdrops.config.XpDropsConfig;
import com.xpdrops.overlay.XpDropOverlayManager;
import com.xpdrops.predictedhit.Hit;
import com.xpdrops.predictedhit.XpDropDamageCalculator;
import com.xpdrops.predictedhit.npcswithscalingbonus.ChambersLayoutSolver;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashSet;
import java.util.PriorityQueue;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.Prayer;
import net.runelite.api.events.BeforeRender;
import net.runelite.api.events.FakeXpDrop;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.InteractingChanged;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.events.ScriptPreFired;
import net.runelite.api.events.StatChanged;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDependency;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.xptracker.XpTrackerPlugin;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDependency(value=XpTrackerPlugin.class)
@PluginDescriptor(name="Customizable XP drops", description="Allows one to use fully customizable xp drops independent of the in-game ones")
public class CustomizableXpDropsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(CustomizableXpDropsPlugin.class);
    public static final int[] SKILL_PRIORITY = new int[]{1, 5, 2, 6, 3, 7, 4, 15, 17, 18, 0, 16, 11, 14, 13, 9, 8, 10, 19, 20, 12, 22, 21};
    @Inject
    private Client client;
    @Inject
    private XpDropOverlayManager xpDropOverlayManager;
    @Inject
    private XpDropsConfig config;
    @Inject
    private ClientThread clientThread;
    @Inject
    private XpDropDamageCalculator xpDropDamageCalculator;
    @Inject
    private ChambersLayoutSolver chambersLayoutSolver;
    private final PriorityQueue<XpDrop> queue = new PriorityQueue(this::skillPriorityComparator);
    private final ArrayDeque<Hit> hitBuffer = new ArrayDeque();
    private final HashSet<String> filteredSkills = new HashSet();
    private final HashSet<String> filteredSkillsPredictedHits = new HashSet();
    private static final int EXPERIENCE_TRACKER_TOGGLE = 4702;
    private static final int XP_TRACKER_SCRIPT_ID = 997;
    private static final int XP_TRACKER_WIDGET_GROUP_ID = 122;
    private static final int XP_TRACKER_WIDGET_CHILD_ID = 4;
    private static final int[] previous_exp = new int[Skill.values().length - 1];
    private int lastOpponentId = -1;
    private boolean lastOpponentIsPlayer = false;
    private Actor lastOpponent;
    private boolean resetXpTrackerLingerTimerFlag = false;
    private int attackStyleVarbit = -1;
    private int equippedWeaponTypeVarbit = -1;
    private int castingModeVarbit = -1;
    private AttackStyle attackStyle;

    @Provides
    XpDropsConfig provideConfig(ConfigManager configManager) {
        return (XpDropsConfig)configManager.getConfig(XpDropsConfig.class);
    }

    int skillPriorityComparator(XpDrop x1, XpDrop x2) {
        int priority1 = SKILL_PRIORITY[x1.getSkill().ordinal()];
        int priority2 = SKILL_PRIORITY[x2.getSkill().ordinal()];
        return Integer.compare(priority1, priority2);
    }

    protected void startUp() {
        long time = System.currentTimeMillis();
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            this.clientThread.invokeLater(() -> {
                int[] xps = this.client.getSkillExperiences();
                System.arraycopy(xps, 0, previous_exp, 0, previous_exp.length);
                this.initAttackStyles();
                this.initShouldDraw();
            });
        } else {
            Arrays.fill(previous_exp, 0);
        }
        this.queue.clear();
        this.xpDropOverlayManager.startup();
        this.filteredSkillsPredictedHits.clear();
        this.filteredSkillsPredictedHits.addAll(Text.fromCSV((String)this.config.skillsToFilterForPredictedHits()).stream().map(String::toLowerCase).collect(Collectors.toList()));
        if (this.filteredSkillsPredictedHits.contains("runecrafting")) {
            this.filteredSkillsPredictedHits.add("runecraft");
        }
        this.filteredSkills.clear();
        this.filteredSkills.addAll(Text.fromCSV((String)this.config.skillsToFilter()).stream().map(String::toLowerCase).collect(Collectors.toList()));
        if (this.filteredSkills.contains("runecrafting")) {
            this.filteredSkills.add("runecraft");
        }
        this.setXpTrackerHidden(this.config.useXpTracker());
        this.xpDropDamageCalculator.populateMap();
        long totalTime = System.currentTimeMillis() - time;
        log.debug("Plugin took {}ms to start.", (Object)totalTime);
    }

    private void initShouldDraw() {
        boolean shouldDraw = this.client.getVarbitValue(4702) == 1;
        this.xpDropOverlayManager.setShouldDraw(shouldDraw);
    }

    private void initAttackStyles() {
        this.attackStyleVarbit = this.client.getVarpValue(43);
        this.equippedWeaponTypeVarbit = this.client.getVarbitValue(357);
        this.castingModeVarbit = this.client.getVarbitValue(2668);
        this.updateAttackStyle(this.equippedWeaponTypeVarbit, this.attackStyleVarbit, this.castingModeVarbit);
    }

    private void updateAttackStyle(int equippedWeaponType, int attackStyleIndex, int castingMode) {
        AttackStyle[] attackStyles = WeaponType.getWeaponType(equippedWeaponType).getAttackStyles();
        if (attackStyleIndex < attackStyles.length) {
            this.attackStyle = attackStyles[attackStyleIndex];
            if (this.attackStyle == null) {
                this.attackStyle = AttackStyle.OTHER;
            } else if (this.attackStyle == AttackStyle.CASTING && castingMode == 1) {
                this.attackStyle = AttackStyle.DEFENSIVE_CASTING;
            }
        }
    }

    protected void shutDown() {
        this.xpDropOverlayManager.shutdown();
        this.setXpTrackerHidden(false);
    }

    protected void setXpTrackerHidden(boolean hidden) {
        this.clientThread.invokeLater(() -> {
            Widget xpTracker = this.client.getWidget(122, 4);
            if (xpTracker != null) {
                xpTracker.setHidden(hidden);
            }
        });
    }

    @Subscribe
    protected void onVarbitChanged(VarbitChanged varbitChanged) {
        boolean shouldDraw = this.client.getVarbitValue(4702) == 1;
        this.xpDropOverlayManager.setShouldDraw(shouldDraw);
        int currentAttackStyleVarbit = this.client.getVarpValue(43);
        int currentEquippedWeaponTypeVarbit = this.client.getVarbitValue(357);
        int currentCastingModeVarbit = this.client.getVarbitValue(2668);
        if (this.attackStyleVarbit != currentAttackStyleVarbit || this.equippedWeaponTypeVarbit != currentEquippedWeaponTypeVarbit || this.castingModeVarbit != currentCastingModeVarbit) {
            this.attackStyleVarbit = currentAttackStyleVarbit;
            this.equippedWeaponTypeVarbit = currentEquippedWeaponTypeVarbit;
            this.castingModeVarbit = currentCastingModeVarbit;
            this.updateAttackStyle(this.equippedWeaponTypeVarbit, this.attackStyleVarbit, this.castingModeVarbit);
        }
        this.chambersLayoutSolver.onVarbitChanged(varbitChanged);
    }

    @Subscribe
    protected void onGameTick(GameTick gameTick) {
        this.chambersLayoutSolver.onGameTick(gameTick);
    }

    @Subscribe
    protected void onConfigChanged(ConfigChanged configChanged) {
        if ("CustomizableXPDrops".equals(configChanged.getGroup())) {
            if ("skillsToFilter".equals(configChanged.getKey())) {
                this.filteredSkills.clear();
                this.filteredSkills.addAll(Text.fromCSV((String)this.config.skillsToFilter()).stream().map(String::toLowerCase).collect(Collectors.toList()));
                if (this.filteredSkills.contains("runecrafting")) {
                    this.filteredSkills.add("runecraft");
                }
            }
            if ("skillsToFilterForPredictedHits".equals(configChanged.getKey())) {
                this.filteredSkillsPredictedHits.clear();
                this.filteredSkillsPredictedHits.addAll(Text.fromCSV((String)this.config.skillsToFilterForPredictedHits()).stream().map(String::toLowerCase).collect(Collectors.toList()));
                if (this.filteredSkillsPredictedHits.contains("runecrafting")) {
                    this.filteredSkillsPredictedHits.add("runecraft");
                }
            }
            if ("useXpTracker".equals(configChanged.getKey())) {
                this.setXpTrackerHidden(this.config.useXpTracker());
            }
            if ("attachToTarget".equals(configChanged.getKey()) || "attachToPlayer".equals(configChanged.getKey())) {
                this.xpDropOverlayManager.overlayTypeConfigChanged();
            }
            if ("iconOverride".equals(configChanged.getKey())) {
                this.xpDropOverlayManager.clearIconCache();
            }
            if ("xpDropOverlayPriority".equals(configChanged.getKey())) {
                this.xpDropOverlayManager.xpDropOverlayPriorityChanged();
            }
            if ("xpTrackerOverlayPriority".equals(configChanged.getKey())) {
                this.xpDropOverlayManager.xpTrackerOverlayPriorityChanged();
            }
            if ("xpTrackerHideVanilla".equals(configChanged.getKey())) {
                this.setXpTrackerHidden(this.config.xpTrackerHideVanilla());
            }
        }
    }

    @Subscribe
    public void onInteractingChanged(InteractingChanged event) {
        Actor opponent;
        if (event.getSource() != this.client.getLocalPlayer()) {
            return;
        }
        this.lastOpponent = opponent = event.getTarget();
        if (opponent instanceof NPC) {
            NPC npc = (NPC)opponent;
            this.lastOpponentId = npc.getId();
            this.lastOpponentIsPlayer = false;
        } else if (opponent instanceof Player) {
            this.lastOpponentId = opponent.getCombatLevel();
            this.lastOpponentIsPlayer = true;
        } else {
            this.lastOpponentId = -1;
        }
    }

    @Subscribe
    public void onScriptPreFired(ScriptPreFired scriptPreFired) {
        int intStackSize;
        int[] intStack;
        int widgetId;
        Widget xpdrop;
        if (!this.config.xpDropsHideVanilla()) {
            return;
        }
        if (scriptPreFired.getScriptId() == 996 && (xpdrop = this.client.getWidget(widgetId = (intStack = this.client.getIntStack())[(intStackSize = this.client.getIntStackSize()) - 4])) != null) {
            xpdrop.setHidden(true);
        }
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired scriptPostFired) {
        Widget xpTracker;
        if (!this.config.xpTrackerHideVanilla()) {
            return;
        }
        if (scriptPostFired.getScriptId() == 997 && (xpTracker = this.client.getWidget(122, 4)) != null) {
            xpTracker.setHidden(this.config.useXpTracker());
        }
    }

    @Subscribe
    protected void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGIN_SCREEN || gameStateChanged.getGameState() == GameState.HOPPING) {
            Arrays.fill(previous_exp, 0);
            this.resetXpTrackerLingerTimerFlag = true;
        }
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN && this.resetXpTrackerLingerTimerFlag) {
            this.resetXpTrackerLingerTimerFlag = false;
            this.xpDropOverlayManager.setLastSkillSetMillis(System.currentTimeMillis());
        }
        this.chambersLayoutSolver.onGameStateChanged(gameStateChanged);
    }

    @Subscribe
    protected void onFakeXpDrop(FakeXpDrop event) {
        int currentXp = event.getXp();
        if (event.getXp() >= 20000000) {
            return;
        }
        if (event.getSkill() == net.runelite.api.Skill.HITPOINTS) {
            int hit = this.lastOpponentIsPlayer ? this.xpDropDamageCalculator.calculateHitOnPlayer(this.lastOpponentId, currentXp, this.config.xpMultiplier()) : this.xpDropDamageCalculator.calculateHitOnNpc(this.lastOpponentId, currentXp, this.config.xpMultiplier());
            log.debug("Hit npc with fake hp xp drop xp:{} hit:{} npc_id:{}", new Object[]{currentXp, hit, this.lastOpponentId});
            this.hitBuffer.add(new Hit(hit, this.lastOpponent, this.attackStyle));
        }
        XpDrop xpDrop = new XpDrop(Skill.fromSkill(event.getSkill()), currentXp, this.matchPrayerStyle(Skill.fromSkill(event.getSkill())), true, this.lastOpponent);
        this.queue.add(xpDrop);
    }

    @Subscribe
    protected void onStatChanged(StatChanged event) {
        int currentXp = event.getXp();
        int previousXp = previous_exp[event.getSkill().ordinal()];
        if (previousXp > 0 && currentXp - previousXp > 0) {
            if (event.getSkill() == net.runelite.api.Skill.HITPOINTS) {
                int hit = this.lastOpponentIsPlayer ? this.xpDropDamageCalculator.calculateHitOnPlayer(this.lastOpponentId, currentXp - previousXp, this.config.xpMultiplier()) : this.xpDropDamageCalculator.calculateHitOnNpc(this.lastOpponentId, currentXp - previousXp, this.config.xpMultiplier());
                log.debug("Hit npc with hp xp drop xp:{} hit:{} npc_id:{}", new Object[]{currentXp - previousXp, hit, this.lastOpponentId});
                this.hitBuffer.add(new Hit(hit, this.lastOpponent, this.attackStyle));
            }
            XpDrop xpDrop = new XpDrop(Skill.fromSkill(event.getSkill()), currentXp - previousXp, this.matchPrayerStyle(Skill.fromSkill(event.getSkill())), false, this.lastOpponent);
            this.queue.add(xpDrop);
        }
        CustomizableXpDropsPlugin.previous_exp[event.getSkill().ordinal()] = event.getXp();
    }

    @Subscribe
    protected void onBeforeRender(BeforeRender beforeRender) {
        this.xpDropOverlayManager.update();
    }

    private XpPrayer getActivePrayer() {
        for (XpPrayer prayer : XpPrayer.values()) {
            if (this.client.getServerVarbitValue(prayer.getPrayer().getVarbit()) != 1) continue;
            return prayer;
        }
        return null;
    }

    protected boolean isVoidwakerEquipped() {
        ItemContainer equipment = this.client.getItemContainer(InventoryID.EQUIPMENT);
        if (equipment == null) {
            return false;
        }
        Item weapon = equipment.getItem(EquipmentInventorySlot.WEAPON.getSlotIdx());
        return weapon != null && weapon.getId() == 27690;
    }

    protected XpDropStyle matchPrayerStyle(Skill skill) {
        XpPrayer activePrayer = this.getActivePrayer();
        if (activePrayer != null) {
            if (activePrayer.getStyles().contains((Object)this.attackStyle)) {
                for (Skill attackStyleSkill : this.attackStyle.getSkills()) {
                    if (attackStyleSkill != skill) continue;
                    return activePrayer.getType();
                }
            }
            if (skill == Skill.MAGIC && activePrayer.getType() == XpDropStyle.MAGE) {
                return XpDropStyle.MAGE;
            }
            if (skill == Skill.MAGIC && activePrayer.getType() == XpDropStyle.MELEE && this.isVoidwakerEquipped()) {
                return XpDropStyle.MELEE;
            }
            if (activePrayer.getPrayer() == Prayer.RP_TRINITAS || activePrayer.getPrayer() == Prayer.RP_INTENSIFY) {
                switch (skill) {
                    case ATTACK: 
                    case STRENGTH: 
                    case DEFENCE: {
                        return XpDropStyle.MELEE;
                    }
                    case RANGED: {
                        return XpDropStyle.RANGE;
                    }
                    case MAGIC: {
                        return XpDropStyle.MAGE;
                    }
                }
            }
        }
        return XpDropStyle.DEFAULT;
    }

    public PriorityQueue<XpDrop> getQueue() {
        return this.queue;
    }

    public ArrayDeque<Hit> getHitBuffer() {
        return this.hitBuffer;
    }

    public HashSet<String> getFilteredSkills() {
        return this.filteredSkills;
    }

    public HashSet<String> getFilteredSkillsPredictedHits() {
        return this.filteredSkillsPredictedHits;
    }

    public AttackStyle getAttackStyle() {
        return this.attackStyle;
    }
}

