/*
 * Decompiled with CFR 0.152.
 */
package com.customdeathsound;

import com.customdeathsound.CustomDeathSoundConfig;
import com.google.inject.Provides;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Paths;
import javax.inject.Inject;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.AnimationChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Custom death sound")
public class CustomDeathSoundPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(CustomDeathSoundPlugin.class);
    public Clip clip;
    @Inject
    private Client client;
    @Inject
    private CustomDeathSoundConfig config;
    public boolean isPlaying = false;

    @Subscribe
    public void onAnimationChanged(AnimationChanged animationChanged) {
        if (this.client.getGameState() == GameState.LOGGED_IN && this.client.getLocalPlayer() != null && this.client.getLocalPlayer().getHealthRatio() == 0 && this.client.getLocalPlayer().getAnimation() == 836) {
            this.playSound();
        }
    }

    private void playSound() {
        String soundFile = this.config.soundFile();
        if (soundFile.length() == 0) {
            return;
        }
        if (this.isPlaying) {
            log.info("Already playing");
            return;
        }
        log.info("Playing sound");
        if (this.clip != null) {
            this.clip.close();
        }
        AudioInputStream inputStream = null;
        try {
            URL url = Paths.get(soundFile, new String[0]).toUri().toURL();
            inputStream = AudioSystem.getAudioInputStream(url);
        }
        catch (IOException | UnsupportedAudioFileException e2) {
            log.warn("Unable to create audio input stream: ", (Throwable)e2);
        }
        if (inputStream == null) {
            return;
        }
        try {
            this.clip = AudioSystem.getClip();
            this.clip.open(inputStream);
        }
        catch (IOException | LineUnavailableException e3) {
            log.warn("Could not load sound file: ", (Throwable)e3);
        }
        FloatControl volume = (FloatControl)this.clip.getControl(FloatControl.Type.MASTER_GAIN);
        float volumeValue = this.config.volume() - 100;
        volume.setValue(volumeValue);
        this.clip.loop(0);
        this.isPlaying = true;
        this.clip.addLineListener(e -> {
            if (e.getType() == LineEvent.Type.STOP) {
                this.isPlaying = false;
                log.info("Done playing sound");
            }
        });
    }

    @Provides
    CustomDeathSoundConfig provideConfig(ConfigManager configManager) {
        return (CustomDeathSoundConfig)configManager.getConfig(CustomDeathSoundConfig.class);
    }
}

