/*
 * Decompiled with CFR 0.152.
 */
package io.robrichardson.inventorycount;

import com.google.inject.Provides;
import io.robrichardson.inventorycount.InventoryCountConfig;
import io.robrichardson.inventorycount.InventoryCountInfoBox;
import io.robrichardson.inventorycount.InventoryCountOverlay;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Inventory Count")
public class InventoryCountPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(InventoryCountPlugin.class);
    @Inject
    private Client client;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private InventoryCountOverlay overlay;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private InventoryCountConfig config;
    private static final BufferedImage INVENTORY_IMAGE = ImageUtil.loadImageResource(InventoryCountPlugin.class, (String)"inventory_icon.png");
    private static final int INVENTORY_SIZE = 28;
    private InventoryCountInfoBox inventoryCountInfoBox;

    protected void startUp() throws Exception {
        if (this.config.renderOnInventory()) {
            this.overlayManager.add((Overlay)this.overlay);
            this.updateOverlays();
        } else {
            this.addInfoBox();
        }
    }

    protected void shutDown() throws Exception {
        if (this.config.renderOnInventory()) {
            this.overlayManager.remove((Overlay)this.overlay);
        } else {
            this.removeInfoBox();
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!"InventoryCount".equals(event.getGroup())) {
            return;
        }
        if ("renderOnInventory".equals(event.getKey())) {
            if (this.config.renderOnInventory()) {
                this.removeInfoBox();
                this.overlayManager.add((Overlay)this.overlay);
                this.updateOverlays();
            } else {
                this.overlayManager.remove((Overlay)this.overlay);
                this.addInfoBox();
            }
        }
    }

    @Provides
    InventoryCountConfig provideConfig(ConfigManager configManager) {
        return (InventoryCountConfig)configManager.getConfig(InventoryCountConfig.class);
    }

    private void addInfoBox() {
        this.inventoryCountInfoBox = new InventoryCountInfoBox(INVENTORY_IMAGE, this);
        this.updateOverlays();
        this.infoBoxManager.addInfoBox((InfoBox)this.inventoryCountInfoBox);
    }

    private void removeInfoBox() {
        this.infoBoxManager.removeInfoBox((InfoBox)this.inventoryCountInfoBox);
        this.inventoryCountInfoBox = null;
    }

    private void updateOverlays() {
        String text = String.valueOf(this.openInventorySpaces());
        if (this.config.renderOnInventory()) {
            this.overlay.setText(text);
        } else {
            this.inventoryCountInfoBox.setText(text);
        }
    }

    private int openInventorySpaces() {
        ItemContainer container = this.client.getItemContainer(InventoryID.INVENTORY);
        Item[] items = container == null ? new Item[]{} : container.getItems();
        int usedSpaces = (int)Arrays.stream(items).filter(p -> p.getId() != -1).count();
        return 28 - usedSpaces;
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (event.getContainerId() == InventoryID.INVENTORY.getId()) {
            this.updateOverlays();
        }
    }

    public InventoryCountInfoBox getInventoryCountInfoBox() {
        return this.inventoryCountInfoBox;
    }
}

