/*
 * Decompiled with CFR 0.152.
 */
package com.dandylyon.inventorynotifier;

import com.dandylyon.inventorynotifier.InventoryNotifierInfoBox;
import com.dandylyon.inventorynotifier.InventoryNotifierOverlay;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.client.Notifier;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Inventory Notifier")
public class InventoryNotifierPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(InventoryNotifierPlugin.class);
    @Inject
    private Client client;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private InventoryNotifierOverlay overlay;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private Notifier notifier;
    private static final BufferedImage INVENTORY_IMAGE = ImageUtil.loadImageResource(InventoryNotifierPlugin.class, (String)"inventory_icon.png");
    private static final BufferedImage INVENTORY_FULL_IMAGE = ImageUtil.loadImageResource(InventoryNotifierPlugin.class, (String)"inventory_full_icon.png");
    private BufferedImage CURRENT_IMAGE = INVENTORY_IMAGE;
    private static final int INVENTORY_SIZE = 28;
    private InventoryNotifierInfoBox inventoryNotifierInfoBox;

    protected void startUp() throws Exception {
        this.addInfoBox();
    }

    protected void shutDown() throws Exception {
        this.removeInfoBox();
    }

    private void addInfoBox() {
        this.inventoryNotifierInfoBox = new InventoryNotifierInfoBox(this.CURRENT_IMAGE, this);
        this.updateOverlays();
        this.infoBoxManager.addInfoBox((InfoBox)this.inventoryNotifierInfoBox);
    }

    private void removeInfoBox() {
        this.infoBoxManager.removeInfoBox((InfoBox)this.inventoryNotifierInfoBox);
        this.inventoryNotifierInfoBox = null;
    }

    private void updateOverlays() {
        String text = String.valueOf(this.openInventorySpaces());
        if (this.openInventorySpaces() == 0) {
            this.CURRENT_IMAGE = INVENTORY_FULL_IMAGE;
            this.inventoryNotifierInfoBox.setText("");
            this.notifier.notify("Your inventory is full.");
        } else {
            this.CURRENT_IMAGE = INVENTORY_IMAGE;
            this.inventoryNotifierInfoBox.setText(text);
        }
    }

    private int openInventorySpaces() {
        ItemContainer container = this.client.getItemContainer(InventoryID.INVENTORY);
        Item[] items = container == null ? new Item[]{} : container.getItems();
        int usedSpaces = (int)Arrays.stream(items).filter(p -> p.getId() != -1).count();
        return 28 - usedSpaces;
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (event.getContainerId() == InventoryID.INVENTORY.getId()) {
            this.updateOverlays();
            this.removeInfoBox();
            this.addInfoBox();
        }
    }

    public InventoryNotifierInfoBox getInventoryNotifierInfoBox() {
        return this.inventoryNotifierInfoBox;
    }
}

