/*
 * Decompiled with CFR 0.152.
 */
package com.dandylyon.inventorynotifier;

import com.dandylyon.inventorynotifier.InventoryNotifierPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.config.FontType;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InventoryNotifierOverlay
extends Overlay {
    private static final Logger log = LoggerFactory.getLogger(InventoryNotifierOverlay.class);
    private final Client client;
    private final ConfigManager configManager;
    private String _text;

    @Inject
    public InventoryNotifierOverlay(Client client, InventoryNotifierPlugin plugin, ConfigManager configManager) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
        this.setPriority(OverlayPriority.HIGH);
        this.client = client;
        this.configManager = configManager;
    }

    public Dimension render(Graphics2D graphics) {
        Widget toDrawOn;
        if (this.client.isResized()) {
            toDrawOn = this.client.getWidget(WidgetInfo.RESIZABLE_VIEWPORT_INVENTORY_TAB);
            if (toDrawOn == null || toDrawOn.isHidden()) {
                toDrawOn = this.client.getWidget(WidgetInfo.RESIZABLE_VIEWPORT_BOTTOM_LINE_INVENTORY_TAB);
            }
        } else {
            toDrawOn = this.client.getWidget(WidgetInfo.FIXED_VIEWPORT_INVENTORY_TAB);
        }
        if (toDrawOn == null || toDrawOn.isHidden()) {
            return null;
        }
        String textToDraw = this._text;
        FontType infoboxFontType = (FontType)this.configManager.getConfiguration("runelite", "infoboxFontType", FontType.class);
        graphics.setFont(infoboxFontType.getFont());
        Rectangle bounds = toDrawOn.getBounds();
        Point drawLocation = new Point((int)bounds.getCenterX() - graphics.getFontMetrics().stringWidth(textToDraw) / 2, (int)bounds.getMaxY());
        OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)drawLocation, (String)textToDraw, (Color)Color.WHITE);
        return null;
    }

    public void setText(String text) {
        this._text = text;
    }
}

