/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.runeliteplugins.profitcalc.ui;

import com.duckblade.runeliteplugins.profitcalc.CalcItemStack;
import com.duckblade.runeliteplugins.profitcalc.ProfitCalcPlugin;
import com.duckblade.runeliteplugins.profitcalc.ui.HeaderPanel;
import com.duckblade.runeliteplugins.profitcalc.ui.ItemListPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridLayout;
import javax.inject.Singleton;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;

@Singleton
public class ProfitCalcPanel
extends PluginPanel {
    private final ProfitCalcPlugin plugin;
    private HeaderPanel headerPanel;
    private ItemListPanel inputPanel;
    private ItemListPanel outputPanel;
    private JPanel itemListPanel;
    private JLabel profitLabel;
    private float profit;

    public ProfitCalcPanel(ProfitCalcPlugin parent) {
        super(false);
        this.plugin = parent;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.headerPanel = new HeaderPanel(this);
        this.add(this.headerPanel, "North");
        this.itemListPanel = new JPanel();
        this.itemListPanel.setLayout(new GridLayout(2, 1));
        this.itemListPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.add(this.itemListPanel, "Center");
        this.inputPanel = new ItemListPanel(this);
        this.inputPanel.setInputMode(true);
        this.itemListPanel.add(this.inputPanel);
        this.outputPanel = new ItemListPanel(this);
        this.outputPanel.setInputMode(false);
        this.itemListPanel.add(this.outputPanel);
        this.profit = 0.0f;
        this.profitLabel = new JLabel("Profit: 0gp", 4);
        this.profitLabel.setForeground(Color.white);
        this.add(this.profitLabel, "South");
    }

    public void reset() {
        this.inputPanel.reset();
        this.outputPanel.reset();
    }

    public void addItemFromSearch(boolean inputMode, CalcItemStack itemStack) {
        SwingUtilities.invokeLater(() -> {
            ItemListPanel target = inputMode ? this.inputPanel : this.outputPanel;
            target.addItemFromSearch(itemStack);
            this.recalculate();
        });
    }

    public void recalculate() {
        SwingUtilities.invokeLater(() -> {
            this.profit = this.outputPanel.getValue() - this.inputPanel.getValue();
            this.profitLabel.setText("Profit: " + ProfitCalcPlugin.DECIMAL_FORMAT.format(this.profit) + "gp");
            this.repaint();
            this.revalidate();
        });
    }

    public ProfitCalcPlugin getPlugin() {
        return this.plugin;
    }
}

