/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.runeliteplugins.profitcalc.ui;

import com.duckblade.runeliteplugins.profitcalc.CalcItemStack;
import com.duckblade.runeliteplugins.profitcalc.ProfitCalcPlugin;
import com.duckblade.runeliteplugins.profitcalc.ui.ItemListPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import net.runelite.client.ui.ColorScheme;

public class ItemStackPanel
extends JPanel {
    private CalcItemStack itemStack;
    private final ItemListPanel parent;
    private JLabel imageLabel;
    private JPanel innerPanel;
    private JLabel nameLabel;
    private JLabel amountPpuLabel;
    private JLabel priceLabel;
    private JPopupMenu rightClickMenu;

    public ItemStackPanel(ItemListPanel parent, CalcItemStack itemStack) {
        this.parent = parent;
        this.itemStack = itemStack;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createLineBorder(ColorScheme.LIGHT_GRAY_COLOR, 1, true));
        this.setMaximumSize(new Dimension(500, 60));
        this.rightClickMenu = new JPopupMenu();
        this.setComponentPopupMenu(this.rightClickMenu);
        JMenuItem setQuantityItem = new JMenuItem("Set Quantity");
        setQuantityItem.addActionListener(e -> parent.getCalcPanel().getPlugin().getCalcItemSearch().triggerNewQuantity(this));
        this.rightClickMenu.add(setQuantityItem);
        JMenuItem setPpuItem = new JMenuItem("Set Price Per Item");
        setPpuItem.addActionListener(e -> parent.getCalcPanel().getPlugin().getCalcItemSearch().triggerNewPpu(this));
        this.rightClickMenu.add(setPpuItem);
        JMenuItem removeItem = new JMenuItem("Remove");
        removeItem.addActionListener(e -> parent.removeItem(this));
        this.rightClickMenu.add(removeItem);
        this.imageLabel = new JLabel();
        itemStack.getItemIcon().addTo(this.imageLabel);
        this.add((Component)this.imageLabel, "West");
        this.innerPanel = new JPanel();
        this.innerPanel.setLayout(new GridLayout(3, 1));
        this.add((Component)this.innerPanel, "Center");
        this.nameLabel = new JLabel("", 0);
        this.nameLabel.setForeground(Color.white);
        this.innerPanel.add(this.nameLabel);
        this.amountPpuLabel = new JLabel("", 4);
        this.amountPpuLabel.setForeground(Color.white);
        this.innerPanel.add(this.amountPpuLabel);
        this.priceLabel = new JLabel("", 4);
        this.priceLabel.setForeground(Color.white);
        this.innerPanel.add(this.priceLabel);
        this.recalculate();
    }

    public float getValue() {
        return this.itemStack.getValue();
    }

    public void setItemStack(CalcItemStack newItemStack) {
        this.itemStack = newItemStack;
        this.recalculate();
    }

    public void recalculate() {
        SwingUtilities.invokeLater(() -> {
            this.itemStack.getItemIcon().addTo(this.imageLabel);
            this.nameLabel.setText(this.itemStack.getItemName());
            this.amountPpuLabel.setText(ProfitCalcPlugin.DECIMAL_FORMAT.format(this.itemStack.getPpu()) + "gp x" + ProfitCalcPlugin.DECIMAL_FORMAT.format(this.itemStack.getAmount()));
            this.priceLabel.setText("Total: " + ProfitCalcPlugin.DECIMAL_FORMAT.format(this.itemStack.getValue()) + "gp");
            this.repaint();
            this.revalidate();
            this.parent.recalculate();
        });
    }

    public CalcItemStack getItemStack() {
        return this.itemStack;
    }
}

