/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.runeliteplugins.profitcalc.ui;

import com.duckblade.runeliteplugins.profitcalc.CalcItemStack;
import com.duckblade.runeliteplugins.profitcalc.ProfitCalcPlugin;
import com.duckblade.runeliteplugins.profitcalc.ui.ItemStackPanel;
import com.duckblade.runeliteplugins.profitcalc.ui.ProfitCalcPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.ImageUtil;

public class ItemListPanel
extends JPanel {
    private boolean inputMode = false;
    private final ProfitCalcPanel calcPanel;
    private final JLabel headerLabel;
    private final JLabel totalLabel;
    private final JPanel headerPanel;
    private final ArrayList<ItemStackPanel> items;
    private final JPanel itemPanel;
    private final JButton addButton;

    public ItemListPanel(ProfitCalcPanel parent) {
        this.calcPanel = parent;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createLineBorder(ColorScheme.LIGHT_GRAY_COLOR, 1, false));
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.headerPanel = new JPanel();
        this.headerPanel.setLayout(new GridLayout(2, 1));
        this.headerPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.add((Component)this.headerPanel, "North");
        this.headerLabel = new JLabel(this.inputMode ? "Inputs" : "Outputs", 0);
        Font f = this.headerLabel.getFont();
        this.headerLabel.setFont(f.deriveFont((float)f.getSize() * 1.2f));
        this.headerLabel.setForeground(Color.white);
        this.headerPanel.add(this.headerLabel);
        this.totalLabel = new JLabel("Total: 0gp", 0);
        this.totalLabel.setForeground(Color.white);
        this.headerPanel.add(this.totalLabel);
        this.items = new ArrayList();
        this.itemPanel = new JPanel();
        this.itemPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.itemPanel.setLayout(new BoxLayout(this.itemPanel, 1));
        this.add((Component)this.itemPanel, "Center");
        this.addButton = new JButton(new ImageIcon(ImageUtil.getResourceStreamFromClass(ProfitCalcPlugin.class, (String)"/add.png")));
        this.addButton.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.addButton.setToolTipText("Add " + (this.inputMode ? "Input" : "Output"));
        this.addButton.addActionListener(e -> this.triggerSearch());
        this.add((Component)this.addButton, "South");
    }

    public void triggerSearch() {
        this.calcPanel.getPlugin().getCalcItemSearch().triggerSearch(this.inputMode);
    }

    public void setInputMode(boolean inputMode) {
        this.inputMode = inputMode;
        SwingUtilities.invokeLater(() -> {
            this.headerLabel.setText(this.inputMode ? "Inputs" : "Outputs");
            this.addButton.setToolTipText("Add " + (this.inputMode ? "Input" : "Output"));
        });
    }

    public void addItemFromSearch(CalcItemStack itemStack) {
        ItemStackPanel toAdd = new ItemStackPanel(this, itemStack);
        this.items.add(toAdd);
        this.recalculate();
    }

    public void removeItem(ItemStackPanel toRemove) {
        this.items.remove(toRemove);
        this.recalculate();
    }

    public void reset() {
        this.items.clear();
        this.recalculate();
    }

    public void recalculate() {
        SwingUtilities.invokeLater(() -> {
            this.itemPanel.removeAll();
            this.items.forEach(this.itemPanel::add);
            float value = this.getValue();
            this.totalLabel.setText("Total: " + ProfitCalcPlugin.DECIMAL_FORMAT.format(value) + "gp");
            this.repaint();
            this.revalidate();
            this.calcPanel.recalculate();
        });
    }

    public float getValue() {
        return (float)this.items.stream().mapToDouble(ItemStackPanel::getValue).sum();
    }

    public boolean isInputMode() {
        return this.inputMode;
    }

    public ProfitCalcPanel getCalcPanel() {
        return this.calcPanel;
    }
}

