/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.runeliteplugins.profitcalc;

import com.duckblade.runeliteplugins.profitcalc.ProfitCalcItemSearch;
import com.duckblade.runeliteplugins.profitcalc.ui.ProfitCalcPanel;
import java.text.DecimalFormat;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Profit Calculator")
public class ProfitCalcPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ProfitCalcPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private ProfitCalcItemSearch calcItemSearch;
    private ProfitCalcPanel calcPanel;
    private NavigationButton navButton;
    public static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("###,###,###,##0.#");

    protected void startUp() throws Exception {
        this.calcPanel = new ProfitCalcPanel(this);
        log.info("ProfitCalc started!");
        this.navButton = NavigationButton.builder().tooltip("Profit Calculator").icon(ImageUtil.getResourceStreamFromClass(((Object)((Object)this)).getClass(), (String)"/profit.png")).priority(3).panel((PluginPanel)this.calcPanel).build();
        this.clientToolbar.addNavigation(this.navButton);
    }

    protected void shutDown() throws Exception {
        this.clientToolbar.removeNavigation(this.navButton);
        log.info("ProfitCalc stopped!");
    }

    public Client getClient() {
        return this.client;
    }

    public ProfitCalcItemSearch getCalcItemSearch() {
        return this.calcItemSearch;
    }

    public ProfitCalcPanel getCalcPanel() {
        return this.calcPanel;
    }
}

