/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.runeliteplugins.profitcalc;

import com.duckblade.runeliteplugins.profitcalc.CalcItemStack;
import com.duckblade.runeliteplugins.profitcalc.ProfitCalcPlugin;
import com.duckblade.runeliteplugins.profitcalc.ui.ItemStackPanel;
import java.awt.Component;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.JOptionPane;
import net.runelite.api.GameState;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.chatbox.ChatboxItemSearch;
import net.runelite.client.game.chatbox.ChatboxPanelManager;
import net.runelite.client.util.AsyncBufferedImage;

@Singleton
public class ProfitCalcItemSearch {
    @Inject
    private ChatboxItemSearch itemSearch;
    @Inject
    private ChatboxPanelManager chatboxPanelManager;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ProfitCalcPlugin plugin;

    public void triggerSearch(boolean inputMode) {
        if (this.plugin.getClient().getGameState() != GameState.LOGGED_IN) {
            JOptionPane.showMessageDialog((Component)((Object)this.plugin.getCalcPanel()), "You must be logged in to search.", "Error", 0);
            return;
        }
        this.itemSearch.tooltipText("Add " + (inputMode ? "Input" : "Output")).onItemSelected(i -> this.clientThread.invokeLater(() -> this.triggerAmountInput(this.callbackAddItem(this.itemManager.canonicalize(i.intValue()), inputMode)))).build();
    }

    public void triggerNewQuantity(ItemStackPanel itemStackPanel) {
        this.triggerAmountInput(newAmount -> {
            CalcItemStack oldStack = itemStackPanel.getItemStack();
            CalcItemStack newStack = new CalcItemStack(oldStack.getItemName(), oldStack.getItemIcon(), oldStack.getPpu(), newAmount.floatValue());
            itemStackPanel.setItemStack(newStack);
        });
    }

    public void triggerNewPpu(ItemStackPanel itemStackPanel) {
        this.triggerAmountInput(newPpu -> {
            CalcItemStack oldStack = itemStackPanel.getItemStack();
            CalcItemStack newStack = new CalcItemStack(oldStack.getItemName(), oldStack.getItemIcon(), newPpu.floatValue(), oldStack.getAmount());
            itemStackPanel.setItemStack(newStack);
        });
    }

    private Consumer<Float> callbackAddItem(int itemId, boolean inputMode) {
        return amount -> this.clientThread.invokeLater(() -> {
            int ppu = this.itemManager.getItemPrice(itemId);
            String itemName = this.itemManager.getItemComposition(itemId).getName();
            AsyncBufferedImage itemImage = this.itemManager.getImage(itemId);
            CalcItemStack itemStack = new CalcItemStack(itemName, itemImage, ppu, amount.floatValue());
            this.plugin.getCalcPanel().addItemFromSearch(inputMode, itemStack);
        });
    }

    public void triggerAmountInput(Consumer<Float> callback) {
        this.chatboxPanelManager.openTextInput("Enter Amount").addCharValidator(c -> c >= 48 && c <= 57 || c == 46).onDone(amountStrP -> {
            String amountStr = amountStrP;
            if (amountStr.length() > 10) {
                amountStr = amountStr.substring(0, 10);
            }
            float amount = Float.parseFloat(amountStr);
            callback.accept(Float.valueOf(amount));
        }).build();
    }
}

