/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.runeliteplugins.profitcalc;

import net.runelite.client.util.AsyncBufferedImage;

public class CalcItemStack {
    private final String itemName;
    private final AsyncBufferedImage itemIcon;
    private final float ppu;
    private final float amount;

    public float getValue() {
        return this.ppu * this.amount;
    }

    CalcItemStack(String itemName, AsyncBufferedImage itemIcon, float ppu, float amount) {
        this.itemName = itemName;
        this.itemIcon = itemIcon;
        this.ppu = ppu;
        this.amount = amount;
    }

    public static CalcItemStackBuilder builder() {
        return new CalcItemStackBuilder();
    }

    public String getItemName() {
        return this.itemName;
    }

    public AsyncBufferedImage getItemIcon() {
        return this.itemIcon;
    }

    public float getPpu() {
        return this.ppu;
    }

    public float getAmount() {
        return this.amount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalcItemStack)) {
            return false;
        }
        CalcItemStack other = (CalcItemStack)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$itemName = this.getItemName();
        String other$itemName = other.getItemName();
        if (this$itemName == null ? other$itemName != null : !this$itemName.equals(other$itemName)) {
            return false;
        }
        AsyncBufferedImage this$itemIcon = this.getItemIcon();
        AsyncBufferedImage other$itemIcon = other.getItemIcon();
        if (this$itemIcon == null ? other$itemIcon != null : !this$itemIcon.equals(other$itemIcon)) {
            return false;
        }
        if (Float.compare(this.getPpu(), other.getPpu()) != 0) {
            return false;
        }
        return Float.compare(this.getAmount(), other.getAmount()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof CalcItemStack;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $itemName = this.getItemName();
        result = result * 59 + ($itemName == null ? 43 : $itemName.hashCode());
        AsyncBufferedImage $itemIcon = this.getItemIcon();
        result = result * 59 + ($itemIcon == null ? 43 : $itemIcon.hashCode());
        result = result * 59 + Float.floatToIntBits(this.getPpu());
        result = result * 59 + Float.floatToIntBits(this.getAmount());
        return result;
    }

    public String toString() {
        return "CalcItemStack(itemName=" + this.getItemName() + ", itemIcon=" + this.getItemIcon() + ", ppu=" + this.getPpu() + ", amount=" + this.getAmount() + ")";
    }

    public static class CalcItemStackBuilder {
        private String itemName;
        private AsyncBufferedImage itemIcon;
        private float ppu;
        private float amount;

        CalcItemStackBuilder() {
        }

        public CalcItemStackBuilder itemName(String itemName) {
            this.itemName = itemName;
            return this;
        }

        public CalcItemStackBuilder itemIcon(AsyncBufferedImage itemIcon) {
            this.itemIcon = itemIcon;
            return this;
        }

        public CalcItemStackBuilder ppu(float ppu) {
            this.ppu = ppu;
            return this;
        }

        public CalcItemStackBuilder amount(float amount) {
            this.amount = amount;
            return this;
        }

        public CalcItemStack build() {
            return new CalcItemStack(this.itemName, this.itemIcon, this.ppu, this.amount);
        }

        public String toString() {
            return "CalcItemStack.CalcItemStackBuilder(itemName=" + this.itemName + ", itemIcon=" + this.itemIcon + ", ppu=" + this.ppu + ", amount=" + this.amount + ")";
        }
    }
}

