/*
 * Decompiled with CFR 0.152.
 */
package com.masterkenth;

import com.masterkenth.EventRarity;
import com.masterkenth.ItemData;
import com.masterkenth.JsonUtils;
import com.masterkenth.PickpocketRarity;
import com.masterkenth.RarityItemData;
import com.masterkenth.models.Npc;
import com.masterkenth.models.NpcItem;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.runelite.api.ItemComposition;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.ItemVariationMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RarityChecker {
    private static final Logger log = LoggerFactory.getLogger(RarityChecker.class);

    public ItemData CheckRarityEvent(String eventName, ItemData item, ItemManager itemManager) {
        String lowerName = eventName.toLowerCase();
        Map table = (Map)EventRarity.EVENT_TABLE_MAPPING.getOrDefault((Object)lowerName, null);
        RarityItemData rarityInfo = null;
        if (table != null) {
            if (table.containsKey(item.ItemId)) {
                rarityInfo = (RarityItemData)table.get(item.ItemId);
            } else {
                int mapId = ItemVariationMapping.map((int)item.ItemId);
                Collection idVariations = ItemVariationMapping.getVariations((int)mapId);
                String origName = itemManager.getItemComposition(item.ItemId.intValue()).getName();
                for (Integer id : idVariations) {
                    if (!table.containsKey(id)) continue;
                    String variationName = itemManager.getItemComposition(id.intValue()).getName();
                    if (origName.equals(variationName)) {
                        rarityInfo = (RarityItemData)table.get(item.ItemId);
                        break;
                    }
                    log.warn(String.format("item id %d=%d found in table '%s' but other name ('%s' vs '%s')", item.ItemId, id, eventName, origName, variationName));
                }
            }
        } else {
            log.warn(String.format("No event table for '%s'", eventName));
        }
        if (rarityInfo != null) {
            item.Unique = rarityInfo.Unique;
            item.Rarity = rarityInfo.Rarity;
        } else {
            log.warn(String.format("no rarity for item %d in table '%s'", item.ItemId, eventName));
        }
        return item;
    }

    public ItemData CheckRarityPickpocket(String pickpocketName, ItemData item, ItemManager itemManager) {
        RarityItemData itemData = (RarityItemData)PickpocketRarity.PICKPOCKET_TABLE_MAPPING.getOrDefault((Object)item.ItemId, null);
        if (itemData != null) {
            item.Rarity = itemData.Rarity;
            item.Unique = itemData.Unique;
        }
        return item;
    }

    public CompletableFuture<ItemData> CheckRarityNPC(String npcName, ItemData itemData, ItemManager itemManager, int quantity) {
        CompletableFuture<ItemData> f = new CompletableFuture<ItemData>();
        ItemComposition ic = itemManager.getItemComposition(itemData.ItemId.intValue());
        String origName = ic.getName();
        int mapId = ItemVariationMapping.map((int)itemData.ItemId);
        HashSet<Integer> idVariations = new HashSet<Integer>();
        idVariations.add(itemData.ItemId);
        for (Integer id : ItemVariationMapping.getVariations((int)mapId)) {
            String variationName = itemManager.getItemComposition(id.intValue()).getName();
            if (!origName.equals(variationName)) continue;
            idVariations.add(id);
        }
        try {
            Npc npcDrops = JsonUtils.getInstance().getNpc(npcName);
            if (npcDrops != null) {
                for (Integer id : idVariations) {
                    block12: {
                        NpcItem item = npcDrops.getItems().stream().filter(i -> id.equals(i.getItemID())).findFirst().orElse(null);
                        if (item == null) continue;
                        itemData.Rarity = item.getRarity().floatValue();
                        String dropQuantityStr = item.getQuantity();
                        String[] quantityParts = dropQuantityStr.split("-");
                        if (quantityParts.length == 2) {
                            try {
                                int dropQuantityMin = Integer.parseInt(quantityParts[0]);
                                int dropQuantityMax = Integer.parseInt(quantityParts[1]);
                                if (quantity < dropQuantityMin || quantity > dropQuantityMax) {
                                    continue;
                                }
                                break block12;
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                break block12;
                            }
                        }
                        try {
                            int dropQuantity = Integer.parseInt(dropQuantityStr);
                            if (dropQuantity != quantity) {
                                continue;
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    itemData.Unique = false;
                    f.complete(itemData);
                }
            }
            f.complete(itemData);
        }
        catch (Exception e) {
            f.completeExceptionally(e);
        }
        return f;
    }
}

