/*
 * Decompiled with CFR 0.152.
 */
package com.masterkenth;

import com.google.common.collect.ImmutableMap;
import com.masterkenth.RarityItemData;

public enum PickpocketRarity {
    VYRE_BLOOD_SHARD(24777, 2.0E-4f),
    ELF_TELEPORT_CRYSTAL(23959, 9.765625E-4f);

    private final int itemId;
    private final float rarity;
    public static final ImmutableMap<Integer, RarityItemData> PICKPOCKET_TABLE_MAPPING;

    private static ImmutableMap<Integer, RarityItemData> initPickpocketMapping() {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (PickpocketRarity r : PickpocketRarity.values()) {
            RarityItemData data = new RarityItemData();
            data.Unique = true;
            data.Rarity = r.rarity;
            builder.put((Object)r.itemId, (Object)data);
        }
        return builder.build();
    }

    private PickpocketRarity(int itemId, float rarity) {
        this.itemId = itemId;
        this.rarity = rarity;
    }

    static {
        PICKPOCKET_TABLE_MAPPING = PickpocketRarity.initPickpocketMapping();
    }
}

