/*
 * Decompiled with CFR 0.152.
 */
package com.masterkenth;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.masterkenth.DiscordRareDropNotificaterPlugin;
import com.masterkenth.models.Npc;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private static final Logger log = LoggerFactory.getLogger(JsonUtils.class);
    private static JsonUtils _instance;
    private final List<Npc> npcList;

    public static JsonUtils getInstance() {
        if (_instance == null) {
            _instance = new JsonUtils();
        }
        return _instance;
    }

    public JsonUtils() {
        try (InputStreamReader reader = new InputStreamReader(Objects.requireNonNull(DiscordRareDropNotificaterPlugin.class.getResourceAsStream("/monster-drops.json")), StandardCharsets.UTF_8);){
            this.npcList = (List)new Gson().fromJson((Reader)reader, new TypeToken<List<Npc>>(){}.getType());
        }
        catch (Exception e) {
            log.error("Error getting json", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Npc getNpc(String npcName) {
        return this.npcList.stream().filter(i -> npcName.equals(i.getNpcName())).findFirst().orElse(null);
    }
}

