/*
 * Decompiled with CFR 0.152.
 */
package com.masterkenth;

import com.google.common.collect.ImmutableList;
import com.google.inject.Provides;
import com.masterkenth.ApiTool;
import com.masterkenth.DiscordRareDropNotificaterConfig;
import com.masterkenth.ItemData;
import com.masterkenth.JsonUtils;
import com.masterkenth.RarityChecker;
import com.masterkenth.discord.Author;
import com.masterkenth.discord.Embed;
import com.masterkenth.discord.Field;
import com.masterkenth.discord.Image;
import com.masterkenth.discord.Webhook;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.ItemComposition;
import net.runelite.api.NPC;
import net.runelite.api.events.ChatMessage;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.NpcLootReceived;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.ItemStack;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.loottracker.LootReceived;
import net.runelite.client.ui.DrawManager;
import net.runelite.http.api.loottracker.LootRecordType;
import okhttp3.HttpUrl;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Discord Rare Drop Notificater", description="Sends a detailed notification via Discord webhooks whenever you get a rare/unique drop.", tags={"discord", "loot", "unique", "boss", "notification"})
public class DiscordRareDropNotificaterPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(DiscordRareDropNotificaterPlugin.class);
    private static final String PET_MESSAGE_DUPLICATE = "You have a funny feeling like you would have been followed";
    private static final ImmutableList<String> PET_MESSAGES = ImmutableList.of((Object)"You have a funny feeling like you're being followed", (Object)"You feel something weird sneaking into your backpack", (Object)"You have a funny feeling like you would have been followed", (Object)"You have a funny feeling like you would have been followed");
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private DiscordRareDropNotificaterConfig config;
    @Inject
    private ItemManager itemManager;
    @Inject
    private DrawManager drawManager;
    private final RarityChecker rarityChecker = new RarityChecker();
    private CompletableFuture<java.awt.Image> queuedScreenshot = null;

    @Provides
    DiscordRareDropNotificaterConfig provideConfig(ConfigManager configManager) {
        return (DiscordRareDropNotificaterConfig)configManager.getConfig(DiscordRareDropNotificaterConfig.class);
    }

    protected void startUp() throws Exception {
        JsonUtils.getInstance();
        super.startUp();
    }

    @Subscribe
    public void onNpcLootReceived(NpcLootReceived npcLootReceived) {
        if (this.isPlayerIgnored()) {
            return;
        }
        NPC npc = npcLootReceived.getNpc();
        Collection items = npcLootReceived.getItems();
        ArrayList futures = new ArrayList();
        for (ItemStack item : items) {
            CompletableFuture[] wrapper = new CompletableFuture[1];
            Supplier<CompletableFuture<ItemData>> itemDataSupplier = () -> {
                wrapper[0] = this.getNPCLootReceivedItemData(npc.getName(), item.getId(), item.getQuantity());
                return wrapper[0];
            };
            this.canBeSent(item.getId(), item.getQuantity(), itemDataSupplier).thenAccept(canSent -> {
                if (canSent.booleanValue()) {
                    if (wrapper[0] == null) {
                        log.debug("We're setting the wrapper value");
                        itemDataSupplier.get();
                    }
                    wrapper[0].thenAccept(itemData -> futures.add(this.processNpcNotification(npc, item.getId(), item.getQuantity(), itemData.Rarity)));
                }
            });
        }
        if (futures.size() > 0) {
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).thenAccept(_v -> this.sendScreenshotIfSupposedTo());
        }
        ((CompletableFuture)CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).thenAccept(_v -> this.sendScreenshotIfSupposedTo())).exceptionally(e -> {
            log.error(String.format("onNpcLootReceived error: %s", e.getMessage()), e);
            log.error(String.format("npc %d items %s", npcLootReceived.getNpc().getId(), npcLootReceived.getItems().stream().map(i -> "" + i.getId()).reduce("", (p, c) -> p + ", " + c)));
            return null;
        });
    }

    @Subscribe
    public void onLootReceived(LootReceived lootReceived) {
        if (this.isPlayerIgnored()) {
            return;
        }
        if (lootReceived.getType() == LootRecordType.NPC) {
            return;
        }
        Collection items = lootReceived.getItems();
        ArrayList futures = new ArrayList();
        for (ItemStack item : items) {
            this.canBeSent(item.getId(), item.getQuantity(), () -> this.getLootReceivedItemData(lootReceived.getName(), lootReceived.getType(), item.getId())).thenAccept(canSent -> {
                if (canSent.booleanValue()) {
                    futures.add(this.processEventNotification(lootReceived.getType(), lootReceived.getName(), item.getId(), item.getQuantity()));
                }
            });
        }
        ((CompletableFuture)CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).thenAccept(_v -> this.sendScreenshotIfSupposedTo())).exceptionally(e -> {
            log.error(String.format("onLootReceived error: %s", e.getMessage()), e);
            log.error(String.format("event %s items %s", lootReceived.getName(), lootReceived.getItems().stream().map(i -> "" + i.getId()).reduce("", (p, c) -> p + ", " + c)));
            return null;
        });
        if (futures.size() > 0) {
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).thenAccept(_v -> this.sendScreenshotIfSupposedTo());
        }
    }

    private CompletableFuture<ItemData> getLootReceivedItemData(String eventName, LootRecordType lootRecordType, int itemId) {
        CompletableFuture<ItemData> result = new CompletableFuture<ItemData>();
        ItemData itemData = lootRecordType == LootRecordType.PICKPOCKET ? this.rarityChecker.CheckRarityPickpocket(eventName, this.EnrichItem(itemId), this.itemManager) : this.rarityChecker.CheckRarityEvent(eventName, this.EnrichItem(itemId), this.itemManager);
        result.complete(itemData);
        return result;
    }

    private CompletableFuture<ItemData> getNPCLootReceivedItemData(String npcName, int itemId, int quantity) {
        ItemData incomplete = this.EnrichItem(itemId);
        return this.rarityChecker.CheckRarityNPC(npcName, incomplete, this.itemManager, quantity);
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (this.isPlayerIgnored()) {
            return;
        }
        String chatMessage = event.getMessage();
        if (event.getType() != ChatMessageType.GAMEMESSAGE && event.getType() != ChatMessageType.SPAM && event.getType() != ChatMessageType.TRADE && event.getType() != ChatMessageType.FRIENDSCHATNOTIFICATION) {
            return;
        }
        if (PET_MESSAGES.stream().anyMatch(chatMessage::contains)) {
            boolean isDuplicate = chatMessage.contains(PET_MESSAGE_DUPLICATE);
            log.info(String.format("Possible pet: duplicate=%b (%s, %s) %s", isDuplicate, event.getSender(), event.getName(), event.getMessage()));
            CompletableFuture<java.awt.Image> screenshotFuture = this.config.sendScreenshot() ? this.getScreenshot() : CompletableFuture.completedFuture(null);
            ((CompletableFuture)screenshotFuture.thenApply(screenshot -> this.queuePetNotification(this.getPlayerName(), this.getPlayerIconUrl(), null, -1, isDuplicate).thenCompose(_v -> screenshot != null ? this.sendScreenshot(this.getWebhookUrls(), (java.awt.Image)screenshot) : CompletableFuture.completedFuture(null)))).exceptionally(e -> {
                log.error(String.format("onChatMessage (pet) error: %s", e.getMessage()), e);
                log.error(event.toString());
                return null;
            });
        }
    }

    private boolean isPlayerIgnored() {
        if (this.config.whiteListedRSNs().trim().length() > 0) {
            String playerName = this.getPlayerName().toLowerCase();
            List<String> whiteListedRSNs = Arrays.asList(this.config.whiteListedRSNs().split(","));
            return whiteListedRSNs.stream().noneMatch(rsn -> rsn.length() > 0 && playerName.equals(rsn.toLowerCase()));
        }
        return false;
    }

    private CompletableFuture<Boolean> canBeSent(int itemId, int quantity, Supplier<CompletableFuture<ItemData>> itemDataSupplier) {
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        ItemComposition comp = this.itemManager.getItemComposition(itemId);
        String lowerName = comp.getName().toLowerCase();
        List whitelist = Arrays.stream(this.config.whiteListedItems().split(",")).filter(itemName -> itemName.length() > 0).map(String::toLowerCase).collect(Collectors.toList());
        List blacklist = Arrays.stream(this.config.ignoredKeywords().split(",")).filter(itemName -> itemName.length() > 0).map(String::toLowerCase).collect(Collectors.toList());
        if (log.isDebugEnabled()) {
            log.debug(String.format("Checking if %s can be sent", lowerName));
        }
        if (whitelist.stream().anyMatch(lowerName::equals)) {
            if (log.isDebugEnabled()) {
                log.debug("We're whitelisted. We can be sent");
            }
            result.complete(true);
            return result;
        }
        if (blacklist.stream().anyMatch(lowerName::equals)) {
            if (log.isDebugEnabled()) {
                log.debug("We're blacklisted. We cannot be sent");
            }
            result.complete(false);
            return result;
        }
        if (whitelist.stream().anyMatch(lowerName::contains)) {
            if (log.isDebugEnabled()) {
                log.debug("We're fuzzy whitelisted. We can be sent");
            }
            result.complete(true);
            return result;
        }
        if (blacklist.stream().anyMatch(lowerName::contains)) {
            if (log.isDebugEnabled()) {
                log.debug("We're fuzzy blacklisted. We cannot be sent");
            }
            result.complete(false);
            return result;
        }
        if (log.isDebugEnabled()) {
            log.debug("We're not in any item list. We need to continue our check.");
        }
        return itemDataSupplier.get().thenCompose(itemData -> {
            result.complete(this.meetsRequirements((ItemData)itemData, quantity));
            return result;
        });
    }

    private CompletableFuture<Boolean> processEventNotification(LootRecordType lootRecordType, String eventName, int itemId, int quantity) {
        ItemData itemData = lootRecordType == LootRecordType.PICKPOCKET ? this.rarityChecker.CheckRarityPickpocket(eventName, this.EnrichItem(itemId), this.itemManager) : this.rarityChecker.CheckRarityEvent(eventName, this.EnrichItem(itemId), this.itemManager);
        this.queueScreenshot();
        this.clientThread.invokeLater(() -> this.queueLootNotification(this.getPlayerName(), this.getPlayerIconUrl(), itemId, quantity, itemData.Rarity, -1, -1, null, eventName, this.config.webhookUrl()).thenApply(_v -> true));
        return CompletableFuture.completedFuture(false);
    }

    private boolean meetsRequirements(ItemData item, int quantity) {
        boolean rarityMet;
        if (item == null) {
            return false;
        }
        if (this.config.sendUniques() && item.Unique) {
            return true;
        }
        int totalGeValue = item.GePrice * quantity;
        int totalHaValue = item.HaPrice * quantity;
        boolean valueMet = totalGeValue >= this.config.minValue() || totalHaValue >= this.config.minValue();
        boolean bl = rarityMet = item.Rarity <= 1.0f / (float)this.config.minRarity();
        return this.config.andInsteadOfOr() ? valueMet && rarityMet : valueMet || rarityMet;
    }

    private ItemData EnrichItem(int itemId) {
        ItemData r = new ItemData();
        r.ItemId = itemId;
        r.GePrice = this.itemManager.getItemPrice(itemId);
        r.HaPrice = this.itemManager.getItemComposition(itemId).getHaPrice();
        if (log.isDebugEnabled()) {
            log.debug(MessageFormat.format("Item {0} prices HA{1}, GE{2}", itemId, r.HaPrice, r.GePrice));
        }
        return r;
    }

    private CompletableFuture<Boolean> processNpcNotification(NPC npc, int itemId, int quantity, float rarity) {
        int npcId = npc.getId();
        int npcCombatLevel = npc.getCombatLevel();
        String npcName = npc.getName();
        CompletableFuture<Boolean> f = new CompletableFuture<Boolean>();
        this.queueScreenshot();
        this.clientThread.invokeLater(() -> this.queueLootNotification(this.getPlayerName(), this.getPlayerIconUrl(), itemId, quantity, rarity, npcId, npcCombatLevel, npcName, null, this.config.webhookUrl()).handle((_v, e) -> {
            if (e != null) {
                f.completeExceptionally((Throwable)e);
            } else {
                f.complete(true);
            }
            return null;
        }));
        return f;
    }

    private void queueScreenshot() {
        if (this.queuedScreenshot == null && this.config.sendScreenshot()) {
            this.queuedScreenshot = this.getScreenshot();
        }
    }

    private void sendScreenshotIfSupposedTo() {
        if (this.queuedScreenshot != null && this.config.sendScreenshot()) {
            CompletableFuture<java.awt.Image> copy = this.queuedScreenshot;
            this.queuedScreenshot = null;
            ((CompletableFuture)copy.thenAccept(screenshot -> this.sendScreenshot(this.getWebhookUrls(), (java.awt.Image)screenshot))).handle((v, e) -> {
                if (e != null) {
                    log.error(String.format("sendScreenshotIfSupposedTo error: %s", e.getMessage()), e);
                }
                this.queuedScreenshot = null;
                return null;
            });
        }
    }

    private CompletableFuture<Void> queueLootNotification(String playerName, String playerIconUrl, int itemId, int quantity, float rarity, int npcId, int npcCombatLevel, String npcName, String eventName, String webhookUrl) {
        Webhook webhookData = new Webhook();
        Author author = new Author();
        author.setName(playerName);
        if (playerIconUrl != null) {
            author.setIcon_url(playerIconUrl);
        }
        Embed embed = new Embed();
        embed.setAuthor(author);
        if (this.config.sendRarityAndValue()) {
            Field rarityField = new Field();
            rarityField.setName("Rarity");
            rarityField.setValue(this.getRarityString(rarity));
            rarityField.setInline(true);
            Field haValueField = new Field();
            haValueField.setName("HA Value");
            haValueField.setValue(this.getGPValueString(this.itemManager.getItemComposition(itemId).getHaPrice() * quantity));
            haValueField.setInline(true);
            Field geValueField = new Field();
            geValueField.setName("GE Value");
            geValueField.setValue(this.getGPValueString(this.itemManager.getItemPrice(itemId) * quantity));
            geValueField.setInline(true);
            embed.setFields(new Field[]{rarityField, haValueField, geValueField});
        }
        Image thumbnail = new Image();
        String iconUrl = ApiTool.getInstance().getIconUrl(itemId);
        thumbnail.setUrl(iconUrl);
        embed.setThumbnail(thumbnail);
        CompletionStage descFuture = this.getLootNotificationDescription(itemId, quantity, npcId, npcCombatLevel, npcName, eventName, !this.config.sendEmbeddedMessage()).handle((notifDesc, e) -> {
            if (e != null) {
                log.error(String.format("queueLootNotification (desc %d) error: %s", itemId, e.getMessage()), e);
            }
            embed.setDescription((String)notifDesc);
            if (!this.config.sendEmbeddedMessage()) {
                webhookData.setContent("**" + playerName + "** - " + notifDesc);
            }
            return null;
        });
        return CompletableFuture.allOf(new CompletableFuture[]{descFuture}).thenCompose(_v -> {
            if (this.config.sendEmbeddedMessage()) {
                webhookData.setEmbeds(new Embed[]{embed});
            }
            return this.sendWebhookData(this.getWebhookUrls(), webhookData);
        });
    }

    private CompletableFuture<Void> queuePetNotification(String playerName, String playerIconUrl, String petName, int rarity, boolean isDuplicate) {
        Author author = new Author();
        author.setName(playerName);
        if (playerIconUrl != null) {
            author.setIcon_url(playerIconUrl);
        }
        Embed embed = new Embed();
        embed.setAuthor(author);
        embed.setFields(new Field[0]);
        embed.setDescription(this.getPetNotificationDescription(isDuplicate));
        return CompletableFuture.allOf(new CompletableFuture[0]).thenCompose(_v -> {
            Webhook webhookData = new Webhook();
            webhookData.setEmbeds(new Embed[]{embed});
            return this.sendWebhookData(this.getWebhookUrls(), webhookData);
        });
    }

    private CompletableFuture<java.awt.Image> getScreenshot() {
        CompletableFuture<java.awt.Image> f = new CompletableFuture<java.awt.Image>();
        this.drawManager.requestNextFrameListener(screenshotImage -> f.complete((java.awt.Image)screenshotImage));
        return f;
    }

    private CompletableFuture<Void> sendWebhookData(List<String> webhookUrls, Webhook webhookData) {
        JSONObject json = new JSONObject(webhookData);
        String jsonStr = json.toString();
        ArrayList exceptions = new ArrayList();
        List<CompletableFuture> sends = webhookUrls.stream().map(url -> ((CompletableFuture)ApiTool.getInstance().postRaw((String)url, jsonStr, "application/json").handle((_v, e) -> {
            if (e != null) {
                exceptions.add(e);
            }
            return null;
        })).thenAccept(_v -> {})).collect(Collectors.toList());
        return CompletableFuture.allOf(sends.toArray(new CompletableFuture[sends.size()])).thenCompose(_v -> {
            if (exceptions.size() > 0) {
                log.error(String.format("sendWebhookData got %d error(s)", exceptions.size()));
                exceptions.forEach(t -> log.error(t.getMessage()));
                CompletableFuture f = new CompletableFuture();
                f.completeExceptionally((Throwable)exceptions.get(0));
                return f;
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    private CompletableFuture<Void> sendScreenshot(List<String> webhookUrls, java.awt.Image screenshot) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)((BufferedImage)screenshot), "png", baos);
            byte[] imageBytes = baos.toByteArray();
            ArrayList exceptions = new ArrayList();
            List<CompletableFuture> sends = webhookUrls.stream().map(url -> ((CompletableFuture)ApiTool.getInstance().postFormImage((String)url, imageBytes, "image/png").handle((_v, e) -> {
                if (e != null) {
                    exceptions.add(e);
                }
                return null;
            })).thenAccept(_v -> {})).collect(Collectors.toList());
            return CompletableFuture.allOf(sends.toArray(new CompletableFuture[sends.size()])).thenCompose(_v -> {
                if (exceptions.size() > 0) {
                    log.error(String.format("sendScreenshot got %d error(s)", exceptions.size()));
                    exceptions.forEach(t -> log.error(t.getMessage()));
                    CompletableFuture f = new CompletableFuture();
                    f.completeExceptionally((Throwable)exceptions.get(0));
                    return f;
                }
                return CompletableFuture.completedFuture(null);
            });
        }
        catch (Exception e) {
            log.error("Unable to send screenshot", (Throwable)e);
            return CompletableFuture.completedFuture(null);
        }
    }

    private CompletableFuture<String> getLootNotificationDescription(int itemId, int quantity, int npcId, int npcCombatLevel, String npcName, String eventName, boolean plainText) {
        String baseMsg;
        ItemComposition itemComp = this.itemManager.getItemComposition(itemId);
        String itemUrl = this.getWikiUrl(itemComp.getName());
        String string = plainText ? "Just got **" + (String)(quantity > 1 ? quantity + "x " : "") + itemComp.getName() + "**" : (baseMsg = "Just got " + (String)(quantity > 1 ? quantity + "x " : "") + "[" + itemComp.getName() + "](" + itemUrl + ")");
        if (npcId >= 0) {
            String npcUrl = this.getWikiUrl(npcName);
            String fullMsg = plainText ? baseMsg + " from lvl " + npcCombatLevel + " **" + npcName + "**" : baseMsg + " from lvl " + npcCombatLevel + " [" + npcName + "](" + npcUrl + ")";
            return CompletableFuture.completedFuture(fullMsg);
        }
        if (eventName != null) {
            String eventUrl = this.getWikiUrl(eventName);
            String fullMsg = plainText ? baseMsg + " from **" + eventName + "**" : baseMsg + " from [" + eventName + "](" + eventUrl + ")";
            return CompletableFuture.completedFuture(fullMsg);
        }
        return CompletableFuture.completedFuture(baseMsg + " from something");
    }

    private String getWikiUrl(String search) {
        return HttpUrl.parse((String)"https://oldschool.runescape.wiki/").newBuilder().addPathSegments("w/Special:Search").addQueryParameter("search", search).build().toString();
    }

    private String getPetNotificationDescription(boolean isDuplicate) {
        if (isDuplicate) {
            return "Would've gotten a pet, but already has it.";
        }
        return "Just got a pet.";
    }

    private String getGPValueString(int value) {
        return "```fix\n" + NumberFormat.getNumberInstance(Locale.US).format(value) + " GP\n```";
    }

    private String getRarityString(float rarity) {
        return "```glsl\n# 1/" + 1.0f / rarity + " (" + rarity * 100.0f + "%)\n```";
    }

    private String getPlayerIconUrl() {
        switch (this.client.getAccountType()) {
            case IRONMAN: {
                return "https://oldschool.runescape.wiki/images/0/09/Ironman_chat_badge.png";
            }
            case HARDCORE_IRONMAN: {
                return "https://oldschool.runescape.wiki/images/b/b8/Hardcore_ironman_chat_badge.png";
            }
            case ULTIMATE_IRONMAN: {
                return "https://oldschool.runescape.wiki/images/0/02/Ultimate_ironman_chat_badge.png";
            }
            case GROUP_IRONMAN: {
                return "https://oldschool.runescape.wiki/images/Group_ironman_chat_badge.png";
            }
            case HARDCORE_GROUP_IRONMAN: {
                return "https://oldschool.runescape.wiki/images/Hardcore_group_ironman_chat_badge.png";
            }
        }
        return null;
    }

    private String getPlayerName() {
        return this.client.getLocalPlayer().getName();
    }

    private List<String> getWebhookUrls() {
        return Arrays.asList(this.config.webhookUrl().split("\n")).stream().filter(u -> u.length() > 0).map(u -> u.trim()).collect(Collectors.toList());
    }
}

