/*
 * Decompiled with CFR 0.152.
 */
package com.masterkenth;

import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;

@ConfigGroup(value="discordraredropnotificater")
public interface DiscordRareDropNotificaterConfig
extends Config {
    @ConfigSection(position=1, name="Webhook Options", description="Manage how the plugin sends drops to your discord server")
    public static final String webhookOptionsSection = "webhookOptionsSection";
    @ConfigSection(position=2, name="Item Lists", description="Ignored and whitelisted items")
    public static final String itemListsSection = "itemListsSection";
    @ConfigSection(position=3, name="Item Filters", description="Manage filters that handle if drop should be posted or not")
    public static final String itemFiltersSection = "itemFiltersSection";
    @ConfigSection(position=4, name="Player Filters", description="Manage filters to prevent drops being posted from all your accounts")
    public static final String playerFiltersSection = "playerFiltersSection";

    @ConfigItem(keyName="webhookurl", name="Discord webhook URL(s)", description="The Discord Webhook URL(s) to use, separated by newline", section="webhookOptionsSection", position=1)
    default public String webhookUrl() {
        return "";
    }

    @ConfigItem(keyName="minrarity", name="Min NPC Rarity (1/x)", description="NPC drops more rare than this are posted to Discord", section="itemFiltersSection", position=1)
    default public int minRarity() {
        return 64;
    }

    @ConfigItem(keyName="minvalue", name="Min NPC Value", description="NPC drops more valuable (GE or HA) than this are posted to Discord", section="itemFiltersSection", position=2)
    default public int minValue() {
        return 50000;
    }

    @ConfigItem(keyName="andinsteadofor", name="Require both rarity and value", description="Whether drops should meet both rarity AND value requirements to get posted", section="itemFiltersSection", position=3)
    default public boolean andInsteadOfOr() {
        return false;
    }

    @ConfigItem(keyName="eventuniques", name="Always send uniques (events)", description="Whether unique drops from events should always get posted (COX, TOB, ...)", section="itemFiltersSection", position=4)
    default public boolean sendUniques() {
        return true;
    }

    @ConfigItem(keyName="sendscreenshot", name="Send screenshot", description="Whether to send a screenshot along with the message", section="webhookOptionsSection", position=4)
    default public boolean sendScreenshot() {
        return true;
    }

    @ConfigItem(keyName="ignoredkeywords", name="Ignored items", description="Comma-separated list of items to ignore, keywords are allowed as well", section="itemListsSection", position=1)
    default public String ignoredKeywords() {
        return "grimy,seed";
    }

    @ConfigItem(keyName="whiteListedItems", name="Whitelisted items", description="Comma-separated list of items which you want notifications for regardless of the ignored keywords", section="itemListsSection", position=2)
    default public String whiteListedItems() {
        return "enhanced crystal weapon seed,crystal armour seed";
    }

    @ConfigItem(keyName="whiteListedRSNs", name="Whitelisted RSNs", description="(optional) Comma-separated list of RSNs which are allowed to post to the webhook", section="playerFiltersSection", position=1)
    default public String whiteListedRSNs() {
        return "";
    }

    @ConfigItem(keyName="sendEmbeddedMessage", name="Send embedded message", description="Whether to send a embedded Discord message", section="webhookOptionsSection", position=2)
    default public boolean sendEmbeddedMessage() {
        return true;
    }

    @ConfigItem(keyName="sendRarityAndValue", name="Send rarity and value", description="Whether to send Rarity and Value within the embedded Discord message", section="webhookOptionsSection", position=3)
    default public boolean sendRarityAndValue() {
        return true;
    }
}

