/*
 * Decompiled with CFR 0.152.
 */
package io.hydrox.homes;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;

@PluginDescriptor(name="Home Enforcer", description="Stop your Mahogany Homes from shifting into other realities")
public class HomesPlugin
extends Plugin {
    private static final int MIN = 10554;
    private static final int MAX = 10561;
    private final Map<Integer, Integer> varbs = IntStream.range(10554, 10561).boxed().collect(Collectors.toMap(Function.identity(), e -> 0, (o1, o2) -> o1, LinkedHashMap::new));
    @Inject
    private Client client;
    @Inject
    private ConfigManager configManager;

    public void startUp() {
        String state = this.configManager.getConfiguration("homeenforcer", "state");
        if (state == null) {
            return;
        }
        char[] chars = state.toCharArray();
        for (int i = 0; i < 7; ++i) {
            this.varbs.put(10554 + i, Integer.parseInt(String.valueOf(chars[i])));
        }
    }

    public void shutDown() {
        this.saveState();
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        if (event.getIndex() != 2747) {
            return;
        }
        boolean save = false;
        for (int i : this.varbs.keySet()) {
            int current = this.client.getVarbitValue(i);
            if (current == 0) {
                this.client.setVarbitValue(this.client.getVarps(), i, this.varbs.get(i).intValue());
                continue;
            }
            this.client.setVarbitValue(this.client.getVarps(), i, current);
            this.varbs.put(i, current);
            save = true;
        }
        if (save) {
            this.saveState();
        }
    }

    private void saveState() {
        this.configManager.setConfiguration("homeenforcer", "state", IntStream.range(10554, 10561).map(this.varbs::get).mapToObj(String::valueOf).collect(Collectors.joining()));
    }
}

