/*
 * Decompiled with CFR 0.152.
 */
package com.afkmarkscanafis;

import com.afkmarkscanafis.AfkMarksCanafisConfig;
import com.afkmarkscanafis.AfkMarksCanafisOverlay;
import com.google.inject.Provides;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.Skill;
import net.runelite.api.TileItem;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemSpawned;
import net.runelite.api.events.StatChanged;
import net.runelite.client.Notifier;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Afk Marks Canafis")
public class AfkMarksCanafisPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(AfkMarksCanafisPlugin.class);
    private static final int CANAFIS_LAST_OBSTACLE_XP = 175;
    private static final int CANAFIS_REGION_ID = 13878;
    private static final int SECONDS_LEEWAY = 2;
    private static final int MARK_COOLDOWN_MINUTES = 3;
    @Inject
    private Client client;
    @Inject
    private AfkMarksCanafisConfig config;
    @Inject
    private Notifier notifier;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private AfkMarksCanafisOverlay agilityOverlay;
    public ZonedDateTime markCooldownCompleteTime;
    public ZonedDateTime lastCompleteTime;
    public boolean shouldRun = true;
    private int lastAgilityXp;

    @Provides
    AfkMarksCanafisConfig provideConfig(ConfigManager configManager) {
        return (AfkMarksCanafisConfig)configManager.getConfig(AfkMarksCanafisConfig.class);
    }

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.agilityOverlay);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.agilityOverlay);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN) {
            this.markCooldownCompleteTime = null;
            this.lastCompleteTime = null;
        }
    }

    @Subscribe
    public void onStatChanged(StatChanged statChanged) {
        if (statChanged.getSkill() != Skill.AGILITY) {
            return;
        }
        int agilityXp = this.client.getSkillExperience(Skill.AGILITY);
        int skillGained = agilityXp - this.lastAgilityXp;
        this.lastAgilityXp = agilityXp;
        if (this.client.getLocalPlayer().getWorldLocation().getRegionID() != 13878 || Math.abs(175 - skillGained) > 1) {
            return;
        }
        Instant now = Instant.now();
        ZonedDateTime zonedNow = now.atZone(ZoneOffset.UTC);
        this.lastCompleteTime = zonedNow.truncatedTo(ChronoUnit.MINUTES);
        if (zonedNow.getSecond() >= 58) {
            this.lastCompleteTime = this.lastCompleteTime.plusMinutes(1L);
        }
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        if (this.isInCanafisArea() && !this.shouldRun) {
            if (this.markCooldownCompleteTime == null) {
                this.shouldRun = true;
                return;
            }
            Instant now = Instant.now();
            ZonedDateTime zonedNow = now.atZone(ZoneOffset.UTC);
            if (zonedNow.isAfter(this.markCooldownCompleteTime)) {
                this.shouldRun = true;
                this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Mark cooldown finished, run", null);
                this.notifier.notify("Mark of grace cooldown finished");
            }
        }
    }

    @Subscribe
    public void onItemSpawned(ItemSpawned itemSpawned) {
        if (!this.isInCanafisArea()) {
            return;
        }
        TileItem item = itemSpawned.getItem();
        if (item.getId() == 11849) {
            this.markCooldownCompleteTime = this.lastCompleteTime.plusMinutes(3L).plusSeconds(2L);
            this.shouldRun = false;
        }
    }

    private boolean isInCanafisArea() {
        Player local = this.client.getLocalPlayer();
        if (local == null) {
            return false;
        }
        WorldPoint location = local.getWorldLocation();
        return location.getRegionID() == 13878;
    }
}

