/*
 * Decompiled with CFR 0.152.
 */
package com.afkmarkscanafis;

import com.afkmarkscanafis.AfkMarksCanafisPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import javax.inject.Inject;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

class AfkMarksCanafisOverlay
extends OverlayPanel {
    private static final int TIMEOUT = 10;
    private final AfkMarksCanafisPlugin plugin;

    @Inject
    public AfkMarksCanafisOverlay(AfkMarksCanafisPlugin plugin) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.plugin = plugin;
    }

    public Dimension render(Graphics2D graphics) {
        if (this.plugin.markCooldownCompleteTime == null) {
            return null;
        }
        Duration markTimeout = Duration.ofMinutes(10L);
        Duration sinceLastComplete = Duration.between(this.plugin.lastCompleteTime, Instant.now().atZone(ZoneOffset.UTC));
        if (sinceLastComplete.compareTo(markTimeout) >= 0) {
            this.plugin.markCooldownCompleteTime = null;
            this.plugin.lastCompleteTime = null;
            return null;
        }
        if (this.plugin.shouldRun) {
            this.panelComponent.getChildren().add(TitleComponent.builder().text("Run").color(Color.GREEN).build());
        } else {
            this.panelComponent.getChildren().add(TitleComponent.builder().text("Wait").color(Color.RED).build());
        }
        long s = Math.max(Duration.between(Instant.now().atZone(ZoneOffset.UTC), this.plugin.markCooldownCompleteTime).getSeconds(), 0L);
        this.panelComponent.getChildren().add(LineComponent.builder().left("Time until run:").right(String.format("%d:%02d", s % 3600L / 60L, s % 60L)).build());
        return super.render(graphics);
    }
}

