/*
 * Decompiled with CFR 0.152.
 */
package com.raidspeedruntracker;

import com.raidspeedruntracker.RaidRoom;
import java.awt.Color;
import java.time.Duration;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;

public class Split {
    Duration pbDuration;
    transient Duration timeDifference;
    transient Duration originalPbDuration;
    transient Duration newPbDuration;
    transient String pbString;
    transient String splitString;
    RaidRoom raidRoom;
    transient Color splitColor;

    public Split(RaidRoom raidRoom) {
        this.originalPbDuration = this.pbDuration;
        this.splitColor = Color.WHITE;
        this.raidRoom = raidRoom;
    }

    public String getPbString() {
        if (this.pbString == null && this.pbDuration != null) {
            this.pbString = this.getFormattedTimeString(this.pbDuration);
        }
        if (this.pbDuration == null) {
            return "-";
        }
        return this.pbString;
    }

    public String getSplitString() {
        if (this.splitString == null && this.timeDifference != null) {
            this.splitString = this.timeDifference.isNegative() ? "-" : "+";
            this.splitString = this.splitString + this.getFormattedTimeString(this.timeDifference.abs());
        }
        return this.splitString;
    }

    private String getFormattedTimeString(Duration duration) {
        LocalTime time;
        String formattedTime = time.format((time = LocalTime.ofSecondOfDay(duration.getSeconds())).getHour() > 0 ? DateTimeFormatter.ofPattern("HH:mm:ss") : DateTimeFormatter.ofPattern("mm:ss"));
        return formattedTime;
    }

    public Duration getPbDuration() {
        return this.pbDuration;
    }

    public Duration getTimeDifference() {
        return this.timeDifference;
    }

    public Duration getOriginalPbDuration() {
        return this.originalPbDuration;
    }

    public Duration getNewPbDuration() {
        return this.newPbDuration;
    }

    public RaidRoom getRaidRoom() {
        return this.raidRoom;
    }

    public Color getSplitColor() {
        return this.splitColor;
    }

    public void setPbDuration(Duration pbDuration) {
        this.pbDuration = pbDuration;
    }

    public void setTimeDifference(Duration timeDifference) {
        this.timeDifference = timeDifference;
    }

    public void setOriginalPbDuration(Duration originalPbDuration) {
        this.originalPbDuration = originalPbDuration;
    }

    public void setNewPbDuration(Duration newPbDuration) {
        this.newPbDuration = newPbDuration;
    }

    public void setPbString(String pbString) {
        this.pbString = pbString;
    }

    public void setSplitString(String splitString) {
        this.splitString = splitString;
    }

    public void setRaidRoom(RaidRoom raidRoom) {
        this.raidRoom = raidRoom;
    }

    public void setSplitColor(Color splitColor) {
        this.splitColor = splitColor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Split)) {
            return false;
        }
        Split other = (Split)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Duration this$pbDuration = this.getPbDuration();
        Duration other$pbDuration = other.getPbDuration();
        if (this$pbDuration == null ? other$pbDuration != null : !((Object)this$pbDuration).equals(other$pbDuration)) {
            return false;
        }
        RaidRoom this$raidRoom = this.getRaidRoom();
        RaidRoom other$raidRoom = other.getRaidRoom();
        return !(this$raidRoom == null ? other$raidRoom != null : !((Object)((Object)this$raidRoom)).equals((Object)other$raidRoom));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Split;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Duration $pbDuration = this.getPbDuration();
        result = result * 59 + ($pbDuration == null ? 43 : ((Object)$pbDuration).hashCode());
        RaidRoom $raidRoom = this.getRaidRoom();
        result = result * 59 + ($raidRoom == null ? 43 : ((Object)((Object)$raidRoom)).hashCode());
        return result;
    }

    public String toString() {
        return "Split(pbDuration=" + this.getPbDuration() + ", timeDifference=" + this.getTimeDifference() + ", originalPbDuration=" + this.getOriginalPbDuration() + ", newPbDuration=" + this.getNewPbDuration() + ", pbString=" + this.getPbString() + ", splitString=" + this.getSplitString() + ", raidRoom=" + this.getRaidRoom() + ", splitColor=" + this.getSplitColor() + ")";
    }
}

