/*
 * Decompiled with CFR 0.152.
 */
package com.raidspeedruntracker;

import com.google.inject.Provides;
import com.raidspeedruntracker.CoxUtil;
import com.raidspeedruntracker.RaidRoom;
import com.raidspeedruntracker.RaidSpeedRunFileReadWrite;
import com.raidspeedruntracker.RaidSpeedRunTrackerConfig;
import com.raidspeedruntracker.RaidSpeedRunTrackerOverlay;
import com.raidspeedruntracker.SpeedRun;
import com.raidspeedruntracker.SpeedRunTracker;
import com.raidspeedruntracker.Split;
import java.awt.Color;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.Point;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Raid Speed Run Tracker")
public class RaidSpeedRunTrackerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(RaidSpeedRunTrackerPlugin.class);
    @Inject
    private Client client;
    @Inject
    private RaidSpeedRunTrackerConfig config;
    @Inject
    private SpeedRunTracker speedRunTracker;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private RaidSpeedRunTrackerOverlay overlay;
    private RaidSpeedRunFileReadWrite fw = new RaidSpeedRunFileReadWrite();
    private int[] cryp = new int[16];
    private int[] cryx = new int[16];
    private int[] cryy = new int[16];
    private static final String RAID_COMPLETE_MESSAGE = "Congratulations - your raid is complete!";
    private static final String RAID_START_MESSAGE = "The raid has begun!";
    private static final int CM_FLAG_VARBIT = 6385;

    protected void startUp() throws Exception {
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN) {
            this.fw.updateUsername(this.client.getUsername());
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() == ChatMessageType.FRIENDSCHATNOTIFICATION || event.getType() == ChatMessageType.GAMEMESSAGE) {
            String message = Text.removeTags((String)event.getMessage());
            if (message.startsWith(RAID_COMPLETE_MESSAGE)) {
                this.split();
            }
            if (message.startsWith(RAID_START_MESSAGE)) {
                this.speedRunTracker.setRaidStarted(true);
            }
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        boolean raidStarted = this.client.getVar(5425) > 0;
        boolean inRaid = this.client.getVar(5432) == 1;
        boolean isCm = this.client.getVarbitValue(6385) == 1;
        int teamSize = this.client.getVar(5424);
        if (this.speedRunTracker.isRaidStarted() && inRaid && !this.speedRunTracker.isRaidInProgress() && isCm) {
            this.speedRunTracker.setTeamSize(teamSize);
            this.speedRunTracker.setRaidInProgress(true);
            this.speedRunTracker.setStartTime(Instant.now());
            this.loadSplits(teamSize);
            this.overlayManager.add((Overlay)this.overlay);
        } else if (this.speedRunTracker.raidInProgress && !inRaid) {
            this.ResetSpeedRunTracker();
        } else if (this.speedRunTracker.isRaidInProgress() && inRaid && teamSize > this.speedRunTracker.getTeamSize()) {
            this.speedRunTracker.setTeamSize(teamSize);
            this.loadSplits(teamSize);
        }
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned e) {
        GameObject go = e.getGameObject();
        switch (go.getId()) {
            case 26209: 
            case 29741: 
            case 29749: 
            case 29753: 
            case 29754: 
            case 29755: 
            case 29756: 
            case 29757: 
            case 29876: 
            case 30016: 
            case 30017: 
            case 30018: 
            case 30070: {
                Point pt = go.getSceneMinLocation();
                int p = go.getPlane();
                int x = pt.getX();
                int y = pt.getY();
                int template = this.client.getInstanceTemplateChunks()[p][x / 8][y / 8];
                int roomtype = CoxUtil.getroom_type(template);
                if (roomtype >= 16) break;
                this.cryp[roomtype] = p;
                this.cryx[roomtype] = x + this.client.getBaseX();
                this.cryy[roomtype] = y + this.client.getBaseY();
            }
        }
    }

    @Subscribe
    public void onClientTick(ClientTick e) {
        for (int i = 0; i < 16; ++i) {
            if (this.cryp[i] == -1) continue;
            int p = this.cryp[i];
            int x = this.cryx[i] - this.client.getBaseX();
            int y = this.cryy[i] - this.client.getBaseY();
            if (p != this.client.getPlane() || x < 0 || x >= 104 || y < 0 || y >= 104) {
                this.cryp[i] = -1;
                continue;
            }
            int flags = this.client.getCollisionMaps()[p].getFlags()[x][y];
            if ((flags & 0x100) != 0) continue;
            this.split();
            this.cryp[i] = -1;
        }
    }

    @Provides
    RaidSpeedRunTrackerConfig provideConfig(ConfigManager configManager) {
        return (RaidSpeedRunTrackerConfig)configManager.getConfig(RaidSpeedRunTrackerConfig.class);
    }

    public Split getSplit(RaidRoom raidRoom) {
        SpeedRun speedRun = this.speedRunTracker.getCurrentSpeedRun();
        for (Split split : speedRun.getSplits()) {
            if (split.raidRoom != raidRoom) continue;
            return split;
        }
        return null;
    }

    public Split[] getSplits() {
        return this.speedRunTracker.getCurrentSpeedRun().getSplits();
    }

    public RaidRoom getCurrentRoom() {
        return this.speedRunTracker.getCurrentRoom();
    }

    public Instant GetStartTime() {
        return this.speedRunTracker.getStartTime();
    }

    public boolean IsRaidComplete() {
        return this.speedRunTracker.raidComplete;
    }

    private void loadSplits(int teamSize) {
        List<SpeedRun> speedRuns = this.fw.LoadData();
        if (speedRuns != null) {
            for (SpeedRun speedRun : speedRuns) {
                if (speedRun.getTeamSize() != teamSize) continue;
                for (Split split : speedRun.getSplits()) {
                    split.setOriginalPbDuration(split.getOriginalPbDuration());
                }
                this.speedRunTracker.setCurrentSpeedRun(speedRun);
            }
            this.speedRunTracker.setSpeedRuns(speedRuns);
        }
        this.speedRunTracker.getCurrentSpeedRun().setTeamSize(teamSize);
    }

    private void split() {
        RaidRoom currentRoom = this.speedRunTracker.getCurrentRoom();
        Split split = this.getSplit(currentRoom);
        Instant startTime = this.speedRunTracker.getStartTime();
        Duration timeDifference = Duration.between(startTime, Instant.now());
        if (split.pbDuration != null) {
            split.setNewPbDuration(timeDifference);
            timeDifference = timeDifference.minus(split.pbDuration);
            split.setTimeDifference(timeDifference);
            if (timeDifference.isNegative()) {
                split.setSplitColor(Color.GREEN);
            } else {
                split.setSplitColor(Color.RED);
            }
        } else {
            split.setPbDuration(timeDifference);
            split.setNewPbDuration(timeDifference);
            split.setTimeDifference(timeDifference);
            split.setSplitString("-");
        }
        if (currentRoom == RaidRoom.OLM) {
            Duration raidTotalTime = Duration.between(startTime, Instant.now());
            Split pbTime = this.getSplit(RaidRoom.OLM);
            if (pbTime.originalPbDuration == null || raidTotalTime.compareTo(pbTime.originalPbDuration) < 0) {
                SpeedRun currentRun = this.speedRunTracker.getCurrentSpeedRun();
                Split[] newPbSplits = this.buildNewPb(currentRun.getSplits());
                List<SpeedRun> speedRuns = this.speedRunTracker.getSpeedRuns();
                boolean added = false;
                for (SpeedRun speedRun : speedRuns) {
                    if (this.speedRunTracker.getCurrentSpeedRun() != speedRun) continue;
                    speedRun.setSplits(newPbSplits);
                    added = true;
                }
                if (!added) {
                    speedRuns = new ArrayList<SpeedRun>(speedRuns);
                    speedRuns.add(currentRun);
                    this.speedRunTracker.setSpeedRuns(speedRuns);
                }
                this.fw.SaveData(speedRuns);
            }
            this.speedRunTracker.setRaidComplete(true);
        } else {
            this.speedRunTracker.setCurrentRoom(currentRoom.getNext());
        }
    }

    private Split[] buildNewPb(Split[] splits) {
        for (int i = 0; i < splits.length; ++i) {
            if (splits[i].newPbDuration == null) continue;
            splits[i].pbDuration = splits[i].newPbDuration;
        }
        return splits;
    }

    private void ResetSpeedRunTracker() {
        this.speedRunTracker = new SpeedRunTracker();
        this.overlayManager.remove((Overlay)this.overlay);
    }

    public void setFw(RaidSpeedRunFileReadWrite fw) {
        this.fw = fw;
    }
}

