/*
 * Decompiled with CFR 0.152.
 */
package com.raidspeedruntracker;

import com.google.inject.Inject;
import com.raidspeedruntracker.RaidRoom;
import com.raidspeedruntracker.RaidSpeedRunTrackerConfig;
import com.raidspeedruntracker.RaidSpeedRunTrackerPlugin;
import com.raidspeedruntracker.Split;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import net.runelite.api.Client;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class RaidSpeedRunTrackerOverlay
extends Overlay {
    private final Client client;
    private final RaidSpeedRunTrackerConfig config;
    private final PanelComponent panelComponent = new PanelComponent();
    private final RaidSpeedRunTrackerPlugin raidSpeedRunTrackerPlugin;
    private static final String HOUR_FORMAT = "HH:mm:ss";
    private static final String MINUTE_FORMAT = "mm:ss";
    private static final String MILLISECOND_FORMAT = "ss.ss";

    @Inject
    public RaidSpeedRunTrackerOverlay(Client client, RaidSpeedRunTrackerConfig config, RaidSpeedRunTrackerPlugin raidSpeedRunTrackerPlugin) {
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.client = client;
        this.config = config;
        this.raidSpeedRunTrackerPlugin = raidSpeedRunTrackerPlugin;
    }

    public Dimension render(Graphics2D graphics) {
        Duration elapsed;
        this.panelComponent.getChildren().clear();
        String overlayTitle = "CoX Splits";
        this.panelComponent.getChildren().add(TitleComponent.builder().text(overlayTitle).color(Color.white).build());
        Instant startTime = this.raidSpeedRunTrackerPlugin.GetStartTime();
        RaidRoom currentRoom = this.raidSpeedRunTrackerPlugin.getCurrentRoom();
        boolean isRaidComplete = this.raidSpeedRunTrackerPlugin.IsRaidComplete();
        Color timeColor = Color.WHITE;
        Split[] splits = this.raidSpeedRunTrackerPlugin.getSplits();
        int offset = this.config.numLines() / 2;
        int startRoomIndex = currentRoom.getPosition();
        startRoomIndex = startRoomIndex + this.config.numLines() > splits.length + 1 ? splits.length - this.config.numLines() : (startRoomIndex - offset < 0 ? 0 : (startRoomIndex -= offset));
        for (int i = startRoomIndex; i < this.config.numLines() + startRoomIndex; ++i) {
            boolean currentRow;
            Split split = splits[i];
            Object splitString = "";
            Color splitColor = Color.WHITE;
            boolean bl = currentRow = i == currentRoom.getPosition() && !isRaidComplete;
            if (currentRow) {
                if (split.timeDifference == null && split.pbDuration != null) {
                    Duration splitDuration = Duration.between(startTime, Instant.now());
                    splitDuration = splitDuration.minus(split.pbDuration);
                    LocalTime splitTime = LocalTime.ofSecondOfDay(splitDuration.abs().getSeconds());
                    if (splitDuration.isNegative()) {
                        splitColor = Color.GREEN;
                        splitString = (String)splitString + "-";
                        if (!isRaidComplete) {
                            timeColor = Color.GREEN;
                        }
                    } else {
                        splitColor = Color.RED;
                        splitString = (String)splitString + "+";
                        if (!isRaidComplete) {
                            timeColor = Color.RED;
                        }
                    }
                    DateTimeFormatter splitTimeFormat = this.getTimeFormat(splitTime);
                    splitString = (String)splitString + splitTime.format(splitTimeFormat);
                }
            } else if (split.getSplitString() != null) {
                splitString = split.getSplitString();
                splitColor = split.getSplitColor();
            }
            this.panelComponent.getChildren().add(LineComponent.builder().left(split.raidRoom.getName() + (currentRow ? " <-" : "")).right((String)splitString + " " + split.getPbString()).rightColor(splitColor).build());
        }
        if (this.raidSpeedRunTrackerPlugin.IsRaidComplete()) {
            Split endSplit = this.raidSpeedRunTrackerPlugin.getSplit(RaidRoom.OLM);
            elapsed = endSplit.getNewPbDuration();
            Duration originalPbDuration = endSplit.originalPbDuration;
            if (originalPbDuration != null) {
                timeColor = elapsed.compareTo(originalPbDuration) < 0 ? Color.GREEN : Color.RED;
            }
        } else {
            elapsed = Duration.between(startTime, Instant.now());
        }
        LocalTime time = LocalTime.ofSecondOfDay(elapsed.getSeconds());
        DateTimeFormatter timeFormat = this.getTimeFormat(time);
        String formattedTime = time.format(timeFormat);
        this.panelComponent.getChildren().add(LineComponent.builder().left("Time:").right(formattedTime).rightColor(timeColor).build());
        this.panelComponent.setPreferredSize(new Dimension(185, 0));
        return this.panelComponent.render(graphics);
    }

    private DateTimeFormatter getTimeFormat(LocalTime time) {
        return DateTimeFormatter.ofPattern(time.getHour() > 0 ? HOUR_FORMAT : MINUTE_FORMAT);
    }
}

